/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: few.c,v 6.3.2.1 2002/10/09 19:48:51 brbarret Exp $
 * 
 *	Function:	- forks, execs and waits for a subordinate program
 *	Accepts:	- argument vector, argv[0] is program
 *	Returns:	- status code or ERROR
 */

#include <errno.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <unistd.h>

int
_lam_few(argv)

char			*argv[];

{
	int		status;		/* exit status */
	int		pid;		/* whoami? */

	if ((pid = fork()) < 0) {
		return(pid);
    	}

	else if (pid == 0) {		/* child */
		execvp(argv[0], argv);
		exit(errno);
    	}

	else {				/* parent */

		while ((waitpid(pid, &status, 0) != 0) &&
				(! WIFEXITED(status)));
	}

	return(WEXITSTATUS(status));
}
