/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *
 *	$Id: haltd.c,v 1.3.2.1 2002/10/09 19:48:44 brbarret Exp $
 * 
 *	Function:	- halt server
 *			- if receive local message, rebroadcast to all 
 *                        others, then die
 *			- if receive non-local message, die
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#include <lam_config.h>

#include <events.h>
#include <dl_inet.h>
#include <portable.h>
#include <hreq.h>
#include <net.h>
#include <preq.h>
#include <terror.h>
#include <args.h>

/*
 * local variables
 */
static char		msg[MAXNMSGLEN];	/* halt message */
static struct nmsg	nhead;			/* halt network message */


/*
 * local functions
 */
static void             diediedie(char *killname);


/*
 * global functions
 */
void			(*(h_init()))();
void			(*(haltd()))();


/*
 *	h_init
 *
 *	Function:	- haltd initialization
 */
void (*(
h_init()))()

{
/*
 * Attach to kernel.
 */
  if (lpattach("haltd")) {
    lampanic("haltd (lpattach)");
  }
/*
 * Receive first request.
 */
  LAM_ZERO_ME(nhead);
  memset((void*) msg, -1, MAXNMSGLEN);
  nhead.nh_event = EVHALTD;
  nhead.nh_type = 0;
  nhead.nh_flags = 0;
  nhead.nh_length = MAXNMSGLEN;
  nhead.nh_msg = msg;
  
  if (nrecv(&nhead)) {
    panic("haltd (nrecv)");
  }
  
  return((void (*)()) haltd);
}

/*
 *	haltd
 *
 *	Function:	- server loop
 *			- if local message, rebroadcast to all links
 *			- if non-local message, die
 */
void
(*(haltd()))()

{
  struct nmsg ack;
  struct hreq *request;		/* request from client */
  char *killname = nhead.nh_msg;

  request = (struct hreq *) nhead.nh_data;

/*
 * If this was the ping, send an ACK back
 */
  if (nhead.nh_type == LAM_HALT_PING) {
    LAM_ZERO_ME(ack);
    ack.nh_event = request->hq_event;
    ack.nh_node = request->hq_node;
    ack.nh_type = 0;
    ack.nh_flags = 0;
    ack.nh_length = 0;
    request = (struct hreq *) ack.nh_data;
    request->hq_node = getnodeid();
    request->hq_event = 0;
    nsend(&ack);
  }

/*
 * Otherwise, if it was the kill message, die
 */
  else if (nhead.nh_type == LAM_HALT_DIE) 
    diediedie(killname);

/*
 * Just to cover our bases, receive the next request 
 */
  nhead.nh_event = EVHALTD;
  nhead.nh_type = 0;
  nhead.nh_flags = 0;
  nhead.nh_length = MAXNMSGLEN;
  nhead.nh_msg = msg;
  
  if (nrecv(&nhead)) {
    panic("haltd (nrecv)");
  }
/*
 * Kinda overkill, since we'll be dying shortly, anyway!
 */
  return((void (*)()) haltd);
}


/*
 * kill the lamd
 * simply fork off tkill to do the dirty work, potentially with a -b
 * argument (since tkill knows how to kill the named sockets, etc.)
 */
static void
diediedie(char *killname)
{
  int argc = 0;
  char **argv = NULL;

/*
 * Setup tkill to kill us
 */
  sfh_argv_add(&argc, &argv, "tkill");
  if (strlen(killname) != 0) {
    sfh_argv_add(&argc, &argv, "-b");
    sfh_argv_add(&argc, &argv, killname);
  }
/*
 * fork off a child to launch tkill in.  If tkill fails to launch,
 * just kill the parent.  Not quite clean, and it leaves the sockets
 * around, but oh well..
 */
  if (fork() == 0) {
/*
 * Give remote processes a moment to clean up
 */
    sleep(1);
    execvp(argv[0], argv);
/*
 * Oops -- execvp failed.  It shouldn't, because tkill should be in
 * the path.  Oh well -- kill the parent.
 */
    if (kill(getppid(), SIGHUP))
      if (kill(getppid(), SIGINT))
	if (kill(getppid(), SIGKILL))
	  lampanic("haltd (kill)");
    exit(1);
  }
  
/*
 * tkill should get us, any moment now... 
 */
  while(1)
    sleep(1024);
}
