// -*- c++ -*-
//
// $Id: group.cc,v 1.1.1.1.2.1 2001/10/29 04:33:14 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include "mpi++.h"

int MPI::Group::Get_size() const
{
  return pmpi_group.Get_size();
}

int MPI::Group::Get_rank() const 
{
  return pmpi_group.Get_rank();
}

void MPI::Group::Translate_ranks(const MPI::Group& group1, int n, const int ranks1[], 
				 const MPI::Group& group2, int ranks2[])
{
  PMPI::Group::Translate_ranks(group1, n, ranks1, group2, ranks2);
}

int MPI::Group::Compare(const MPI::Group& group1, const MPI::Group& group2)
{
  return PMPI::Group::Compare(group1, group2);
}

MPI::Group MPI::Group::Union(const MPI::Group &group1, const MPI::Group &group2)
{
  return PMPI::Group::Union(group1, group2);
}

MPI::Group MPI::Group::Intersect(const MPI::Group &group1, const MPI::Group &group2)
{
  return PMPI::Group::Intersect(group1, group2);
}

MPI::Group MPI::Group::Difference(const MPI::Group &group1, const MPI::Group &group2)
{
  return PMPI::Group::Difference(group1, group2);
}

MPI::Group MPI::Group::Incl(int n, const int ranks[]) const
{
  return pmpi_group.Incl(n, ranks);
}

MPI::Group MPI::Group::Excl(int n, const int ranks[]) const
{
  return pmpi_group.Excl(n, ranks);
}

MPI::Group MPI::Group::Range_incl(int n, const int ranges[][3]) const
{
  return pmpi_group.Range_incl(n, ranges);
}

MPI::Group MPI::Group::Range_excl(int n, const int ranges[][3]) const
{
  return pmpi_group.Range_excl(n, ranges);
}

void MPI::Group::Free()
{
  pmpi_group.Free();
}
