dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_get_sizeof.m4,v 1.2.2.2 2002/10/09 19:48:24 brbarret Exp $
dnl

define(LAM_GET_SIZEOF,[
# Determine datatype size. 
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(size of $1)
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
int main(int argc, char** argv)
{
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    fprintf(f, "%d\n", sizeof($1));
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_size=`cat conftestval`
else
    lam_ac_size=0
fi
AC_MSG_RESULT($lam_ac_size)
if test -n "$2"; then
    AC_DEFINE_UNQUOTED($2,$lam_ac_size)
fi
/bin/rm -f conftest*])dnl
