/*
 * log.h - log streams handling classes
 * $Id: log.h,v 1.8 2003/01/26 09:09:08 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_LOG_H

# define __TCPREEN_LOG_H
# include <stdio.h>

/*
 * Virtual base class for log files
 */
class DataLog
{
	protected:
		FILE *out; /* output stream */
	
	private:
		int close_out;

	public:
		DataLog (void) : out (NULL), close_out (0)
		{
		}
		
		operator void* (void)
		{
			return (out != NULL) ? this : NULL;
		}
		
		int operator! (void) const
		{
			return out == NULL;
		}

		virtual ~DataLog (void);

		FILE *SetStream (FILE *stream, int do_close = 1)
		{
			close_out = do_close;
			return out = stream;
		}

		virtual int WriteClientData (const void *data, int length,
						int oob = 0);
		virtual int WriteServerData (const void *data, int length,
						int oob = 0);
		virtual void ShutdownServer (void);
		virtual void ShutdownClient (void);
		virtual void Connect (const char *server, const char *client);
};


/*
 * Class of lists of DataLog objects
 */
class DataLogList
{
	private:
		struct listnode
		{
			DataLog *log;
			struct listnode *next;
		} *head;

	public:
		DataLogList (void) : head (NULL)
		{
		}

		~DataLogList (void);
		int AddLog (DataLog *log);
		/* Adds a log in the list (it is assumed that the log was
		 * dynamically allocated with `new'). Returns -1 on error (in
		 * this case, log is NOT deleted) or if log is NULL, 0 on
		 * success. */

		void Connect (const char *server, const char *client);
		void WriteServerData (const void *data, int length,
					int excpt = 0);
		void WriteClientData (const void *data, int length,
					int excpt = 0);
		void ShutdownServer (void);
		void ShutdownClient (void);

		int operator ! (void) const
		{
			return head != NULL;
		}
		
		operator void * (void)
		{
			return (head != NULL) ? this : NULL;
		}	
};


class DataLogListMaker
{
	private:
		struct listnode
		{
			DataLog *(*maker) (void);
			struct listnode *next;
			FILE *stream;
			const char *basename;
		} *head;

	public:
		DataLogListMaker (void) : head (NULL)
		{
		}
		
		~DataLogListMaker (void);

		int operator! (void) const
		{
			return head == NULL;
		}

		operator void * (void)
		{
			return (head != NULL) ? this : NULL;
		}

		int AddLogMaker (DataLog *(*maker) (void),
				FILE *stream = stdout);
		int AddLogMaker (DataLog *(*maker) (void),
				const char *prefix);
		DataLogList *MakeLogList (const char *suffix = NULL);
};

#endif

