/* newapc.h - command table for APC smart protocol units

	$Id: newapc.h,v 1.1.2.13 2000/12/06 11:03:20 cvs Exp $

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>
             (C) 2000  Nigel Metheringham <Nigel.Metheringham@Intechnology.co.uk>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#define APC_TABLE_VERSION	"$Revision: 1.1.2.13 $"

/* Basic UPS reply line structure */
#define ENDCHAR 10		/* APC ends responses with LF */
#define IGNCHARS "\015+$|!~%?=*#&"	/* special characters to ignore */
#define MINIGNCHARS "\015+$|!"	/* minimum set of special characters to ignore */

/* dangerous instant commands must be reconfirmed within a 12 second window */
#define CONFIRM_DANGEROUS_COMMANDS 1
#define MINCMDTIME	3
#define MAXCMDTIME	15


/* Driver command table flag values */
#define APC_TYPEMASK	3
#define APC_POLL	0x10	/* Poll this variable */
#define APC_IGNORE	0x20	/* Never poll this */
#define APC_CMD		0x60	/* This is a command - => ignored by collector */
#define APC_NASTY	0x80	/* Nasty command - take care */
#define APC_REPEAT	0x100	/* Command needs sending twice */
#define APC_PRESENT	0x1000	/* Capability seen on this UPS */
#define APC_FORMATMASK	0xFF0000 /* Mask for apc data formats */
#define APC_F_ST	0x010000 /* Status format */
#define APC_F_PERCENT	0x020000 /* Data in a percent format */
#define APC_F_VOLT	0x030000 /* Data in a voltage format */
#define APC_F_AMP	0x040000 /* Data in a current/amp format */
#define APC_F_CELCIUS	0x050000 /* Data in a temp/C format */
#define APC_F_HEX	0x060000 /* Data in a hex number format */
#define APC_F_DEC	0x070000 /* Data in a decimal format */
#define APC_F_SECONDS	0x100000 /* Time in seconds */
#define APC_F_MINUTES	0x110000 /* Time in minutes */
#define APC_F_HOURS	0x120000 /* Time in hours */
#define APC_F_LEAVE	0	/* Just pass this through */

#define CMD_MASK	0x2000	/* Mask off CMD_ from INFO_ */
#define DRV_MASK	0x4000	/* Mask off DRV_ values */

#define DRV_CMDSET	0x4001	/* Query command set */
#define DRV_CAPABILITY	0x4002	/* Query capabilities */
#define DRV_NEXT	0x4003	/* Next value */
#define DRV_SMART	0x4004	/* Enter Smart mode */
#define DRV_ABORT	0x4005	/* Abort shutdown */
#define DRV_SHUTDN	0x4006	/* Do shutdown */
#define DRV_SEP		0x4007	/* Separator char */
#define DRV_RESET	0x4008	/* Reset the thing */
#define DRV_INFO	0x4009	/* Some APC info */

struct apc_cmdtab_t {
	int		info_type;	/* the INFO_ index */
	int		info_len;	/* length of INFO data if writable */
	unsigned int	info_flags;	/* INFO flag values - NB Flag enum/rw set by cap check */
	unsigned int	driver_flags; 	/* driver specific flags */
	char *          name;		/* name - mostly derived from netvars data */
	char *          desc;		/* description - mostly derived from netvars data */
	char		cmd;		/* command character */
} apc_cmdtab[] = {
	/* InfoType   Len  InfoFlags    DriverFlags             Name  Desc      CmdChar */
	{INFO_MODEL,	0, 0,   	0,			NULL, NULL,	0x01},
	{INFO_SERIAL,	0, 0,   	0,			NULL, NULL,	'n'},
	{INFO_UTILITY,	0, 0,		APC_POLL|APC_F_VOLT,	NULL, NULL,	'L'},
	{INFO_BATTPCT,	0, 0,		APC_POLL|APC_F_PERCENT,	NULL, NULL,	'f'},
	{INFO_STATUS,	0, 0,		APC_POLL|APC_F_ST,	NULL, NULL,	'Q'},
	{INFO_UPSTEMP,	0, 0,		APC_POLL|APC_F_CELCIUS,	NULL, NULL,	'C'},
	{INFO_ACFREQ,	0, 0,		APC_POLL|APC_F_DEC,	NULL, NULL,	'F'},
	{INFO_LOADPCT,	0, 0,		APC_POLL|APC_F_PERCENT,	NULL, NULL,	'P'},
	{INFO_LOWXFER,	0, 0,		APC_F_VOLT,		NULL, NULL,	'l'},
	{INFO_HIGHXFER,	0, 0,		APC_F_VOLT,		NULL, NULL,	'u'},
	{INFO_AMBHUMID,	0, 0,		APC_POLL|APC_F_PERCENT,	NULL, NULL,	'h'},
	{INFO_AMBTEMP,	0, 0,		APC_POLL|APC_F_CELCIUS,	NULL, NULL,	't'},
	{INFO_CONTACTS,	0, 0,		APC_POLL|APC_F_HEX,	NULL, NULL,	'i'},
	{INFO_UPSIDENT,	8, FLAG_RW | FLAG_STRING,
					0,			NULL, NULL,	'c'},
	{INFO_WAKEDELAY,0, 0,		APC_F_SECONDS,		NULL, NULL,	'r'},
	{INFO_LINESENS,	0, 0,		0,			NULL, NULL,	's'},
	{INFO_WAKETHRSH,0, 0,		APC_F_PERCENT,		NULL, NULL,	'e'},
	{INFO_REQVOLT,	0, 0,		APC_F_VOLT,		NULL, NULL,	'o'},
	{INFO_LOBATTIME,0, 0,		APC_F_MINUTES,		NULL, NULL,	'q'},
	{INFO_PDNGRACE,	0, 0,		APC_F_SECONDS,		NULL, NULL,	'p'},
	{INFO_ALRMDELAY,0, 0,		0,			NULL, NULL,	'k'},
	{INFO_SLFTSTINT,0, 0,		APC_F_HOURS,		NULL, NULL,	'E'},
	{INFO_FIRMREV,  0, 0,		0,			NULL, NULL,	'b'},
	{INFO_REG1,	0, 0,		APC_POLL|APC_F_HEX,	NULL, NULL,	'~'},
	{INFO_REG2,	0, 0,		APC_POLL|APC_F_HEX,	NULL, NULL,	0x27},
	{INFO_REG3,	0, 0,		APC_POLL|APC_F_HEX,	NULL, NULL,	'8'},
	{INFO_LINEQUAL,	0, 0,		APC_POLL|APC_F_HEX,	NULL, NULL,	'9'},
	{INFO_BATTPACKS,0, 0,		APC_F_DEC,		NULL, NULL,	'>'},
	{INFO_BADPACKS,	0, 0,		APC_F_DEC,		NULL, NULL,	'<'},
	{INFO_BATTVOLT,	0, 0,		APC_POLL|APC_F_VOLT,	NULL, NULL,	'B'},
	{INFO_XFERWHY,	0, 0,		APC_POLL,		NULL, NULL,	'G'},
	{INFO_MAXUTIL,	0, 0,		APC_POLL|APC_F_VOLT,	NULL, NULL,	'M'},
	{INFO_MINUTIL,	0, 0,		APC_POLL|APC_F_VOLT,	NULL, NULL,	'N'},
	{INFO_OUTVOLT,	0, 0,		APC_POLL|APC_F_VOLT,	NULL, NULL,	'O'},
	{INFO_SLFTSTRES,0, 0,		APC_POLL,     		NULL, NULL,	'X'},
	{INFO_RUNTIME,	0, 0,		APC_POLL|APC_F_MINUTES,	NULL, NULL,	'j'},
	{INFO_MFRDATE,	0, 0,		0,			NULL, NULL,	'm'},
	{INFO_TEMPMAX,	0, 0,		APC_F_CELCIUS,		NULL, NULL,	'['},
	{INFO_TEMPMIN,	0, 0,		APC_F_CELCIUS,		NULL, NULL,	']'},
	{INFO_HUMDMAX,	0, 0,		APC_F_PERCENT,		NULL, NULL,	'{'},
	{INFO_HUMDMIN,	0, 0,		APC_F_PERCENT,		NULL, NULL,	'}'},
	{INFO_FIRMREV1,	0, 0,		0,			NULL, NULL,	'V'},
	{INFO_FIRMREV2,	0, 0,		0,			NULL, NULL,	'v'},
	{INFO_NOMBATVLT,0, 0,		0,			NULL, NULL,	'g'},
	{INFO_BATTDATE,	8, FLAG_RW | FLAG_STRING
			,		0,			NULL, NULL,	'x'},
	{INFO_COPYRIGHT,0, 0,		0,			NULL, NULL,	'y'},
	{INFO_DIPSWCH,	0, 0,		APC_F_HEX,		NULL, NULL,	'7'},
	{INFO_OUTVLTSEL,0, 0,		APC_F_VOLT,		NULL, NULL,	0x15},
	{INFO_CURRENT,	0, 0,		APC_POLL|APC_F_AMP,	NULL, NULL,	'/'},
	{INFO_LOADPWR,	0, 0,		APC_POLL|APC_F_PERCENT,	NULL, NULL,	0x5C},
	{INFO_LANGUAGE,	0, 0,		0,			NULL, NULL,	0x0C},
	{INFO_ALRMENA,	0, 0,		APC_F_HEX,		NULL, NULL,	'I'},
	{INFO_ALRMSTAT,	0, 0,		0,			NULL, NULL,	'J'},
	{INFO_AMBHUMID2,0, 0,		APC_POLL|APC_F_PERCENT,	NULL, NULL,	'H'},
	{INFO_AMBTEMP2,	0, 0,		APC_POLL|APC_F_CELCIUS,	NULL, NULL,	'T'},

	/* Commands - in same array for neatness :-) */
	{CMD_OFF,	0, 0,		APC_CMD|APC_NASTY|APC_REPEAT,
	 							NULL, NULL,	'Z'},
	{CMD_ON,	0, 0,		APC_CMD|APC_REPEAT,    	NULL, NULL,	0x0E},
	{CMD_BTEST0,	0, 0,		APC_CMD,		NULL, NULL,	'W'},
	{CMD_BTEST1,	0, 0,		APC_CMD,		NULL, NULL,	'W'},
	{CMD_CAL0,	0, 0,		APC_CMD,		NULL, NULL,	'D'},
	{CMD_CAL1,	0, 0,		APC_CMD,		NULL, NULL,	'D'},
	{CMD_FPTEST,	0, 0,		APC_CMD,		NULL, NULL,	'A'},
	{CMD_DUMB,	0, 0,		APC_CMD|APC_NASTY,	NULL, NULL,	'R'},
	{CMD_SIMPWF,	0, 0,		APC_CMD,		NULL, NULL,	'U'},
	{CMD_SOFTDOWN,	0, 0,		APC_CMD|APC_NASTY,	NULL, NULL,	'S'},
	{CMD_SHUTDOWN,	0, 0,		APC_CMD|APC_NASTY|APC_REPEAT,
	 							NULL, NULL,	'K'},
	{CMD_BYPASS,	0, 0,		APC_CMD,		NULL, NULL,	'^'},

	/* Driver specific stuff - ie query functions etc */
	{DRV_CMDSET,	0, 0,		APC_IGNORE,	"#CMDSET",
							"Command query",	'a'},
	{DRV_CAPABILITY,0, 0,		APC_IGNORE,	"#CAPAB",
							"Capabilities query",	26},
	{DRV_NEXT,	0, 0,		APC_IGNORE,	"#NEXT",
							"Next value",		'-'},
	{DRV_SMART,	0, 0,		APC_IGNORE,	"#SMART",
							"Enter Smart mode",	'Y'},
	{DRV_ABORT,	0, 0,		APC_IGNORE,	"#ABORT",
							"Abort",		0x7F},
	{DRV_SHUTDN,	0, 0,		APC_IGNORE,	"#SHUTDN",
							"Shutdown",		'@'},
	{DRV_SEP,	0, 0,		APC_IGNORE,	"#SEP",
							"Data separator",	'.'},
	{DRV_RESET,	0, 0,		APC_IGNORE,	"#RESET",
							"Reset to defaults",	'z'},
	{DRV_INFO,	0, 0,		APC_IGNORE,	"#INFO",
							"Some APC system info",	')'},

	{0,		0, 0,		0,			NULL, NULL,	0},
};


/*
 * Local variables:
 *  c-indent-level: 8
 *  c-basic-offset: 8
 * End:
 */
