/* upscommon.h - prototypes for upscommon.c

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

/* called by alarm signal when the port open fails */
void openfail(int sig);

/* lock the serial port using flock or uu_lock */
void lockport (int upsfd, char *port);

/* try to open the port at a given speed */
void open_serial(char *port, speed_t speed);

/* put a notice in the syslog */
void notice (char *msg);

/* put a fatal in the syslog and quit */
void fatal (char *msg);

/* function for erasing "timeout"-conditions */
void nolongertimeout(void);

/* alarm signal handler for when serial reads time out */
void timeout(int sig);

/* receive up to buflen bytes from the ups into buf until endchar is read */
/* any characters received that match members of ignchars are discarded */
int upsrecv (char *buf, int buflen, char endchar, char *ignchars);

/* send a byte to the ups */
int upssendchar (char data);

/* install the data that the ups returns for 'reqchar' in the info
   array position that has type infotype - endchar/ignchars pass to upsrecv */
void installinfo (int infotype, char reqchar, char endchar, char *ignchars);

/* store data into the array */
void setinfo (int infotype, char *data);

/* set the flags on an existing member of the array */
void setflag (int infotype, int newflags);

/* return the data in the info array with type infotype */
char *getdata (int infotype);

/* write data to state file - effectively a no-op for shared memory mode */
void writeinfo (itype *iwrite);

/* install SIGHUP and atexit handlers for clean exits */
void addcleanup (void);

/* create info array of size numinfo from shared memory or normal */
/* shmok == 1 to allow shared memory, 0 to deny */
itype *create_info (int numinfo, int shmok);

/* create SysV IPC message queue if possible */
void createmsgq(void);

/* get a message from the queue and parse it - returns 1 if successful */
int getupsmsg(int wait);

/* place a message into the queue */
void sendupsmsg (msgtype *buf);

/* lightweight way to send just an OK/ERR response to a command */
void msgreply (int reptype);

/* add another type to the info array */
void addinfo (int type, char *value, int flags, int auxdata);

/* add a new ENUM info entry and do other related housekeeping */
void addenum (int basetype, char *value);

/* structure for funcs that get called by msg parse routine */
struct ups_handler
{
	void	(*setvar)(int, int, char *);
	void	(*instcmd)(int, int, char *);
};

extern struct ups_handler upsh;
