/* upsimage - cgi program to create graphical ups information reports

   Copyright (C) 1998  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

#include "common.h"
#include "upsfetch.h"
#include "config.h"
#include "cgilib.h"
#include "proto.h"

#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfontl.h>
#endif
#ifdef HAVE_GD_H
#include <gd.h>
#include <gdfontl.h>
#endif

	char	monhost[128];
	char	cmd[16];

void parsearg(char *var, char *value) 
{
	if (!strcmp(var, "host"))
		strncpy (monhost, value, sizeof(monhost));

	if (!strcmp(var, "display"))
		strncpy (cmd, value, sizeof(cmd));
}

/* write the HTML header then have gd dump the image */
void drawimage (gdImagePtr im)
{
	printf ("Pragma: no-cache\n");

	printf ("Content-type: image/png\n\n");
	gdImagePng (im, stdout);
	gdImageDestroy (im);
}

void drawbattcap(char *battcaps) 
{
	gdImagePtr	im;
	int		green, black, white, grey, darkgrey;
	char		batttxt[16];
	int		battpos;
	double		battcap;

	battcap = strtod(battcaps, NULL);

	im = gdImageCreate (130, 350);		/* X=130, Y=350 */

	black = gdImageColorAllocate (im, 0, 0, 0);
	green = gdImageColorAllocate (im, 0, 255, 0);
	white = gdImageColorAllocate (im, 255, 255, 255);
	grey = gdImageColorAllocate (im, 200, 200, 200);
	darkgrey = gdImageColorAllocate (im, 50, 50, 50);

	gdImageColorTransparent (im, grey);

	gdImageFilledRectangle (im, 0, 0, 130, 350, grey);

	gdImageString (im, gdFontLarge, 0, 0, "100", black);
	gdImageString (im, gdFontLarge, 0, 55, "80", black);
	gdImageString (im, gdFontLarge, 0, 115, "60", black);
	gdImageString (im, gdFontLarge, 0, 175, "40", black);
	gdImageString (im, gdFontLarge, 0, 235, "20", black);
	gdImageString (im, gdFontLarge, 0, 295, "0", black);

	gdImageFilledRectangle (im, 30, 0, 130, 300, green);

	gdImageLine (im, 30, 60, 130, 60, darkgrey);
	gdImageLine (im, 30, 120, 130, 120, darkgrey);
	gdImageLine (im, 30, 180, 130, 180, darkgrey);
	gdImageLine (im, 30, 240, 130, 240, darkgrey);
	gdImageLine (im, 30, 300, 130, 300, darkgrey);

	battpos = (300 - (battcap * 3));
	gdImageFilledRectangle (im, 55, battpos, 105, 300, black);

	snprintf (batttxt, sizeof (batttxt), "%.1f %%", battcap);
	gdImageString (im, gdFontLarge, 55, 320, batttxt, black);

	drawimage(im);
}

void noimage (void)
{
	gdImagePtr	im;
	int		black, grey;

	im = gdImageCreate (130, 350);
	grey = gdImageColorAllocate (im, 200, 200, 200);
	black = gdImageColorAllocate (im, 0, 0, 0);

	gdImageColorTransparent (im, grey);

	gdImageFilledRectangle (im, 0, 0, 130, 300, grey);

	gdImageString (im, gdFontLarge, 0, 0, "Not available", black);

	drawimage(im);
}

void drawupsload(char *upsloads) 
{
	gdImagePtr	im;
	int		green, black, white, grey, darkgrey, red;
	char		loadtxt[16];
	int		loadpos;
	double		upsload;

	upsload = strtod(upsloads, NULL);

	im = gdImageCreate (130, 350);

	black = gdImageColorAllocate (im, 0, 0, 0);
	green = gdImageColorAllocate (im, 0, 255, 0);
	white = gdImageColorAllocate (im, 255, 255, 255);
	grey = gdImageColorAllocate (im, 200, 200, 200);
	darkgrey = gdImageColorAllocate (im, 50, 50, 50);
	red = gdImageColorAllocate (im, 255, 0, 0);

	gdImageColorTransparent (im, grey);

	gdImageFilledRectangle (im, 0, 0, 130, 350, grey);

	gdImageString (im, gdFontLarge, 0, 0, "125", black);
	gdImageString (im, gdFontLarge, 0, 55, "100", black);
	gdImageString (im, gdFontLarge, 0, 115, "75", black);
	gdImageString (im, gdFontLarge, 0, 175, "50", black);
	gdImageString (im, gdFontLarge, 0, 235, "25", black);
	gdImageString (im, gdFontLarge, 0, 295, "0", black);

	gdImageFilledRectangle (im, 30, 0, 130, 60, red);
	gdImageFilledRectangle (im, 30, 60, 130, 300, green); 

	gdImageLine (im, 30,  60, 130,  60, darkgrey);
	gdImageLine (im, 30, 120, 130, 120, darkgrey);
	gdImageLine (im, 30, 180, 130, 180, darkgrey);
	gdImageLine (im, 30, 240, 130, 240, darkgrey);
	gdImageLine (im, 30, 300, 130, 300, darkgrey);

	loadpos = (300 - ((upsload / 125) * 300));
	gdImageFilledRectangle (im, 55, loadpos, 105, 300, black);

	snprintf (loadtxt, sizeof(loadtxt), "%.1f %%", upsload);
	gdImageString (im, gdFontLarge, 55, 320, loadtxt, black);

	drawimage(im);
}

void drawutility (char *utilitys, int ht, int lt) 
{
	gdImagePtr	im;
	int		green, black, white, grey, darkgrey, red;
	char		utiltxt[16], tempnum[16];
	int		utilpos, utilmin, utilmax;
	double		utility;

	utility = strtod(utilitys, NULL);

	/* default values for USA and similar environments */
	utilmin = 90;
	utilmax = 140;

	/* this is just a hack right at the moment.  at some future point
	   expect to see a proper deciphering of the UPS type to determine
	   what voltages are appropriate. */

	if (utility >= 190) {	/* must be running on a European UPS */
		utilmin = 200;
		utilmax = 250; 
	}

	/* prevent "all red" backgrounds when transfer points are missing */
	if ((lt == 0) || (ht == 0)) {
		lt = utilmin;
		ht = utilmax;
	}

	im = gdImageCreate (130, 350);

	black = gdImageColorAllocate (im, 0, 0, 0);
	green = gdImageColorAllocate (im, 0, 255, 0);
	white = gdImageColorAllocate (im, 255, 255, 255);
	grey = gdImageColorAllocate (im, 200, 200, 200);
	darkgrey = gdImageColorAllocate (im, 50, 50, 50);
	red = gdImageColorAllocate (im, 255, 0, 0);

	gdImageColorTransparent (im, grey);

	gdImageFilledRectangle (im, 0, 0, 130, 350, grey);

	/* this seemingly inefficient method is used to support
	   a whole range of voltages as the user base expands... */

	snprintf (tempnum, sizeof(tempnum), "%i", utilmax);
	gdImageString (im, gdFontLarge, 0, 0, tempnum, black);

	snprintf (tempnum, sizeof(tempnum), "%i", utilmax - 10);
	gdImageString (im, gdFontLarge, 0, 55, tempnum, black);

	snprintf (tempnum, sizeof(tempnum), "%i", utilmax - 20);
	gdImageString (im, gdFontLarge, 0, 115, tempnum, black);

	snprintf (tempnum, sizeof(tempnum), "%i", utilmax - 30);
	gdImageString (im, gdFontLarge, 0, 175, tempnum, black);

	snprintf (tempnum, sizeof(tempnum), "%i", utilmax - 40);
	gdImageString (im, gdFontLarge, 0, 235, tempnum, black);

	snprintf (tempnum, sizeof(tempnum), "%i", utilmax - 50);
	gdImageString (im, gdFontLarge, 0, 295, tempnum, black);

	gdImageFilledRectangle (im, 30,   0, 130, 300, green);

	/* red from the top to the hightransfer */
	utilpos = (300 - (((ht - utilmin) / 50.0) * 300));

	/* avoid leaving a 1 pixel high line when ht == utilmin */
	if (utilpos)
		gdImageFilledRectangle (im, 30,   0, 130, utilpos, red);

	/* red from the lowtransfer to the bottom */
	utilpos = (300 - (((lt - utilmin) / 50.0) * 300));
	gdImageFilledRectangle (im, 30, utilpos, 130, 300, red);

	/* these are the lines for every 10V of the graph */
	gdImageLine (im, 30,  60, 130,  60, darkgrey);
	gdImageLine (im, 30, 120, 130, 120, darkgrey);
	gdImageLine (im, 30, 180, 130, 180, darkgrey);
	gdImageLine (im, 30, 240, 130, 240, darkgrey);
	gdImageLine (im, 30, 300, 130, 300, darkgrey);

	/* draw a black rectangle from the bottom to the voltage level */
	utilpos = (300 - (((utility - utilmin) / 50.0) * 300));
	gdImageFilledRectangle (im, 55, utilpos, 105, 300, black);

	snprintf (utiltxt, sizeof(utiltxt), "%.1f VAC", utility);
	gdImageString (im, gdFontLarge, 55, 320, utiltxt, black); 

	drawimage(im);
}

int main (int argc, char **argv)
{
	char	loadpct[64], battpct[64], utility[64], highxfer[64], 
		lowxfer[64];

	extractcgiargs();

	if (!checkhost(monhost, NULL)) {
		noimage();		/* access denied */
		exit (1);
	}

	if (!strcmp(cmd, "loadpct")) {
		if (getupsvar (monhost, "loadpct", loadpct, sizeof(loadpct)) < 0) {
			noimage();
			exit (1);
		} 
		else {
			drawupsload (loadpct);
			return (0);
		}
	}

	if (!strcmp(cmd, "battpct")) {
		if (getupsvar (monhost, "battpct", battpct, sizeof(battpct)) < 0) {
			noimage();
			exit (1);
		}
		else {
			drawbattcap (battpct);
			return (0);
		}
	}

	if (!strcmp(cmd, "utility")) {
		if (getupsvar (monhost, "utility", utility, sizeof(utility)) < 0) {
			noimage ();
			exit (1);
		}
		else {
			getupsvar (monhost, "highxfer", highxfer, sizeof(highxfer));
			getupsvar (monhost, "lowxfer", lowxfer, sizeof(lowxfer));
			drawutility (utility, atoi(highxfer), atoi(lowxfer));
			return (0);
		}
	}

	printf ("Content-type: text/plain\n\n");
	printf ("Invalid request!\n");

	return (0);
}
