/* cgilib - common routines for CGI programs

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "common.h"
#include "cgilib.h"
#include "config.h"
#include "proto.h"

void extractcgiargs()
{
	char	*query, *ptr, *eq, *varname, *value, *amp;

	query = getenv ("QUERY_STRING");
	if (query == NULL)
		return;		/* not run as a cgi script! */
	if (strlen(query) == 0)
		return;		/* no query string to parse! */

	/* varname=value&varname=value&varname=value ... */

	ptr = query;

	while (ptr) {
		varname = ptr;
		eq = strchr (varname, '=');
		if (!eq) {
			ptr = strchr (varname, '&');
			if (ptr)
				*ptr++ = '\0';

			parsearg (varname, "");
			continue;
		}
		
		*eq = '\0';
		value = eq + 1;
		amp = strchr (value, '&');
		if (amp) {
			ptr = amp + 1;
			*amp = '\0';
		}
		else
			ptr = NULL;
	
		parsearg (varname, value);
	}

	return;
}

char *unescape (char *buf)
{
	int	i, buflen;
	char	ch, ch2, ch3, *newbuf, hex[8];

	buflen = strlen(buf) + 1;
	newbuf = malloc (buflen);
	*newbuf = '\0';

	for (i = 0; i < strlen(buf); i++) {
		ch = buf[i];
		fflush (stdout);

		if (buf[i] == '+')
			ch = ' ';

		if (buf[i] == '%') {
                        ch2 = buf[i+1];
                        ch3 = buf[i+2];
			i += 2;
                        snprintf (hex, sizeof(hex), "%c%c", ch2, ch3);
                        ch = strtol (hex, NULL, 16);

			if ((ch == 10) || (ch == 13))
				ch = ' ';
                }

		snprintf (&newbuf[strlen(newbuf)], buflen - strlen(newbuf),
		          "%c", ch);
	}

	return (newbuf);
}

void extractpostargs()
{
	char	buf[SMALLBUF], *ptr, *cleanval;
	int	ch;

	ch = fgetc(stdin);
	buf[0] = '\0';

	while (ch != EOF) {
		if (ch == '&') {
			ptr = strchr (buf, '=');
			if (!ptr)
				parsearg (buf, "");
			else {
				*ptr++ = '\0';
				cleanval = unescape (ptr);
				parsearg (buf, cleanval);
				free (cleanval);
			}
			buf[0] = '\0';
		}
		else
			snprintf (&buf[strlen(buf)], sizeof(buf) - strlen(buf), 
			          "%c", ch);

		ch = fgetc(stdin);
	}

	if (strlen(buf) != 0) {
		ptr = strchr (buf, '=');
		if (!ptr)
			parsearg (buf, "");
		else {
			*ptr++ = '\0';
			cleanval = unescape (ptr);
			parsearg (buf, cleanval);
			free (cleanval);
		}
	}

}

int checkhost(char *check, char **desc)
{
	FILE	*hostlist;
	char	fn[SMALLBUF], buf[SMALLBUF], addr[SMALLBUF], *rest, *ptr;
	int	ofs;

	if (!check)
		return 0;		/* deny null hostnames */

	snprintf(fn, sizeof(fn), "%s/hosts.conf", CONFPATH);
	hostlist = fopen(fn, "r");

	if (hostlist == NULL)
		return 1;		/* default to allow */

	while (fgets (buf, sizeof(buf), hostlist)) 
		if (strncmp("MONITOR", buf, 7) == 0) {
			sscanf (buf, "%*s %s %n", addr, &ofs);
			rest = buf + ofs + 1;
			ptr = strchr (rest, '"');
			if (ptr)
				*ptr  = '\0';

			if (!strcmp (addr, check)) {
				fclose (hostlist);
				if (desc != NULL)
					*desc = strdup(rest);

				return 1;	/* allowed */
			}
		}

	fclose (hostlist);
	return 0;		/* denied */
}	
