/* acconfig.h - template for autoheader for config.h.in */

/* path where things get installed by default */
#define BASEPATH "/usr/local/ups"

/* path where configuration files get installed by default */
#define CONFPATH "/usr/local/ups/etc"

/* state files created by the model-specific programs go here */
#define STATEPATH "/var/state/ups"

/* default path for CGI programs */
#define CGIPATH "/usr/local/ups/cgi-bin"

/* default path for model-specific drivers */
#define MODELPATH "/usr/local/ups/bin"

/* port number used for network communications */
#define UDPPORT 3305

/* the UID/GID values may need to be changed for other systems */

/* user to run as instead of root - typically "nobody" */
#define RUN_AS_USER "nobody"

/* groupid to run as instead of root - typically "nogroup" */
#define RUN_AS_GROUP "nogroup"

/* logging facility for syslog */
#define LOG_FACILITY LOG_DAEMON

/* define this to use C instead of F for temperature readings */
#undef USE_CELSIUS

/* define this if you have uu_lock for handling serial ports ala FreeBSD */
#undef HAVE_UU_LOCK

/* longlong */
#undef HAVE_LONGLONG

/* longdouble */
#undef HAVE_LONGDOUBLE

/* define this if some serial bits are in modem.h ala HPUX 10.x */
#undef HAVE_SYS_MODEM_H

/* define this if you have stdarg.h */
#undef HAVE_STDARG_H

/* define this if you have varargs.h */
#undef HAVE_VARARGS_H

/* define this if you have the snprintf function */
#undef HAVE_SNPRINTF

/* define this if you have the vsnprintf function */
#undef HAVE_VSNPRINTF

/* define this if you have the fcvt function */
#undef HAVE_FCVT

/* define this if you have the fcvtl function */
#undef HAVE_FCVTL

/* define this if you have the setenv function */
#undef HAVE_SETENV

/* Define if you need to include the <getopt.h> header file for getopt externs */
#undef NEED_GETOPT_H

/* Define if you need to declare getopt externs explcitly */
#undef NEED_GETOPT_DECLS
