/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.servlets.ManagerServlet;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;

public final class HTMLManagerServlet
extends ManagerServlet {
    private static final String HTML_HEADER_SECTION = "<html>\n<head>\n<style>\n  table { width: 100%; }\n  td.page-title {\n    text-align: center;\n    vertical-align: top;\n    font-family:verdana,sans-serif;\n    font-weight: bold;\n    background: white;\n    color: black;\n  }\n  td.title {\n    text-align: left;\n    vertical-align: top;\n    font-family:verdana,sans-serif;\n    font-style:italic;\n    font-weight: bold;\n    background: #D2A41C;\n  }\n  td.header-left {\n    text-align: left;\n    vertical-align: top;\n    font-family:verdana,sans-serif;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  td.header-center {\n    text-align: center;\n    vertical-align: top;\n    font-family:verdana,sans-serif;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  td.row-left {\n    text-align: left;\n    vertical-align: middle;\n    font-family:verdana,sans-serif;\n    color: black;\n    background: white;\n  }\n  td.row-center {\n    text-align: center;\n    vertical-align: middle;\n    font-family:verdana,sans-serif;\n    color: black;\n    background: white;\n  }\n  td.row-right {\n    text-align: right;\n    vertical-align: middle;\n    font-family:verdana,sans-serif;\n    color: black;\n    background: white;\n  }\n</style>\n";
    private static final String BODY_HEADER_SECTION = "<title>{0}</title>\n</head>\n\n<body bgcolor=\"#FFFFFF\">\n\n<table cellspacing=\"4\" width=\"100%\" border=\"0\">\n <tr>\n  <td colspan=\"2\">\n   <a href=\"http://jakarta.apache.org/\">\n    <img border=\"0\" alt=\"The Jakarta Project\" align=\"left\"\n         src=\"{0}/images/jakarta-logo.gif\">\n   </a>\n   <a href=\"http://jakarta.apache.org/tomcat/\">\n    <img border=\"0\" alt=\"The Tomcat Servlet/JSP Container\"\n         align=\"right\" src=\"{0}/images/tomcat.gif\">\n   </a>\n  </td>\n </tr>\n</table>\n<hr size=\"1\" noshade=\"noshade\">\n<table cellspacing=\"4\" width=\"100%\" border=\"0\">\n <tr>\n  <td class=\"page-title\" bordercolor=\"#000000\" align=\"left\" nowrap>\n   <font size=\"+2\">{1}</font>\n  </td>\n </tr>\n</table>\n<br>\n\n";
    private static final String MESSAGE_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n <tr>\n  <td class=\"row-left\" width=\"10%\"><small><b>{0}</b></small>&nbsp;</td>\n  <td class=\"row-left\"><pre>{1}</pre></td>\n </tr>\n</table>\n<br>\n\n";
    private static final String MANAGER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"3\" class=\"title\">{0}</td>\n</tr>\n <tr>\n  <td class=\"row-left\"><a href=\"{1}\">{2}</a></td>\n  <td class=\"row-center\"><a href=\"{3}\">{4}</a></td>\n  <td class=\"row-right\"><a href=\"{5}\">{6}</a></td>\n </tr>\n</table>\n<br>\n\n";
    private static final String APPS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"5\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-left\"><small>{1}</small></td>\n <td class=\"header-left\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n</tr>\n";
    private static final String APPS_ROW_DETAILS_SECTION = "<tr>\n <td class=\"row-left\"><small><a href=\"{0}\">{0}</a></small></td>\n <td class=\"row-left\"><small>{1}</small></td>\n <td class=\"row-center\"><small>{2}</small></td>\n <td class=\"row-center\"><small><a href=\"{3}\">{4}</a></small></td>\n";
    private static final String MANAGER_APP_ROW_BUTTON_SECTION = " <td class=\"row-left\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;{7}&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String STARTED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;<a href=\"{2}\">{3}</a>&nbsp;\n  &nbsp;<a href=\"{4}\">{5}</a>&nbsp;\n  &nbsp;<a href=\"{6}\">{7}</a>&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String STOPPED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\">\n  <small>\n  &nbsp;<a href=\"{0}\">{1}</a>&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;<a href=\"{6}\">{7}</a>&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String INSTALL_SECTION = "</table>\n<br>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"get\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"installPath\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{4}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"installConfig\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{5}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"installWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{6}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n";
    private static final String UPLOAD_SECTION = "<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{0}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form action=\"{1}\" method=\"post\" enctype=\"multipart/form-data\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{2}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"file\" name=\"installWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{3}\">\n </td>\n</tr>\n</table>\n</form>\n</table>\n<br>\n\n";
    private static final String SERVER_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n <td class=\"header-center\"><small>{6}</small></td>\n</tr>\n";
    private static final String SERVER_ROW_SECTION = "<tr>\n <td class=\"row-center\"><small>{0}</small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n <td class=\"row-center\"><small>{2}</small></td>\n <td class=\"row-center\"><small>{3}</small></td>\n <td class=\"row-center\"><small>{4}</small></td>\n <td class=\"row-center\"><small>{5}</small></td>\n</tr>\n</table>\n<br>\n\n";
    private static final String HTML_TAIL_SECTION = "<hr size=\"1\" noshade=\"noshade\">\n<center><font size=\"-1\" color=\"#525D76\">\n <em>Copyright &copy; 1999-2002, Apache Software Foundation</em></font></center>\n\n</body>\n</html>";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        String path = request.getParameter("path");
        String installPath = request.getParameter("installPath");
        String installConfig = request.getParameter("installConfig");
        String installWar = request.getParameter("installWar");
        Locale locale = Locale.getDefault();
        String charset = this.context.getCharsetMapper().getCharset(locale);
        response.setLocale(locale);
        response.setContentType("text/html; charset=" + charset);
        String message = "";
        if (command != null && !command.equals("/")) {
            if (command.equals("/install")) {
                message = this.install(installConfig, installPath, installWar);
            } else if (!command.equals("/list")) {
                message = command.equals("/reload") ? this.reload(path) : (command.equals("/remove") ? this.remove(path) : (command.equals("/sessions") ? this.sessions(path) : (command.equals("/start") ? this.start(path) : (command.equals("/stop") ? this.stop(path) : sm.getString("managerServlet.unknownCommand", (Object)command)))));
            }
        }
        this.list(request, response, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String war;
        String message;
        block23: {
            FileItem warUpload;
            block21: {
                String command = request.getPathInfo();
                if (command == null || !command.equals("/upload")) {
                    this.doGet(request, response);
                    return;
                }
                Locale locale = Locale.getDefault();
                String charset = this.context.getCharsetMapper().getCharset(locale);
                response.setLocale(locale);
                response.setContentType("text/html; charset=" + charset);
                message = "";
                DiskFileUpload upload = new DiskFileUpload();
                File tempdir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
                upload.setSizeMax(-1L);
                upload.setRepositoryPath(tempdir.getCanonicalPath());
                war = null;
                warUpload = null;
                try {
                    try {
                        List items = upload.parseRequest(request);
                        Iterator iter = items.iterator();
                        while (iter.hasNext()) {
                            FileItem item = (FileItem)iter.next();
                            if (item.isFormField()) continue;
                            if (item.getFieldName().equals("installWar") && warUpload == null) {
                                warUpload = item;
                                continue;
                            }
                            item.delete();
                        }
                        if (warUpload == null) {
                            message = sm.getString("htmlManagerServlet.installUploadNoFile");
                        } else {
                            war = warUpload.getName();
                            if (!war.toLowerCase().endsWith(".war")) {
                                message = sm.getString("htmlManagerServlet.installUploadNotWar", (Object)war);
                            } else {
                                File file;
                                if (war.lastIndexOf(92) >= 0) {
                                    war = war.substring(war.lastIndexOf(92) + 1);
                                }
                                if (war.lastIndexOf(47) >= 0) {
                                    war = war.substring(war.lastIndexOf(47) + 1);
                                }
                                String appBase = null;
                                File appBaseDir = null;
                                appBase = ((Host)this.context.getParent()).getAppBase();
                                appBaseDir = new File(appBase);
                                if (!appBaseDir.isAbsolute()) {
                                    appBaseDir = new File(System.getProperty("catalina.base"), appBase);
                                }
                                if ((file = new File(appBaseDir, war)).exists()) {
                                    message = sm.getString("htmlManagerServlet.installUploadWarExists", (Object)war);
                                } else {
                                    warUpload.write(file);
                                    try {
                                        URL url = file.toURL();
                                        war = url.toString();
                                        war = "jar:" + war + "!/";
                                    }
                                    catch (MalformedURLException e) {
                                        file.delete();
                                        throw e;
                                    }
                                }
                            }
                        }
                        Object var18_19 = null;
                        if (warUpload == null) break block21;
                    }
                    catch (Exception e) {
                        message = sm.getString("htmlManagerServlet.installUploadFail", (Object)e.getMessage());
                        this.log(message, e);
                        Object var18_20 = null;
                        if (warUpload != null) {
                            warUpload.delete();
                        }
                        warUpload = null;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_21 = null;
                    if (warUpload != null) {
                        warUpload.delete();
                    }
                    warUpload = null;
                    throw throwable;
                }
                warUpload.delete();
            }
            warUpload = null;
        }
        if (message.length() == 0) {
            message = this.install(null, null, war);
        }
        this.list(request, response, message);
    }

    protected String install(String config, String path, String war) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.install(printWriter, config, path, war);
        return stringWriter.toString();
    }

    public void list(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        PrintWriter writer = response.getWriter();
        writer.print(HTML_HEADER_SECTION);
        Object[] args = new Object[]{request.getContextPath(), sm.getString("htmlManagerServlet.title")};
        writer.print(MessageFormat.format(BODY_HEADER_SECTION, args));
        args = new Object[3];
        args[0] = sm.getString("htmlManagerServlet.messageLabel");
        args[1] = message == null || message.length() == 0 ? "OK" : message;
        writer.print(MessageFormat.format(MESSAGE_SECTION, args));
        args = new Object[]{sm.getString("htmlManagerServlet.manager"), response.encodeURL(request.getContextPath() + "/html/list"), sm.getString("htmlManagerServlet.list"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlManagerServlet.helpHtmlManagerFile")), sm.getString("htmlManagerServlet.helpHtmlManager"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlManagerServlet.helpManagerFile")), sm.getString("htmlManagerServlet.helpManager")};
        writer.print(MessageFormat.format(MANAGER_SECTION, args));
        args = new Object[]{sm.getString("htmlManagerServlet.appsTitle"), sm.getString("htmlManagerServlet.appsPath"), sm.getString("htmlManagerServlet.appsName"), sm.getString("htmlManagerServlet.appsAvailable"), sm.getString("htmlManagerServlet.appsSessions"), sm.getString("htmlManagerServlet.appsTasks")};
        writer.print(MessageFormat.format(APPS_HEADER_SECTION, args));
        String[] contextPaths = this.deployer.findDeployedApps();
        TreeMap<String, String> sortedContextPathsMap = new TreeMap<String, String>();
        for (int i = 0; i < contextPaths.length; ++i) {
            String displayPath = contextPaths[i];
            sortedContextPathsMap.put(displayPath, contextPaths[i]);
        }
        String appsStart = sm.getString("htmlManagerServlet.appsStart");
        String appsStop = sm.getString("htmlManagerServlet.appsStop");
        String appsReload = sm.getString("htmlManagerServlet.appsReload");
        String appsRemove = sm.getString("htmlManagerServlet.appsRemove");
        Iterator iterator = sortedContextPathsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String displayPath = (String)entry.getKey();
            String contextPath = (String)entry.getKey();
            Context context = this.deployer.findDeployedApp(contextPath);
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context == null) continue;
            args = new Object[5];
            args[0] = displayPath;
            args[1] = context.getDisplayName();
            if (args[1] == null) {
                args[1] = "&nbsp;";
            }
            args[2] = new Boolean(context.getAvailable());
            args[3] = response.encodeURL(request.getContextPath() + "/html/sessions?path=" + displayPath);
            args[4] = new Integer(context.getManager().findSessions().length);
            writer.print(MessageFormat.format(APPS_ROW_DETAILS_SECTION, args));
            args = new Object[]{response.encodeURL(request.getContextPath() + "/html/start?path=" + displayPath), appsStart, response.encodeURL(request.getContextPath() + "/html/stop?path=" + displayPath), appsStop, response.encodeURL(request.getContextPath() + "/html/reload?path=" + displayPath), appsReload, response.encodeURL(request.getContextPath() + "/html/remove?path=" + displayPath), appsRemove};
            if (context.getPath().equals(this.context.getPath())) {
                writer.print(MessageFormat.format(MANAGER_APP_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (context.getAvailable()) {
                writer.print(MessageFormat.format(STARTED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            writer.print(MessageFormat.format(STOPPED_APPS_ROW_BUTTON_SECTION, args));
        }
        args = new Object[]{sm.getString("htmlManagerServlet.installTitle"), sm.getString("htmlManagerServlet.installServer"), response.encodeURL(request.getContextPath() + "/html/install"), sm.getString("htmlManagerServlet.installPath"), sm.getString("htmlManagerServlet.installConfig"), sm.getString("htmlManagerServlet.installWar"), sm.getString("htmlManagerServlet.installButton")};
        writer.print(MessageFormat.format(INSTALL_SECTION, args));
        args = new Object[]{sm.getString("htmlManagerServlet.installUpload"), response.encodeURL(request.getContextPath() + "/html/upload"), sm.getString("htmlManagerServlet.installUploadFile"), sm.getString("htmlManagerServlet.installButton")};
        writer.print(MessageFormat.format(UPLOAD_SECTION, args));
        args = new Object[]{sm.getString("htmlManagerServlet.serverTitle"), sm.getString("htmlManagerServlet.serverVersion"), sm.getString("htmlManagerServlet.serverJVMVersion"), sm.getString("htmlManagerServlet.serverJVMVendor"), sm.getString("htmlManagerServlet.serverOSName"), sm.getString("htmlManagerServlet.serverOSVersion"), sm.getString("htmlManagerServlet.serverOSArch")};
        writer.print(MessageFormat.format(SERVER_HEADER_SECTION, args));
        args = new Object[]{ServerInfo.getServerInfo(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        writer.print(MessageFormat.format(SERVER_ROW_SECTION, args));
        writer.print(HTML_TAIL_SECTION);
        writer.flush();
        writer.close();
    }

    protected String reload(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.reload(printWriter, path);
        return stringWriter.toString();
    }

    protected String remove(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.remove(printWriter, path);
        return stringWriter.toString();
    }

    public String sessions(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sessions(printWriter, path);
        return stringWriter.toString();
    }

    public String start(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, path);
        return stringWriter.toString();
    }

    protected String stop(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, path);
        return stringWriter.toString();
    }
}

