/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.PoolablePreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements Connection,
KeyedPoolableObjectFactory {
    protected KeyedObjectPool _pstmtPool = null;

    public PoolingConnection(Connection c) {
        super(c);
    }

    public PoolingConnection(Connection c, KeyedObjectPool pool) {
        super(c);
        this._pstmtPool = pool;
    }

    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool oldpool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                oldpool.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLNestedException("Cannot close connection", e);
            }
        }
        this.getInnermostDelegate().close();
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", e);
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", e);
        }
    }

    protected Object createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql), resultSetType, resultSetConcurrency);
    }

    protected Object createKey(String sql) {
        return new PStmtKey(this.normalizeSQL(sql));
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    public Object makeObject(Object obj) throws Exception {
        if (null == obj || !(obj instanceof PStmtKey)) {
            throw new IllegalArgumentException();
        }
        PStmtKey key = (PStmtKey)obj;
        if (null == key._resultSetType && null == key._resultSetConcurrency) {
            return new PoolablePreparedStatement(this.getDelegate().prepareStatement(key._sql), key, this._pstmtPool, this);
        }
        return new PoolablePreparedStatement(this.getDelegate().prepareStatement(key._sql, key._resultSetType, key._resultSetConcurrency), key, this._pstmtPool, this);
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)obj).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)obj).close();
        }
    }

    public boolean validateObject(Object key, Object obj) {
        return true;
    }

    public void activateObject(Object key, Object obj) {
        ((DelegatingPreparedStatement)obj).activate();
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        ((PreparedStatement)obj).clearParameters();
        ((DelegatingPreparedStatement)obj).passivate();
    }

    public String toString() {
        return "PoolingConnection: " + this._pstmtPool.toString();
    }

    class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;

        PStmtKey(String sql) {
            this._sql = sql;
        }

        PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
            this._sql = sql;
            this._resultSetType = new Integer(resultSetType);
            this._resultSetConcurrency = new Integer(resultSetConcurrency);
        }

        public boolean equals(Object that) {
            try {
                PStmtKey key = (PStmtKey)that;
                return (null == this._sql && null == key._sql || this._sql.equals(key._sql)) && (null == this._resultSetType && null == key._resultSetType || this._resultSetType.equals(key._resultSetType)) && (null == this._resultSetConcurrency && null == key._resultSetConcurrency || this._resultSetConcurrency.equals(key._resultSetConcurrency));
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return null == this._sql ? 0 : this._sql.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("PStmtKey: sql=");
            buf.append(this._sql);
            buf.append(", resultSetType=");
            buf.append(this._resultSetType);
            buf.append(", resultSetConcurrency=");
            buf.append(this._resultSetConcurrency);
            return buf.toString();
        }
    }
}

