/*
 * This file is copyrighted material. See the file COPYING for licensing
 * conditions.
 */

/* $Id: leafnode.h,v 1.47 2002/08/14 15:47:46 emma Exp $ */

#ifndef LEAFNODE_H
#define LEAFNODE_H

#include "critmem.h"

/* I wish the world were a happy place */
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

/* limits.h is supposed to contain PATH_MAX, we include sys/param.h too */
#include <limits.h>
#ifndef PATH_MAX
#include <sys/param.h>
#define PATH_MAX MAXPATHLEN
#endif

#define PORTFILENAMECSET "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._-"

#include <sys/types.h>		/* for regex.h */
#include <regex.h>		/* regex_t */
#include <stdio.h>		/* FILE * */
#include <time.h>		/* time_t */
#include <stdarg.h>             /* va_list */

#include "config.h"		/* FreeSGI barfs on #ifdef HAVE_CONFIG_H */

#ifdef HAVE_AP_CONFIG_H
#define AP_CONFIG_H
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#include <sys/errno.h>
#endif
#ifndef HAVE_ERRNO_H
extern int errno;
#endif				/* HAVE_ERRNO_H */

/* from strdup.c */
#ifndef HAVE_STRDUP
char *strdup(const char *);
#endif

/* from snprintf.c */
#ifndef HAVE_SNPRINTF
int snprintf(char *str, size_t n, const char *format, ...);
int vsnprintf(char *str, size_t n, const char *format, va_list ap);
#endif

int xsnprintf(/*@out@*/ char *str, size_t n, const char *format, ...);

/* add LOG_NEWS where it doesn't exist */
#include <syslog.h>
#if !defined( LOG_NEWS )
#define LOG_NEWS LOG_DAEMON
#endif
#if !defined( LOG_CONS )
#define LOG_CONS 0		/* if it isn't supported, make do without */
#endif

#define SECONDS_PER_DAY ( 24L * 60 * 60 )

/* Limit on the number of message bodies marked for download per group. */
#define BODY_DOWNLOAD_LIMIT 2048

/* initialize global variables */
int initvars(char *progname);

/* converts a message-id to a file name, the return value points into
   a static array */
/*@dependent@*/ const char *lookup(const char *msgid);

/*@dependent@*/
char *getaline(FILE * f);	/* reads one line, regardless of length */
/*@dependent@*/
char *mgetaline(FILE * f);      /* dito, with timeout */
/*@dependent@*/
char *tgetaline(FILE * f);	/* read line with timer */

RETSIGTYPE timer(int sig);

/* changes (and optionally creates) directory */
int chdirgroup(const char *group, int creatdir);

/*
 * newsgroup management
 */
struct newsgroup {
    unsigned long first;
    unsigned long last;
    char *name;
    char *desc;
    time_t age;
};

int isinteresting(const char *groupname);
void insertgroup(const char *name, long unsigned first, long unsigned last,
		 time_t date);
void changegroupdesc(const char *groupname, char *description);
void mergegroups(void);
/*@null@*//*@dependent@*/
struct newsgroup *xfindgroup(struct newsgroup *active, const char *name,
	unsigned long size);
/*@null@*//*@dependent@*/
struct newsgroup *findgroup(const char *name);
void readactive(void);
void writeactive(void);
void fakeactive(void);
void freeactive(struct newsgroup *act);

extern size_t activesize;
/*@null@*/ extern struct newsgroup *active;
extern size_t oldactivesize;
/*@null@*/ extern struct newsgroup *oldactive;

/* translation from message-id to article number, used in fetch and expire */

void clearidtree(void);
void insertmsgid( /*@unique@*/ const char *msgid, unsigned long art);
unsigned long findmsgid(const char *msgid);

/* -----------here starts the new stuff-----------------*/

/*
 * a linear list of strings
 */
struct stringlist {
    struct stringlist *next;
    char string[1];
};

void
prependtolist(struct stringlist **list, /*@unique@*/ const char *newentry);

/*@null@*//*@dependent@*/
struct stringlist **lfindinlist(struct stringlist **haystack, char *needle, int len);
	/* find a stringlist element by doing a linear search */
char *findinlist(struct stringlist *haystack, char *needle);
	/* find a string in a stringlist by doing a linear search */
void freelist( /*@only@*/ struct stringlist *list);
	/* free memory occupied by a stringlist */

/*
 * filtering headers for regexp
 */
void readfilter(char *filterfile);
int dofilter(char *h);

/*
 * artutil -- handling article files
 */

/*
 * store articles
 */
void store(const char *filename,
	   FILE * filehandle, const char *newsgroups, const char *msgid);

/*
 * find a certain header in an article and return it
 */
/*@null@*//*@only@*/ char *getheader(const char *filename, const char *header);
/*@null@*//*@only@*/ char *fgetheader(FILE * f, const char *header);

/*
 * xover stuff -- for nntpd.c
 */
struct xoverinfo {
    char *text;
    int exists;
};

/*@null@*/ extern struct xoverinfo *xoverinfo;
extern unsigned long xfirst;
extern unsigned long xlast;

int getxover(void);		/* set xoverinfo, return 0 on error, nonzero else */

/*
 * the strings in config.c
 */
extern const char *spooldir;
extern const char *sysconfdir;
extern const char *version;
extern const char *lockfile;

/*
 * global variables from config file. These are defined in configutil.c
 */
struct expire_entry {
    struct expire_entry *next;
    char *group;
    time_t xtime;
    int days;
};

struct server {
    struct server *next;
    char *name;			/* Servername */
    char *username;
    char *password;
    unsigned int port;
    int descriptions;		/* download descriptions as well */
    int timeout;		/* timeout in seconds before we give up */
    int nopost;			/* if set, do not try to post to this server */
    int updateactive;		/* update the active file of this server */
};

extern int stat_is_evil;	/* use HEAD instead of STAT to figure if a
				   posting is available upstream, workaround for broken NewsCache */
extern time_t expire;		/* articles not touched since this time get deleted */
extern int expiredays;
extern struct expire_entry *expire_base;
			/* expire for certain groups */
extern unsigned long artlimit;		/* max # of articles to read per group in one go */
extern unsigned long initiallimit;
			/* max # of articles to read at first time */
extern long crosspostlimit;
			/* crossposting limit, to reduce spam */
extern int delaybody;		/* delay download of message body */
extern int debugmode;		/* log lots of stuff via syslog */
extern int create_all_links;
			/* store articles even in uninteresting groups */
extern int maxage;		/* max age of articles */
extern long maxlines;		/* max length of articles in lines */
extern long minlines;		/* min length of articles in lines */
extern unsigned long maxbytes;	/* max length of articles in bytes */
extern int timeout_short;	/* don't fetch groups that have been
				   accidentally accessed after that many days */
extern int timeout_long;	/* don't fetch groups that have been accessed
				   that many days */
extern int timeout_active;	/* reread active file after that many days */
extern int timeout_client;	/* activity timeout for clients in seconds */
extern int clamp_maxage;        /* limit maxage to applicable group/global expire? */
extern char *filterfile;	/* filename where filter resides */
extern struct server *servers;	/* list of servers to use */
extern int allowstrangers;	/* if addresses not local to our links
				   are allowed to connect */
extern int allow_8bit_headers;	/* if 8bit junk in headers is allowed */

/*
 * other global variables
 */
#define SIZE_lineout 1024
extern char last_command[SIZE_lineout + 1];
extern char lineout[SIZE_lineout + 1];

/* defined in nntputil.c */
extern
				    /*@relnull@*/
 /*@dependent@*/
FILE *nntpin;
extern
				    /*@relnull@*/
 /*@dependent@*/
FILE *nntpout;

#define SIZE_s (8192)
#define FQDNLEN 255
extern char fqdn[FQDNLEN + 1];	/* my name, and my naming myself */

extern int verbose;		/* verbosity level, for fetch and texpire */
extern int debug;		/* debug level */

/*
 * misc prototypes
 */
int lockfile_exists(unsigned long);
int handover_lock(pid_t);
void putaline(void);
void retry(void);
void readexpire(void);
void free_expire(void);
int readconfig(int logtostderr);
void freeservers(void);
void lowercase(char *string);
int ngmatch(const char *pattern, const char *string);
void overrun(void);
void replaceinlist(struct stringlist **haystack, char *needle, int len);
time_t lookup_expire(char *group);
int lookup_expiredays(char *group);

/* int rename(const char *old, const char *new); */
				/* to avoid barfing of Digital Unix */

/*
 * stuff from nntputil.c
 */
int authenticate(void);		/* authenticate ourselves at a server */
/*@dependent@*//*@null@*/
char *lastreply(void);		/* last line frpm nntpreply */
int nntpreply(void);		/* decode an NNTP reply number */
int nntpconnect(const struct server *upstream);
				/* connect to upstream server */
void nntpdisconnect(void);	/* disconnect from upstream server */

/*@dependent@*/
const char *rfctime(void);	/* An rfc type date */

int safe_mkstemp(char *);	/* permission safe mkstemp wrapper */
/* from syslog.c */
void myopenlog(const char *ident);

/* from mkstemp.c */
#ifndef HAVE_MKSTEMP
int mkstemp(char *);
#endif

/* from getline.c */
#ifndef HAVE_GETLINE
ssize_t getline(char **, size_t *, FILE *);	/* fgets replacement */
#endif

/* from gmtoff.c */
time_t gmtoff(const time_t);

/* from mysetvbuf.c */
int mysetvbuf(FILE *stream, char *buf, int mode, size_t size);

/* from wildmat.c */
int wildmat(const char *, const char *);

/* from mysetvbuf.c */
int mysetvbuf(FILE *stream, char *buf, int mode , size_t size);

/* from getfoldedline.c */
/*@null@*/ /*@only@*/
char *getfoldedline(FILE * f);
/* reads one line, regardless of length, returns malloc()ed string! */

/* from writes.c (ln-2) */
ssize_t writes(int fd, const char *string);

void fixxover(void);

/* from grouplist.c */
/*@null@*/ struct stringlist *get_grouplist(void);

/* checkpeerlocal.c */
int checkpeerlocal(int sock);

/* pcre_extract.c */
int pcre_extract(const char *input, const char *pattern, /*@out@*/ char **output, size_t num);
void pcre_extract_free(char **vec, int count);
size_t xstrlcpy(/*@out@*/ char *dst, const char *src, size_t size);

#define SKIPLWS(p) while (*(p) && isspace((unsigned char) *(p))) { (p)++; }
#endif				/* #ifndef LEAFNODE_H */
