#ifndef BASE_MAIN_H
#define BASE_MAIN_H

#include <kmainwindow.h>
#include <kaction.h>

#include "gsettings.h"
#include "defines.h"


class BaseInterface;

class BaseMainWindow : public KMainWindow, public Factory
{
 Q_OBJECT
 public:
    BaseMainWindow();
	virtual ~BaseMainWindow();

 signals:
    void settingsChanged();

 private slots:
	void toggleMenubar();
    void start();
    void pause();
    void showHighscores();
    void configureSettings();

 protected:
    BaseInterface      *_inter;
    KSettingCollection  _collection;

	bool eventFilter(QObject *, QEvent *);
    bool queryExit();
    void readSettings();
    void buildGUI(QWidget *);

 private:
    KToggleAction *_menu, *_pause;
};

#endif
