#include "main.h"
#include "main.moc"

#include <klocale.h>
#include <kcmdlineargs.h>
#include <kstdaction.h>
#include <kaboutdata.h>
#include <kmenubar.h>
#include <kstdgameaction.h>
#include <kapplication.h>
#include <kcmenumngr.h>

#include "inter.h"
#include "version.h"
#include "piece.h"


BaseMainWindow::BaseMainWindow()
{
    installEventFilter(this);

	// File & Popup
	KStdGameAction::gameNew(this, SLOT(start()), actionCollection());
    _pause = KStdGameAction::pause(this, SLOT(pause()), actionCollection());
    _pause->setEnabled(false);
    KStdGameAction::highscores(this, SLOT(showHighscores()),
                               actionCollection());
	KStdGameAction::quit(qApp, SLOT(quit()), actionCollection());

	// Settings
	_menu = KStdAction::showMenubar(this, SLOT(toggleMenubar()),
                                    actionCollection());
    _collection.plug(_menu, OP_GROUP, "menubar visible", true);
	KStdAction::preferences(this, SLOT(configureSettings()),
                            actionCollection());
}

void BaseMainWindow::buildGUI(QWidget *widget)
{
    createGUI();
	readSettings();
	setCentralWidget(widget);

    QPopupMenu *popup = (QPopupMenu*)factory()->container("popup", this);
    if (popup) KContextMenuManager::insert(this, popup);
}

BaseMainWindow::~BaseMainWindow()
{
    delete _inter;
}

bool BaseMainWindow::eventFilter(QObject *, QEvent *e)
{
    if ( e->type()==QEvent::LayoutHint )
		setFixedSize(minimumSize()); // because QMainWindow and KMainWindow
		                             // do not manage fixed central widget and
		                             // hidden menubar ...
    return false;
}

void BaseMainWindow::readSettings()
{
    _collection.load();
	toggleMenubar();
}

bool BaseMainWindow::queryExit()
{
    _collection.save();
    return true;
}

void BaseMainWindow::toggleMenubar()
{
	if ( _menu->isChecked() ) menuBar()->show();
	else menuBar()->hide();
}

void BaseMainWindow::showHighscores()
{
    if ( !_inter->_isPaused() ) _inter->_pause();
    KExtHighscores::showHighscores(this);
}

void BaseMainWindow::start()
{
    _inter->_start();
}

void BaseMainWindow::pause()
{
    _inter->_pause();
}

void BaseMainWindow::configureSettings()
{
    if ( !_inter->_isPaused() ) _inter->_pause();

    KSettingDialog od(this);

    KSettingWidget *sw = createGameSettings();
    if (sw) {
        connect(sw->settings(), SIGNAL(hasBeenSaved()),
                SIGNAL(settingsChanged()));
        od.append(sw);
    }

    sw = createAppearanceSettings();
    if (sw) {
        connect(sw->settings(), SIGNAL(hasBeenSaved()),
                SIGNAL(settingsChanged()));
        od.append(sw);
    }

    od.append( KExtHighscores::createSettingsWidget(this) );

    sw = createAISettings();
    if (sw) od.append(sw);

    od.exec();
}
