/***************************************************************************
                          kxmleditorcombo.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORCOMBO_H
#define KXMLEDITORCOMBO_H

#include <qwidget.h>
#include <qpixmap.h>
#include <kcombobox.h>

/**Combo box, that display Path for selected item
Based on KonqCombo class from Konqueror
  *@author Lumir Vanek
  */

class KXmlEditorCombo : public KHistoryCombo
{
   Q_OBJECT
public:
	KXmlEditorCombo(QWidget *parent, const char *name);
	~KXmlEditorCombo();
	
	// determines internally if it's temporary or final
  void setPath(const QString& url, const QPixmap&);
	
	void setTemporary(const QString&, const QPixmap&);
  void clearTemporary(bool makeCurrent = true);
  void insertPermanent(const QString&, const QPixmap&);
  void removePermanent(const QString&);

private:
	QString temporaryItem() const { return text( temporary ); }
	void updateItem(const QPixmap& pix, const QString&, int index);
  void saveState();
  void restoreState();
  void applyPermanent();

private:
	bool m_permanent;
	static const int temporary = 0; // the index of our temporary item
	
	int 		m_cursorPos;
  int 		m_currentIndex;
  QString m_currentText;
  QPixmap m_currentPixmap;
};

#endif
