/***************************************************************************
                          fileread.h  -  description
                             -------------------
    begin                : Wed May 23 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEREAD_H
#define FILEREAD_H

#include <kurl.h>

#include <qdom.h>
#include <qvaluelist.h>
#include <qmap.h>

/**File Read operations. This class read a keduca file an pass the records.
  *@author Javier Campos
  */

class FileRead {
public: 
	FileRead();
	~FileRead();
	enum QField { QF_text, QF_picture, QF_type, QF_time, QF_tip, QF_explain };
	enum AField { AF_text, AF_value, AF_point };
  /** Open keduca file. This function can open a remote or local url. */
  bool openFile( const KURL &url );
  /** Set value to questions fields */
  void setQuestion( int Field, QString text);
  /** Set value to questions fields */
  void setQuestion( int Field, int value );
  /** Insert an answer field */
  void setAnswer( QString text, bool value, int points=0);
  /** Go to the Last Record */
  void recordLast();
  /** Go to the First record */
  void recordFirst();
  /** Insert a blank question */
  void insertQuestion();
  /** Record Next */
  void recordNext();
  /** Record previous */
  void recordPrevious();
  /** Go to the Last Record */
  void recordAnswerLast();
  /** Go to the First record */
  void recordAnswerFirst();
  /** Record Next */
  void recordAnswerNext();
  /** Record previous */
  void recordAnswerPrevious();
  /** Get the value of the field question */
  QString getQuestion( int Field );
  /** Get the value of the field questions in integer */
  int getQuestionInt( int Field );
  /** Get Answer field */
  QString getAnswer( int Field );
  /** Get answer field */
  int getAnswerPoints();
  /** Get Answer field */
  bool getAnswerValue();
  /** Returns if this record is a begin of file */
  bool recordBOF();
  /** Returns if this record is a end of file */
  bool recordEOF();
  /** Returns if this record is a begin of file */
  bool recordAnswerBOF();
  /** Returns if this record is a end of file */
  bool recordAnswerEOF();
  /** Clear answers */
  void clearAnswers();
  /** Delete current record */
  void recordDelete();
  /** Swap two variables */
  void recordSwap( bool );
  /** Save file */
  bool saveFile( const KURL &url = "", bool copyimages = false );
  /** Get real picture */
  QString getPicture();
  /** Set header data */
  void setHeader( const QString field, const QString value);
  /** Get Header */
  QString getHeader(const QString &head);
  /** is Multi Answer */
  bool isMultiAnswer();
private: // Private attributes
  /** List of General Variables of the header */
  QMap<QString,QString> Header;
	struct Answers
		{
		QString Text;
		bool Value;
		int Points;
		};
	struct Questions
		{
		QString Text;
		int Type;
		QString Picture;
		int Time;
		QString Tip;
		QString Explain;
		QValueList<Answers> listAnswers;
		QValueListIterator<Answers> RecordAnswers;
		};
	/** List to Data struct */
	QValueList<Questions> listQuestions;
	QValueListIterator<Questions> RecordQuestions;

  /** Returns if the database finds End Of File */
  bool fileEOF;
  /** Returns if the database finds Bof Of File */
  bool fileBOF;
  /** Returns if the database finds End Of File */
  bool fileAnswerEOF;
  /** Returns if the database finds Bof Of File */
  bool fileAnswerBOF;
  /** Current url */
  KURL currentURL;
private: // Private methods
  /** Get an existing file */
  QString getPictureLocal( const QString &file );
  /** Insert xml format data */
  void insertXML( QDomDocument &doc, QDomElement &parent, const QString &tagName, const QString &data);
  /** Insert xml data format */
  void insertXML( QDomDocument &doc, QDomElement &parent, const QString &data);
};

#endif
