
/*****
*
* Copyright (C) 2001, 2002, 2003, 2004, 2005 PreludeIDS Technologies. All Rights Reserved.
* Author: Yoann Vandoorselaere <yoann.v@prelude-ids.com>
* Author: Nicolas Delon <nicolas.delon@prelude-ids.com>
*
* This file is part of the Prelude library.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/* Auto-generated by the GenerateIDMEFTreeWrapH package */

#ifndef _LIBPRELUDE_IDMEF_TREE_WRAP_H
#define _LIBPRELUDE_IDMEF_TREE_WRAP_H

#include <limits.h>
#include "idmef-class.h"
#include "idmef-value.h"
#include "prelude-inttypes.h"
#include "prelude-string.h"
#include "prelude-msg.h"

#ifdef __cplusplus
  extern "C" {
#endif


#define IDMEF_LIST_APPEND  INT_MAX
#define IDMEF_LIST_PREPEND (INT_MAX - 1)

typedef enum {
        IDMEF_ADDITIONAL_DATA_TYPE_ERROR = -1,
        IDMEF_ADDITIONAL_DATA_TYPE_STRING = 0,
        IDMEF_ADDITIONAL_DATA_TYPE_BYTE = 1,
        IDMEF_ADDITIONAL_DATA_TYPE_CHARACTER = 2,
        IDMEF_ADDITIONAL_DATA_TYPE_DATE_TIME = 3,
        IDMEF_ADDITIONAL_DATA_TYPE_INTEGER = 4,
        IDMEF_ADDITIONAL_DATA_TYPE_NTPSTAMP = 5,
        IDMEF_ADDITIONAL_DATA_TYPE_PORTLIST = 6,
        IDMEF_ADDITIONAL_DATA_TYPE_REAL = 7,
        IDMEF_ADDITIONAL_DATA_TYPE_BOOLEAN = 8,
        IDMEF_ADDITIONAL_DATA_TYPE_BYTE_STRING = 9,
        IDMEF_ADDITIONAL_DATA_TYPE_XML = 10
} idmef_additional_data_type_t;


idmef_additional_data_type_t idmef_additional_data_type_to_numeric(const char *name);
const char *idmef_additional_data_type_to_string(idmef_additional_data_type_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         idmef_additional_data_type_t type;
 *         prelude_string_t *meaning;
 *         idmef_data_t data;
 * } TYPE_ID(idmef_additional_data_t, 4);
 */


typedef struct idmef_additional_data idmef_additional_data_t;

int idmef_additional_data_new(idmef_additional_data_t **ret);
int idmef_additional_data_copy(const idmef_additional_data_t *src, idmef_additional_data_t *dst);
int idmef_additional_data_clone(idmef_additional_data_t *src, idmef_additional_data_t **dst);
int idmef_additional_data_compare(const idmef_additional_data_t *obj1, const idmef_additional_data_t *obj2);
idmef_additional_data_t *idmef_additional_data_ref(idmef_additional_data_t *ptr);

#ifndef SWIG
int _idmef_additional_data_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_additional_data_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_additional_data_destroy(idmef_additional_data_t *ptr);
idmef_additional_data_type_t idmef_additional_data_get_type(idmef_additional_data_t *ptr);
void idmef_additional_data_set_type(idmef_additional_data_t *ptr, idmef_additional_data_type_t type);
int idmef_additional_data_new_type(idmef_additional_data_t *ptr, idmef_additional_data_type_t **ret);

prelude_string_t *idmef_additional_data_get_meaning(idmef_additional_data_t *ptr);
void idmef_additional_data_set_meaning(idmef_additional_data_t *ptr, prelude_string_t *meaning);
int idmef_additional_data_new_meaning(idmef_additional_data_t *ptr, prelude_string_t **ret);

idmef_data_t *idmef_additional_data_get_data(idmef_additional_data_t *ptr);
void idmef_additional_data_set_data(idmef_additional_data_t *ptr, idmef_data_t *data);
int idmef_additional_data_new_data(idmef_additional_data_t *ptr, idmef_data_t **ret);

typedef enum {
        IDMEF_REFERENCE_ORIGIN_ERROR = -1,
        IDMEF_REFERENCE_ORIGIN_UNKNOWN = 0,
        IDMEF_REFERENCE_ORIGIN_VENDOR_SPECIFIC = 1,
        IDMEF_REFERENCE_ORIGIN_USER_SPECIFIC = 2,
        IDMEF_REFERENCE_ORIGIN_BUGTRAQID = 3,
        IDMEF_REFERENCE_ORIGIN_CVE = 4,
        IDMEF_REFERENCE_ORIGIN_OSVDB = 5
} idmef_reference_origin_t;


idmef_reference_origin_t idmef_reference_origin_to_numeric(const char *name);
const char *idmef_reference_origin_to_string(idmef_reference_origin_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         idmef_reference_origin_t origin;
 * 
 *         prelude_string_t name;
 *         prelude_string_t url;
 *         prelude_string_t *meaning;
 * } TYPE_ID(idmef_reference_t, 50);
 */


typedef struct idmef_reference idmef_reference_t;

int idmef_reference_new(idmef_reference_t **ret);
int idmef_reference_copy(const idmef_reference_t *src, idmef_reference_t *dst);
int idmef_reference_clone(idmef_reference_t *src, idmef_reference_t **dst);
int idmef_reference_compare(const idmef_reference_t *obj1, const idmef_reference_t *obj2);
idmef_reference_t *idmef_reference_ref(idmef_reference_t *ptr);

#ifndef SWIG
int _idmef_reference_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_reference_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_reference_destroy(idmef_reference_t *ptr);
idmef_reference_origin_t idmef_reference_get_origin(idmef_reference_t *ptr);
void idmef_reference_set_origin(idmef_reference_t *ptr, idmef_reference_origin_t origin);
int idmef_reference_new_origin(idmef_reference_t *ptr, idmef_reference_origin_t **ret);

prelude_string_t *idmef_reference_get_name(idmef_reference_t *ptr);
void idmef_reference_set_name(idmef_reference_t *ptr, prelude_string_t *name);
int idmef_reference_new_name(idmef_reference_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_reference_get_url(idmef_reference_t *ptr);
void idmef_reference_set_url(idmef_reference_t *ptr, prelude_string_t *url);
int idmef_reference_new_url(idmef_reference_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_reference_get_meaning(idmef_reference_t *ptr);
void idmef_reference_set_meaning(idmef_reference_t *ptr, prelude_string_t *meaning);
int idmef_reference_new_meaning(idmef_reference_t *ptr, prelude_string_t **ret);



/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *ident;
 *         prelude_string_t text;
 *         LISTED_OBJECT(reference_list, idmef_reference_t);
 * 
 * } TYPE_ID(idmef_classification_t, 6);
 */


typedef struct idmef_classification idmef_classification_t;

int idmef_classification_new(idmef_classification_t **ret);
int idmef_classification_copy(const idmef_classification_t *src, idmef_classification_t *dst);
int idmef_classification_clone(idmef_classification_t *src, idmef_classification_t **dst);
int idmef_classification_compare(const idmef_classification_t *obj1, const idmef_classification_t *obj2);
idmef_classification_t *idmef_classification_ref(idmef_classification_t *ptr);

#ifndef SWIG
int _idmef_classification_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_classification_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_classification_destroy(idmef_classification_t *ptr);
prelude_string_t *idmef_classification_get_ident(idmef_classification_t *ptr);
void idmef_classification_set_ident(idmef_classification_t *ptr, prelude_string_t *ident);
int idmef_classification_new_ident(idmef_classification_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_classification_get_text(idmef_classification_t *ptr);
void idmef_classification_set_text(idmef_classification_t *ptr, prelude_string_t *text);
int idmef_classification_new_text(idmef_classification_t *ptr, prelude_string_t **ret);

idmef_reference_t *idmef_classification_get_next_reference(idmef_classification_t *ptr, idmef_reference_t *object);
void idmef_classification_set_reference(idmef_classification_t *ptr, idmef_reference_t *object, int pos);
int idmef_classification_new_reference(idmef_classification_t *ptr, idmef_reference_t **ret, int pos);

typedef enum {
        IDMEF_USER_ID_TYPE_ORIGINAL_ERROR = -1,
        IDMEF_USER_ID_TYPE_ORIGINAL_USER = 0,
        IDMEF_USER_ID_TYPE_CURRENT_USER = 1,
        IDMEF_USER_ID_TYPE_TARGET_USER = 2,
        IDMEF_USER_ID_TYPE_USER_PRIVS = 3,
        IDMEF_USER_ID_TYPE_CURRENT_GROUP = 4,
        IDMEF_USER_ID_TYPE_GROUP_PRIVS = 5,
        IDMEF_USER_ID_TYPE_OTHER_PRIVS = 6
} idmef_user_id_type_t;


idmef_user_id_type_t idmef_user_id_type_to_numeric(const char *name);
const char *idmef_user_id_type_to_string(idmef_user_id_type_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t *ident;
 *         idmef_user_id_type_t type;
 *         prelude_string_t *tty;
 *         prelude_string_t *name;
 *         OPTIONAL_INT(uint32_t, number);
 * } TYPE_ID(idmef_user_id_t, 8);
 */


typedef struct idmef_user_id idmef_user_id_t;

int idmef_user_id_new(idmef_user_id_t **ret);
int idmef_user_id_copy(const idmef_user_id_t *src, idmef_user_id_t *dst);
int idmef_user_id_clone(idmef_user_id_t *src, idmef_user_id_t **dst);
int idmef_user_id_compare(const idmef_user_id_t *obj1, const idmef_user_id_t *obj2);
idmef_user_id_t *idmef_user_id_ref(idmef_user_id_t *ptr);

#ifndef SWIG
int _idmef_user_id_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_user_id_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_user_id_destroy(idmef_user_id_t *ptr);
prelude_string_t *idmef_user_id_get_ident(idmef_user_id_t *ptr);
void idmef_user_id_set_ident(idmef_user_id_t *ptr, prelude_string_t *ident);
int idmef_user_id_new_ident(idmef_user_id_t *ptr, prelude_string_t **ret);

idmef_user_id_type_t idmef_user_id_get_type(idmef_user_id_t *ptr);
void idmef_user_id_set_type(idmef_user_id_t *ptr, idmef_user_id_type_t type);
int idmef_user_id_new_type(idmef_user_id_t *ptr, idmef_user_id_type_t **ret);

prelude_string_t *idmef_user_id_get_tty(idmef_user_id_t *ptr);
void idmef_user_id_set_tty(idmef_user_id_t *ptr, prelude_string_t *tty);
int idmef_user_id_new_tty(idmef_user_id_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_user_id_get_name(idmef_user_id_t *ptr);
void idmef_user_id_set_name(idmef_user_id_t *ptr, prelude_string_t *name);
int idmef_user_id_new_name(idmef_user_id_t *ptr, prelude_string_t **ret);

void idmef_user_id_unset_number(idmef_user_id_t *ptr);
uint32_t *idmef_user_id_get_number(idmef_user_id_t *ptr);
void idmef_user_id_set_number(idmef_user_id_t *ptr, uint32_t number);
int idmef_user_id_new_number(idmef_user_id_t *ptr, uint32_t **ret);

typedef enum {
        IDMEF_USER_CATEGORY_ERROR = -1,
        IDMEF_USER_CATEGORY_UNKNOWN = 0,
        IDMEF_USER_CATEGORY_APPLICATION = 1,
        IDMEF_USER_CATEGORY_OS_DEVICE = 2
} idmef_user_category_t;


idmef_user_category_t idmef_user_category_to_numeric(const char *name);
const char *idmef_user_category_to_string(idmef_user_category_t val);




/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *ident;
 *         idmef_user_category_t category;
 *         LISTED_OBJECT(user_id_list, idmef_user_id_t);
 * } TYPE_ID(idmef_user_t, 10);
 */


typedef struct idmef_user idmef_user_t;

int idmef_user_new(idmef_user_t **ret);
int idmef_user_copy(const idmef_user_t *src, idmef_user_t *dst);
int idmef_user_clone(idmef_user_t *src, idmef_user_t **dst);
int idmef_user_compare(const idmef_user_t *obj1, const idmef_user_t *obj2);
idmef_user_t *idmef_user_ref(idmef_user_t *ptr);

#ifndef SWIG
int _idmef_user_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_user_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_user_destroy(idmef_user_t *ptr);
prelude_string_t *idmef_user_get_ident(idmef_user_t *ptr);
void idmef_user_set_ident(idmef_user_t *ptr, prelude_string_t *ident);
int idmef_user_new_ident(idmef_user_t *ptr, prelude_string_t **ret);

idmef_user_category_t idmef_user_get_category(idmef_user_t *ptr);
void idmef_user_set_category(idmef_user_t *ptr, idmef_user_category_t category);
int idmef_user_new_category(idmef_user_t *ptr, idmef_user_category_t **ret);

idmef_user_id_t *idmef_user_get_next_user_id(idmef_user_t *ptr, idmef_user_id_t *object);
void idmef_user_set_user_id(idmef_user_t *ptr, idmef_user_id_t *object, int pos);
int idmef_user_new_user_id(idmef_user_t *ptr, idmef_user_id_t **ret, int pos);

typedef enum {
        IDMEF_ADDRESS_CATEGORY_ERROR = -1,
        IDMEF_ADDRESS_CATEGORY_UNKNOWN = 0,
        IDMEF_ADDRESS_CATEGORY_ATM = 1,
        IDMEF_ADDRESS_CATEGORY_E_MAIL = 2,
        IDMEF_ADDRESS_CATEGORY_LOTUS_NOTES = 3,
        IDMEF_ADDRESS_CATEGORY_MAC = 4,
        IDMEF_ADDRESS_CATEGORY_SNA = 5,
        IDMEF_ADDRESS_CATEGORY_VM = 6,
        IDMEF_ADDRESS_CATEGORY_IPV4_ADDR = 7,
        IDMEF_ADDRESS_CATEGORY_IPV4_ADDR_HEX = 8,
        IDMEF_ADDRESS_CATEGORY_IPV4_NET = 9,
        IDMEF_ADDRESS_CATEGORY_IPV4_NET_MASK = 10,
        IDMEF_ADDRESS_CATEGORY_IPV6_ADDR = 11,
        IDMEF_ADDRESS_CATEGORY_IPV6_ADDR_HEX = 12,
        IDMEF_ADDRESS_CATEGORY_IPV6_NET = 13,
        IDMEF_ADDRESS_CATEGORY_IPV6_NET_MASK = 14
} idmef_address_category_t;


idmef_address_category_t idmef_address_category_to_numeric(const char *name);
const char *idmef_address_category_to_string(idmef_address_category_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t *ident;
 *         idmef_address_category_t category;
 *         prelude_string_t *vlan_name;
 *         OPTIONAL_INT(int32_t, vlan_num);
 *         prelude_string_t address;
 *         prelude_string_t *netmask;
 * } TYPE_ID(idmef_address_t, 12);
 */


typedef struct idmef_address idmef_address_t;

int idmef_address_new(idmef_address_t **ret);
int idmef_address_copy(const idmef_address_t *src, idmef_address_t *dst);
int idmef_address_clone(idmef_address_t *src, idmef_address_t **dst);
int idmef_address_compare(const idmef_address_t *obj1, const idmef_address_t *obj2);
idmef_address_t *idmef_address_ref(idmef_address_t *ptr);

#ifndef SWIG
int _idmef_address_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_address_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_address_destroy(idmef_address_t *ptr);
prelude_string_t *idmef_address_get_ident(idmef_address_t *ptr);
void idmef_address_set_ident(idmef_address_t *ptr, prelude_string_t *ident);
int idmef_address_new_ident(idmef_address_t *ptr, prelude_string_t **ret);

idmef_address_category_t idmef_address_get_category(idmef_address_t *ptr);
void idmef_address_set_category(idmef_address_t *ptr, idmef_address_category_t category);
int idmef_address_new_category(idmef_address_t *ptr, idmef_address_category_t **ret);

prelude_string_t *idmef_address_get_vlan_name(idmef_address_t *ptr);
void idmef_address_set_vlan_name(idmef_address_t *ptr, prelude_string_t *vlan_name);
int idmef_address_new_vlan_name(idmef_address_t *ptr, prelude_string_t **ret);

void idmef_address_unset_vlan_num(idmef_address_t *ptr);
int32_t *idmef_address_get_vlan_num(idmef_address_t *ptr);
void idmef_address_set_vlan_num(idmef_address_t *ptr, int32_t vlan_num);
int idmef_address_new_vlan_num(idmef_address_t *ptr, int32_t **ret);

prelude_string_t *idmef_address_get_address(idmef_address_t *ptr);
void idmef_address_set_address(idmef_address_t *ptr, prelude_string_t *address);
int idmef_address_new_address(idmef_address_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_address_get_netmask(idmef_address_t *ptr);
void idmef_address_set_netmask(idmef_address_t *ptr, prelude_string_t *netmask);
int idmef_address_new_netmask(idmef_address_t *ptr, prelude_string_t **ret);



/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *ident;
 *         prelude_string_t name;
 *         OPTIONAL_INT(uint32_t, pid);
 *         prelude_string_t *path;
 * 
 *         LISTED_OBJECT(arg_list, prelude_string_t);
 *         LISTED_OBJECT(env_list, prelude_string_t);
 * } TYPE_ID(idmef_process_t, 13);
 */


typedef struct idmef_process idmef_process_t;

int idmef_process_new(idmef_process_t **ret);
int idmef_process_copy(const idmef_process_t *src, idmef_process_t *dst);
int idmef_process_clone(idmef_process_t *src, idmef_process_t **dst);
int idmef_process_compare(const idmef_process_t *obj1, const idmef_process_t *obj2);
idmef_process_t *idmef_process_ref(idmef_process_t *ptr);

#ifndef SWIG
int _idmef_process_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_process_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_process_destroy(idmef_process_t *ptr);
prelude_string_t *idmef_process_get_ident(idmef_process_t *ptr);
void idmef_process_set_ident(idmef_process_t *ptr, prelude_string_t *ident);
int idmef_process_new_ident(idmef_process_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_process_get_name(idmef_process_t *ptr);
void idmef_process_set_name(idmef_process_t *ptr, prelude_string_t *name);
int idmef_process_new_name(idmef_process_t *ptr, prelude_string_t **ret);

void idmef_process_unset_pid(idmef_process_t *ptr);
uint32_t *idmef_process_get_pid(idmef_process_t *ptr);
void idmef_process_set_pid(idmef_process_t *ptr, uint32_t pid);
int idmef_process_new_pid(idmef_process_t *ptr, uint32_t **ret);

prelude_string_t *idmef_process_get_path(idmef_process_t *ptr);
void idmef_process_set_path(idmef_process_t *ptr, prelude_string_t *path);
int idmef_process_new_path(idmef_process_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_process_get_next_arg(idmef_process_t *ptr, prelude_string_t *object);
void idmef_process_set_arg(idmef_process_t *ptr, prelude_string_t *object, int pos);
int idmef_process_new_arg(idmef_process_t *ptr, prelude_string_t **ret, int pos);

prelude_string_t *idmef_process_get_next_env(idmef_process_t *ptr, prelude_string_t *object);
void idmef_process_set_env(idmef_process_t *ptr, prelude_string_t *object, int pos);
int idmef_process_new_env(idmef_process_t *ptr, prelude_string_t **ret, int pos);



/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t url;
 *         prelude_string_t *cgi;
 *         prelude_string_t *http_method;
 *         LISTED_OBJECT(arg_list, prelude_string_t);
 * } TYPE_ID(idmef_web_service_t, 14);
 */


typedef struct idmef_web_service idmef_web_service_t;

int idmef_web_service_new(idmef_web_service_t **ret);
int idmef_web_service_copy(const idmef_web_service_t *src, idmef_web_service_t *dst);
int idmef_web_service_clone(idmef_web_service_t *src, idmef_web_service_t **dst);
int idmef_web_service_compare(const idmef_web_service_t *obj1, const idmef_web_service_t *obj2);
idmef_web_service_t *idmef_web_service_ref(idmef_web_service_t *ptr);

#ifndef SWIG
int _idmef_web_service_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_web_service_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_web_service_destroy(idmef_web_service_t *ptr);
prelude_string_t *idmef_web_service_get_url(idmef_web_service_t *ptr);
void idmef_web_service_set_url(idmef_web_service_t *ptr, prelude_string_t *url);
int idmef_web_service_new_url(idmef_web_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_web_service_get_cgi(idmef_web_service_t *ptr);
void idmef_web_service_set_cgi(idmef_web_service_t *ptr, prelude_string_t *cgi);
int idmef_web_service_new_cgi(idmef_web_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_web_service_get_http_method(idmef_web_service_t *ptr);
void idmef_web_service_set_http_method(idmef_web_service_t *ptr, prelude_string_t *http_method);
int idmef_web_service_new_http_method(idmef_web_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_web_service_get_next_arg(idmef_web_service_t *ptr, prelude_string_t *object);
void idmef_web_service_set_arg(idmef_web_service_t *ptr, prelude_string_t *object, int pos);
int idmef_web_service_new_arg(idmef_web_service_t *ptr, prelude_string_t **ret, int pos);



/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *oid;
 *         OPTIONAL_INT(uint32_t, message_processing_model);
 *         OPTIONAL_INT(uint32_t, security_model);
 *         prelude_string_t *security_name;
 *         OPTIONAL_INT(uint32_t, security_level);
 *         prelude_string_t *context_name;
 *         prelude_string_t *context_engine_id;
 *         prelude_string_t *command;
 * 
 * 
 * 
 * 
 *         prelude_string_t *community;
 * } TYPE_ID(idmef_snmp_service_t, 15);
 */


typedef struct idmef_snmp_service idmef_snmp_service_t;

int idmef_snmp_service_new(idmef_snmp_service_t **ret);
int idmef_snmp_service_copy(const idmef_snmp_service_t *src, idmef_snmp_service_t *dst);
int idmef_snmp_service_clone(idmef_snmp_service_t *src, idmef_snmp_service_t **dst);
int idmef_snmp_service_compare(const idmef_snmp_service_t *obj1, const idmef_snmp_service_t *obj2);
idmef_snmp_service_t *idmef_snmp_service_ref(idmef_snmp_service_t *ptr);

#ifndef SWIG
int _idmef_snmp_service_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_snmp_service_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_snmp_service_destroy(idmef_snmp_service_t *ptr);
prelude_string_t *idmef_snmp_service_get_oid(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_oid(idmef_snmp_service_t *ptr, prelude_string_t *oid);
int idmef_snmp_service_new_oid(idmef_snmp_service_t *ptr, prelude_string_t **ret);

void idmef_snmp_service_unset_message_processing_model(idmef_snmp_service_t *ptr);
uint32_t *idmef_snmp_service_get_message_processing_model(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_message_processing_model(idmef_snmp_service_t *ptr, uint32_t message_processing_model);
int idmef_snmp_service_new_message_processing_model(idmef_snmp_service_t *ptr, uint32_t **ret);

void idmef_snmp_service_unset_security_model(idmef_snmp_service_t *ptr);
uint32_t *idmef_snmp_service_get_security_model(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_security_model(idmef_snmp_service_t *ptr, uint32_t security_model);
int idmef_snmp_service_new_security_model(idmef_snmp_service_t *ptr, uint32_t **ret);

prelude_string_t *idmef_snmp_service_get_security_name(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_security_name(idmef_snmp_service_t *ptr, prelude_string_t *security_name);
int idmef_snmp_service_new_security_name(idmef_snmp_service_t *ptr, prelude_string_t **ret);

void idmef_snmp_service_unset_security_level(idmef_snmp_service_t *ptr);
uint32_t *idmef_snmp_service_get_security_level(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_security_level(idmef_snmp_service_t *ptr, uint32_t security_level);
int idmef_snmp_service_new_security_level(idmef_snmp_service_t *ptr, uint32_t **ret);

prelude_string_t *idmef_snmp_service_get_context_name(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_context_name(idmef_snmp_service_t *ptr, prelude_string_t *context_name);
int idmef_snmp_service_new_context_name(idmef_snmp_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_snmp_service_get_context_engine_id(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_context_engine_id(idmef_snmp_service_t *ptr, prelude_string_t *context_engine_id);
int idmef_snmp_service_new_context_engine_id(idmef_snmp_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_snmp_service_get_command(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_command(idmef_snmp_service_t *ptr, prelude_string_t *command);
int idmef_snmp_service_new_command(idmef_snmp_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_snmp_service_get_community(idmef_snmp_service_t *ptr);
void idmef_snmp_service_set_community(idmef_snmp_service_t *ptr, prelude_string_t *community);
int idmef_snmp_service_new_community(idmef_snmp_service_t *ptr, prelude_string_t **ret);

typedef enum {
        IDMEF_SERVICE_TYPE_ERROR = -1,
        IDMEF_SERVICE_TYPE_DEFAULT = 0,
        IDMEF_SERVICE_TYPE_WEB = 1,
        IDMEF_SERVICE_TYPE_SNMP = 2
} idmef_service_type_t;


idmef_service_type_t idmef_service_type_to_numeric(const char *name);
const char *idmef_service_type_to_string(idmef_service_type_t val);




/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *ident;
 * 
 *         OPTIONAL_INT(uint8_t, ip_version);
 *         OPTIONAL_INT(uint8_t, iana_protocol_number);
 *         prelude_string_t *iana_protocol_name;
 * 
 *         prelude_string_t *name;
 *         OPTIONAL_INT(uint16_t, port);
 *         prelude_string_t *portlist;
 *         prelude_string_t *protocol;
 * 
 *         UNION(idmef_service_type_t, type) {
 *                 UNION_MEMBER(IDMEF_SERVICE_TYPE_WEB, idmef_web_service_t, *web_service);
 *                 UNION_MEMBER(IDMEF_SERVICE_TYPE_SNMP, idmef_snmp_service_t, *snmp_service);
 *         } specific;
 * 
 * } TYPE_ID(idmef_service_t, 17);
 */


typedef struct idmef_service idmef_service_t;

int idmef_service_new(idmef_service_t **ret);
int idmef_service_copy(const idmef_service_t *src, idmef_service_t *dst);
int idmef_service_clone(idmef_service_t *src, idmef_service_t **dst);
int idmef_service_compare(const idmef_service_t *obj1, const idmef_service_t *obj2);
idmef_service_t *idmef_service_ref(idmef_service_t *ptr);

#ifndef SWIG
int _idmef_service_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_service_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_service_destroy(idmef_service_t *ptr);
prelude_string_t *idmef_service_get_ident(idmef_service_t *ptr);
void idmef_service_set_ident(idmef_service_t *ptr, prelude_string_t *ident);
int idmef_service_new_ident(idmef_service_t *ptr, prelude_string_t **ret);

void idmef_service_unset_ip_version(idmef_service_t *ptr);
uint8_t *idmef_service_get_ip_version(idmef_service_t *ptr);
void idmef_service_set_ip_version(idmef_service_t *ptr, uint8_t ip_version);
int idmef_service_new_ip_version(idmef_service_t *ptr, uint8_t **ret);

void idmef_service_unset_iana_protocol_number(idmef_service_t *ptr);
uint8_t *idmef_service_get_iana_protocol_number(idmef_service_t *ptr);
void idmef_service_set_iana_protocol_number(idmef_service_t *ptr, uint8_t iana_protocol_number);
int idmef_service_new_iana_protocol_number(idmef_service_t *ptr, uint8_t **ret);

prelude_string_t *idmef_service_get_iana_protocol_name(idmef_service_t *ptr);
void idmef_service_set_iana_protocol_name(idmef_service_t *ptr, prelude_string_t *iana_protocol_name);
int idmef_service_new_iana_protocol_name(idmef_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_service_get_name(idmef_service_t *ptr);
void idmef_service_set_name(idmef_service_t *ptr, prelude_string_t *name);
int idmef_service_new_name(idmef_service_t *ptr, prelude_string_t **ret);

void idmef_service_unset_port(idmef_service_t *ptr);
uint16_t *idmef_service_get_port(idmef_service_t *ptr);
void idmef_service_set_port(idmef_service_t *ptr, uint16_t port);
int idmef_service_new_port(idmef_service_t *ptr, uint16_t **ret);

prelude_string_t *idmef_service_get_portlist(idmef_service_t *ptr);
void idmef_service_set_portlist(idmef_service_t *ptr, prelude_string_t *portlist);
int idmef_service_new_portlist(idmef_service_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_service_get_protocol(idmef_service_t *ptr);
void idmef_service_set_protocol(idmef_service_t *ptr, prelude_string_t *protocol);
int idmef_service_new_protocol(idmef_service_t *ptr, prelude_string_t **ret);

idmef_service_type_t idmef_service_get_type(idmef_service_t *ptr);
idmef_web_service_t *idmef_service_get_web_service(idmef_service_t *ptr);
void idmef_service_set_web_service(idmef_service_t *ptr, idmef_web_service_t *web_service);
int idmef_service_new_web_service(idmef_service_t *ptr, idmef_web_service_t **ret);

idmef_snmp_service_t *idmef_service_get_snmp_service(idmef_service_t *ptr);
void idmef_service_set_snmp_service(idmef_service_t *ptr, idmef_snmp_service_t *snmp_service);
int idmef_service_new_snmp_service(idmef_service_t *ptr, idmef_snmp_service_t **ret);

typedef enum {
        IDMEF_NODE_CATEGORY_ERROR = -1,
        IDMEF_NODE_CATEGORY_UNKNOWN = 0,
        IDMEF_NODE_CATEGORY_ADS = 1,
        IDMEF_NODE_CATEGORY_AFS = 2,
        IDMEF_NODE_CATEGORY_CODA = 3,
        IDMEF_NODE_CATEGORY_DFS = 4,
        IDMEF_NODE_CATEGORY_DNS = 5,
        IDMEF_NODE_CATEGORY_HOSTS = 6,
        IDMEF_NODE_CATEGORY_KERBEROS = 7,
        IDMEF_NODE_CATEGORY_NDS = 8,
        IDMEF_NODE_CATEGORY_NIS = 9,
        IDMEF_NODE_CATEGORY_NISPLUS = 10,
        IDMEF_NODE_CATEGORY_NT = 11,
        IDMEF_NODE_CATEGORY_WFW = 12
} idmef_node_category_t;


idmef_node_category_t idmef_node_category_to_numeric(const char *name);
const char *idmef_node_category_to_string(idmef_node_category_t val);




/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *ident;
 *         idmef_node_category_t category;
 *         prelude_string_t *location;
 *         prelude_string_t *name;
 *         LISTED_OBJECT(address_list, idmef_address_t);
 * } TYPE_ID(idmef_node_t, 19);
 */


typedef struct idmef_node idmef_node_t;

int idmef_node_new(idmef_node_t **ret);
int idmef_node_copy(const idmef_node_t *src, idmef_node_t *dst);
int idmef_node_clone(idmef_node_t *src, idmef_node_t **dst);
int idmef_node_compare(const idmef_node_t *obj1, const idmef_node_t *obj2);
idmef_node_t *idmef_node_ref(idmef_node_t *ptr);

#ifndef SWIG
int _idmef_node_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_node_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_node_destroy(idmef_node_t *ptr);
prelude_string_t *idmef_node_get_ident(idmef_node_t *ptr);
void idmef_node_set_ident(idmef_node_t *ptr, prelude_string_t *ident);
int idmef_node_new_ident(idmef_node_t *ptr, prelude_string_t **ret);

idmef_node_category_t idmef_node_get_category(idmef_node_t *ptr);
void idmef_node_set_category(idmef_node_t *ptr, idmef_node_category_t category);
int idmef_node_new_category(idmef_node_t *ptr, idmef_node_category_t **ret);

prelude_string_t *idmef_node_get_location(idmef_node_t *ptr);
void idmef_node_set_location(idmef_node_t *ptr, prelude_string_t *location);
int idmef_node_new_location(idmef_node_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_node_get_name(idmef_node_t *ptr);
void idmef_node_set_name(idmef_node_t *ptr, prelude_string_t *name);
int idmef_node_new_name(idmef_node_t *ptr, prelude_string_t **ret);

idmef_address_t *idmef_node_get_next_address(idmef_node_t *ptr, idmef_address_t *object);
void idmef_node_set_address(idmef_node_t *ptr, idmef_address_t *object, int pos);
int idmef_node_new_address(idmef_node_t *ptr, idmef_address_t **ret, int pos);

typedef enum {
        IDMEF_SOURCE_SPOOFED_ERROR = -1,
        IDMEF_SOURCE_SPOOFED_UNKNOWN = 0,
        IDMEF_SOURCE_SPOOFED_YES = 1,
        IDMEF_SOURCE_SPOOFED_NO = 2
} idmef_source_spoofed_t;


idmef_source_spoofed_t idmef_source_spoofed_to_numeric(const char *name);
const char *idmef_source_spoofed_to_string(idmef_source_spoofed_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t *ident;
 * 
 *         idmef_source_spoofed_t spoofed;
 *         prelude_string_t *interface;
 * 
 *         idmef_node_t *node;
 *         idmef_user_t *user;
 *         idmef_process_t *process;
 *         idmef_service_t *service;
 * 
 * } TYPE_ID(idmef_source_t, 21);
 */


typedef struct idmef_source idmef_source_t;

int idmef_source_new(idmef_source_t **ret);
int idmef_source_copy(const idmef_source_t *src, idmef_source_t *dst);
int idmef_source_clone(idmef_source_t *src, idmef_source_t **dst);
int idmef_source_compare(const idmef_source_t *obj1, const idmef_source_t *obj2);
idmef_source_t *idmef_source_ref(idmef_source_t *ptr);

#ifndef SWIG
int _idmef_source_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_source_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_source_destroy(idmef_source_t *ptr);
prelude_string_t *idmef_source_get_ident(idmef_source_t *ptr);
void idmef_source_set_ident(idmef_source_t *ptr, prelude_string_t *ident);
int idmef_source_new_ident(idmef_source_t *ptr, prelude_string_t **ret);

idmef_source_spoofed_t idmef_source_get_spoofed(idmef_source_t *ptr);
void idmef_source_set_spoofed(idmef_source_t *ptr, idmef_source_spoofed_t spoofed);
int idmef_source_new_spoofed(idmef_source_t *ptr, idmef_source_spoofed_t **ret);

prelude_string_t *idmef_source_get_interface(idmef_source_t *ptr);
void idmef_source_set_interface(idmef_source_t *ptr, prelude_string_t *interface);
int idmef_source_new_interface(idmef_source_t *ptr, prelude_string_t **ret);

idmef_node_t *idmef_source_get_node(idmef_source_t *ptr);
void idmef_source_set_node(idmef_source_t *ptr, idmef_node_t *node);
int idmef_source_new_node(idmef_source_t *ptr, idmef_node_t **ret);

idmef_user_t *idmef_source_get_user(idmef_source_t *ptr);
void idmef_source_set_user(idmef_source_t *ptr, idmef_user_t *user);
int idmef_source_new_user(idmef_source_t *ptr, idmef_user_t **ret);

idmef_process_t *idmef_source_get_process(idmef_source_t *ptr);
void idmef_source_set_process(idmef_source_t *ptr, idmef_process_t *process);
int idmef_source_new_process(idmef_source_t *ptr, idmef_process_t **ret);

idmef_service_t *idmef_source_get_service(idmef_source_t *ptr);
void idmef_source_set_service(idmef_source_t *ptr, idmef_service_t *service);
int idmef_source_new_service(idmef_source_t *ptr, idmef_service_t **ret);



/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 * 
 *         idmef_user_id_t user_id;
 *         LISTED_OBJECT(permission_list, prelude_string_t);
 * } TYPE_ID(idmef_file_access_t, 22);
 */


typedef struct idmef_file_access idmef_file_access_t;

int idmef_file_access_new(idmef_file_access_t **ret);
int idmef_file_access_copy(const idmef_file_access_t *src, idmef_file_access_t *dst);
int idmef_file_access_clone(idmef_file_access_t *src, idmef_file_access_t **dst);
int idmef_file_access_compare(const idmef_file_access_t *obj1, const idmef_file_access_t *obj2);
idmef_file_access_t *idmef_file_access_ref(idmef_file_access_t *ptr);

#ifndef SWIG
int _idmef_file_access_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_file_access_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_file_access_destroy(idmef_file_access_t *ptr);
idmef_user_id_t *idmef_file_access_get_user_id(idmef_file_access_t *ptr);
void idmef_file_access_set_user_id(idmef_file_access_t *ptr, idmef_user_id_t *user_id);
int idmef_file_access_new_user_id(idmef_file_access_t *ptr, idmef_user_id_t **ret);

prelude_string_t *idmef_file_access_get_next_permission(idmef_file_access_t *ptr, prelude_string_t *object);
void idmef_file_access_set_permission(idmef_file_access_t *ptr, prelude_string_t *object, int pos);
int idmef_file_access_new_permission(idmef_file_access_t *ptr, prelude_string_t **ret, int pos);



/*
 * struct {
 *         REFCOUNT;
 *         idmef_time_t *change_time;
 *         OPTIONAL_INT(uint32_t, number);
 *         OPTIONAL_INT(uint32_t, major_device);
 *         OPTIONAL_INT(uint32_t, minor_device);
 *         OPTIONAL_INT(uint32_t, c_major_device);
 *         OPTIONAL_INT(uint32_t, c_minor_device);
 * } TYPE_ID(idmef_inode_t, 23);
 */


typedef struct idmef_inode idmef_inode_t;

int idmef_inode_new(idmef_inode_t **ret);
int idmef_inode_copy(const idmef_inode_t *src, idmef_inode_t *dst);
int idmef_inode_clone(idmef_inode_t *src, idmef_inode_t **dst);
int idmef_inode_compare(const idmef_inode_t *obj1, const idmef_inode_t *obj2);
idmef_inode_t *idmef_inode_ref(idmef_inode_t *ptr);

#ifndef SWIG
int _idmef_inode_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_inode_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_inode_destroy(idmef_inode_t *ptr);
idmef_time_t *idmef_inode_get_change_time(idmef_inode_t *ptr);
void idmef_inode_set_change_time(idmef_inode_t *ptr, idmef_time_t *change_time);
int idmef_inode_new_change_time(idmef_inode_t *ptr, idmef_time_t **ret);

void idmef_inode_unset_number(idmef_inode_t *ptr);
uint32_t *idmef_inode_get_number(idmef_inode_t *ptr);
void idmef_inode_set_number(idmef_inode_t *ptr, uint32_t number);
int idmef_inode_new_number(idmef_inode_t *ptr, uint32_t **ret);

void idmef_inode_unset_major_device(idmef_inode_t *ptr);
uint32_t *idmef_inode_get_major_device(idmef_inode_t *ptr);
void idmef_inode_set_major_device(idmef_inode_t *ptr, uint32_t major_device);
int idmef_inode_new_major_device(idmef_inode_t *ptr, uint32_t **ret);

void idmef_inode_unset_minor_device(idmef_inode_t *ptr);
uint32_t *idmef_inode_get_minor_device(idmef_inode_t *ptr);
void idmef_inode_set_minor_device(idmef_inode_t *ptr, uint32_t minor_device);
int idmef_inode_new_minor_device(idmef_inode_t *ptr, uint32_t **ret);

void idmef_inode_unset_c_major_device(idmef_inode_t *ptr);
uint32_t *idmef_inode_get_c_major_device(idmef_inode_t *ptr);
void idmef_inode_set_c_major_device(idmef_inode_t *ptr, uint32_t c_major_device);
int idmef_inode_new_c_major_device(idmef_inode_t *ptr, uint32_t **ret);

void idmef_inode_unset_c_minor_device(idmef_inode_t *ptr);
uint32_t *idmef_inode_get_c_minor_device(idmef_inode_t *ptr);
void idmef_inode_set_c_minor_device(idmef_inode_t *ptr, uint32_t c_minor_device);
int idmef_inode_new_c_minor_device(idmef_inode_t *ptr, uint32_t **ret);


typedef struct idmef_linkage idmef_linkage_t;

typedef enum {
        IDMEF_CHECKSUM_ALGORITHM_ERROR = -1,
        IDMEF_CHECKSUM_ALGORITHM_MD4 = 1,
        IDMEF_CHECKSUM_ALGORITHM_MD5 = 2,
        IDMEF_CHECKSUM_ALGORITHM_SHA1 = 3,
        IDMEF_CHECKSUM_ALGORITHM_SHA2_256 = 4,
        IDMEF_CHECKSUM_ALGORITHM_SHA2_384 = 5,
        IDMEF_CHECKSUM_ALGORITHM_SHA2_512 = 6,
        IDMEF_CHECKSUM_ALGORITHM_CRC_32 = 7,
        IDMEF_CHECKSUM_ALGORITHM_HAVAL = 8,
        IDMEF_CHECKSUM_ALGORITHM_TIGER = 9,
        IDMEF_CHECKSUM_ALGORITHM_GOST = 11
} idmef_checksum_algorithm_t;


idmef_checksum_algorithm_t idmef_checksum_algorithm_to_numeric(const char *name);
const char *idmef_checksum_algorithm_to_string(idmef_checksum_algorithm_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t value;
 *         prelude_string_t *key;
 *         idmef_checksum_algorithm_t algorithm;
 * } TYPE_ID(idmef_checksum_t, 52);
 */


typedef struct idmef_checksum idmef_checksum_t;

int idmef_checksum_new(idmef_checksum_t **ret);
int idmef_checksum_copy(const idmef_checksum_t *src, idmef_checksum_t *dst);
int idmef_checksum_clone(idmef_checksum_t *src, idmef_checksum_t **dst);
int idmef_checksum_compare(const idmef_checksum_t *obj1, const idmef_checksum_t *obj2);
idmef_checksum_t *idmef_checksum_ref(idmef_checksum_t *ptr);

#ifndef SWIG
int _idmef_checksum_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_checksum_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_checksum_destroy(idmef_checksum_t *ptr);
prelude_string_t *idmef_checksum_get_value(idmef_checksum_t *ptr);
void idmef_checksum_set_value(idmef_checksum_t *ptr, prelude_string_t *value);
int idmef_checksum_new_value(idmef_checksum_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_checksum_get_key(idmef_checksum_t *ptr);
void idmef_checksum_set_key(idmef_checksum_t *ptr, prelude_string_t *key);
int idmef_checksum_new_key(idmef_checksum_t *ptr, prelude_string_t **ret);

idmef_checksum_algorithm_t idmef_checksum_get_algorithm(idmef_checksum_t *ptr);
void idmef_checksum_set_algorithm(idmef_checksum_t *ptr, idmef_checksum_algorithm_t algorithm);
int idmef_checksum_new_algorithm(idmef_checksum_t *ptr, idmef_checksum_algorithm_t **ret);

typedef enum {
        IDMEF_FILE_CATEGORY_ERROR = -1,
        IDMEF_FILE_CATEGORY_CURRENT = 1,
        IDMEF_FILE_CATEGORY_ORIGINAL = 2
} idmef_file_category_t;


idmef_file_category_t idmef_file_category_to_numeric(const char *name);
const char *idmef_file_category_to_string(idmef_file_category_t val);


typedef enum {
        IDMEF_FILE_FSTYPE_ERROR = -1,
        IDMEF_FILE_FSTYPE_UFS = 1,
        IDMEF_FILE_FSTYPE_EFS = 2,
        IDMEF_FILE_FSTYPE_NFS = 3,
        IDMEF_FILE_FSTYPE_AFS = 4,
        IDMEF_FILE_FSTYPE_NTFS = 5,
        IDMEF_FILE_FSTYPE_FAT16 = 6,
        IDMEF_FILE_FSTYPE_FAT32 = 7,
        IDMEF_FILE_FSTYPE_PCFS = 8,
        IDMEF_FILE_FSTYPE_JOLIET = 9,
        IDMEF_FILE_FSTYPE_ISO9660 = 10
} idmef_file_fstype_t;


idmef_file_fstype_t idmef_file_fstype_to_numeric(const char *name);
const char *idmef_file_fstype_to_string(idmef_file_fstype_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t *ident;
 * 
 *         prelude_string_t name;
 *         prelude_string_t path;
 * 
 *         idmef_time_t *create_time;
 *         idmef_time_t *modify_time;
 *         idmef_time_t *access_time;
 * 
 * 
 *         OPTIONAL_INT(uint64_t, data_size);
 *         OPTIONAL_INT(uint64_t, disk_size);
 * 
 *         LISTED_OBJECT(file_access_list, idmef_file_access_t);
 *         LISTED_OBJECT(linkage_list, idmef_linkage_t);
 * 
 *         idmef_inode_t *inode;
 *         LISTED_OBJECT(checksum_list, idmef_checksum_t);
 * 
 *         idmef_file_category_t category;
 *         OPTIONAL_INT(idmef_file_fstype_t, fstype);
 *         prelude_string_t *file_type;
 * 
 * } TYPE_ID(idmef_file_t, 26);
 */


typedef struct idmef_file idmef_file_t;

int idmef_file_new(idmef_file_t **ret);
int idmef_file_copy(const idmef_file_t *src, idmef_file_t *dst);
int idmef_file_clone(idmef_file_t *src, idmef_file_t **dst);
int idmef_file_compare(const idmef_file_t *obj1, const idmef_file_t *obj2);
idmef_file_t *idmef_file_ref(idmef_file_t *ptr);

#ifndef SWIG
int _idmef_file_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_file_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_file_destroy(idmef_file_t *ptr);
prelude_string_t *idmef_file_get_ident(idmef_file_t *ptr);
void idmef_file_set_ident(idmef_file_t *ptr, prelude_string_t *ident);
int idmef_file_new_ident(idmef_file_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_file_get_name(idmef_file_t *ptr);
void idmef_file_set_name(idmef_file_t *ptr, prelude_string_t *name);
int idmef_file_new_name(idmef_file_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_file_get_path(idmef_file_t *ptr);
void idmef_file_set_path(idmef_file_t *ptr, prelude_string_t *path);
int idmef_file_new_path(idmef_file_t *ptr, prelude_string_t **ret);

idmef_time_t *idmef_file_get_create_time(idmef_file_t *ptr);
void idmef_file_set_create_time(idmef_file_t *ptr, idmef_time_t *create_time);
int idmef_file_new_create_time(idmef_file_t *ptr, idmef_time_t **ret);

idmef_time_t *idmef_file_get_modify_time(idmef_file_t *ptr);
void idmef_file_set_modify_time(idmef_file_t *ptr, idmef_time_t *modify_time);
int idmef_file_new_modify_time(idmef_file_t *ptr, idmef_time_t **ret);

idmef_time_t *idmef_file_get_access_time(idmef_file_t *ptr);
void idmef_file_set_access_time(idmef_file_t *ptr, idmef_time_t *access_time);
int idmef_file_new_access_time(idmef_file_t *ptr, idmef_time_t **ret);

void idmef_file_unset_data_size(idmef_file_t *ptr);
uint64_t *idmef_file_get_data_size(idmef_file_t *ptr);
void idmef_file_set_data_size(idmef_file_t *ptr, uint64_t data_size);
int idmef_file_new_data_size(idmef_file_t *ptr, uint64_t **ret);

void idmef_file_unset_disk_size(idmef_file_t *ptr);
uint64_t *idmef_file_get_disk_size(idmef_file_t *ptr);
void idmef_file_set_disk_size(idmef_file_t *ptr, uint64_t disk_size);
int idmef_file_new_disk_size(idmef_file_t *ptr, uint64_t **ret);

idmef_file_access_t *idmef_file_get_next_file_access(idmef_file_t *ptr, idmef_file_access_t *object);
void idmef_file_set_file_access(idmef_file_t *ptr, idmef_file_access_t *object, int pos);
int idmef_file_new_file_access(idmef_file_t *ptr, idmef_file_access_t **ret, int pos);

idmef_linkage_t *idmef_file_get_next_linkage(idmef_file_t *ptr, idmef_linkage_t *object);
void idmef_file_set_linkage(idmef_file_t *ptr, idmef_linkage_t *object, int pos);
int idmef_file_new_linkage(idmef_file_t *ptr, idmef_linkage_t **ret, int pos);

idmef_inode_t *idmef_file_get_inode(idmef_file_t *ptr);
void idmef_file_set_inode(idmef_file_t *ptr, idmef_inode_t *inode);
int idmef_file_new_inode(idmef_file_t *ptr, idmef_inode_t **ret);

idmef_checksum_t *idmef_file_get_next_checksum(idmef_file_t *ptr, idmef_checksum_t *object);
void idmef_file_set_checksum(idmef_file_t *ptr, idmef_checksum_t *object, int pos);
int idmef_file_new_checksum(idmef_file_t *ptr, idmef_checksum_t **ret, int pos);

idmef_file_category_t idmef_file_get_category(idmef_file_t *ptr);
void idmef_file_set_category(idmef_file_t *ptr, idmef_file_category_t category);
int idmef_file_new_category(idmef_file_t *ptr, idmef_file_category_t **ret);

void idmef_file_unset_fstype(idmef_file_t *ptr);
idmef_file_fstype_t *idmef_file_get_fstype(idmef_file_t *ptr);
void idmef_file_set_fstype(idmef_file_t *ptr, idmef_file_fstype_t fstype);
int idmef_file_new_fstype(idmef_file_t *ptr, idmef_file_fstype_t **ret);

prelude_string_t *idmef_file_get_file_type(idmef_file_t *ptr);
void idmef_file_set_file_type(idmef_file_t *ptr, prelude_string_t *file_type);
int idmef_file_new_file_type(idmef_file_t *ptr, prelude_string_t **ret);

typedef enum {
        IDMEF_LINKAGE_CATEGORY_ERROR = -1,
        IDMEF_LINKAGE_CATEGORY_HARD_LINK = 1,
        IDMEF_LINKAGE_CATEGORY_MOUNT_POINT = 2,
        IDMEF_LINKAGE_CATEGORY_REPARSE_POINT = 3,
        IDMEF_LINKAGE_CATEGORY_SHORTCUT = 4,
        IDMEF_LINKAGE_CATEGORY_STREAM = 5,
        IDMEF_LINKAGE_CATEGORY_SYMBOLIC_LINK = 6
} idmef_linkage_category_t;


idmef_linkage_category_t idmef_linkage_category_to_numeric(const char *name);
const char *idmef_linkage_category_to_string(idmef_linkage_category_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 * 
 *         idmef_linkage_category_t category;
 *         prelude_string_t name;
 *         prelude_string_t path;
 *         idmef_file_t *file;
 * } TYPE_ID(idmef_linkage_t, 28);
 */

int idmef_linkage_new(idmef_linkage_t **ret);
int idmef_linkage_copy(const idmef_linkage_t *src, idmef_linkage_t *dst);
int idmef_linkage_clone(idmef_linkage_t *src, idmef_linkage_t **dst);
int idmef_linkage_compare(const idmef_linkage_t *obj1, const idmef_linkage_t *obj2);
idmef_linkage_t *idmef_linkage_ref(idmef_linkage_t *ptr);

#ifndef SWIG
int _idmef_linkage_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_linkage_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_linkage_destroy(idmef_linkage_t *ptr);
idmef_linkage_category_t idmef_linkage_get_category(idmef_linkage_t *ptr);
void idmef_linkage_set_category(idmef_linkage_t *ptr, idmef_linkage_category_t category);
int idmef_linkage_new_category(idmef_linkage_t *ptr, idmef_linkage_category_t **ret);

prelude_string_t *idmef_linkage_get_name(idmef_linkage_t *ptr);
void idmef_linkage_set_name(idmef_linkage_t *ptr, prelude_string_t *name);
int idmef_linkage_new_name(idmef_linkage_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_linkage_get_path(idmef_linkage_t *ptr);
void idmef_linkage_set_path(idmef_linkage_t *ptr, prelude_string_t *path);
int idmef_linkage_new_path(idmef_linkage_t *ptr, prelude_string_t **ret);

idmef_file_t *idmef_linkage_get_file(idmef_linkage_t *ptr);
void idmef_linkage_set_file(idmef_linkage_t *ptr, idmef_file_t *file);
int idmef_linkage_new_file(idmef_linkage_t *ptr, idmef_file_t **ret);

typedef enum {
        IDMEF_TARGET_DECOY_ERROR = -1,
        IDMEF_TARGET_DECOY_UNKNOWN = 0,
        IDMEF_TARGET_DECOY_YES = 1,
        IDMEF_TARGET_DECOY_NO = 2
} idmef_target_decoy_t;


idmef_target_decoy_t idmef_target_decoy_to_numeric(const char *name);
const char *idmef_target_decoy_to_string(idmef_target_decoy_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t *ident;
 * 
 *         idmef_target_decoy_t decoy;
 *         prelude_string_t *interface;
 * 
 *         idmef_node_t *node;
 *         idmef_user_t *user;
 *         idmef_process_t *process;
 *         idmef_service_t *service;
 *         LISTED_OBJECT(file_list, idmef_file_t);
 * } TYPE_ID(idmef_target_t, 30);
 */


typedef struct idmef_target idmef_target_t;

int idmef_target_new(idmef_target_t **ret);
int idmef_target_copy(const idmef_target_t *src, idmef_target_t *dst);
int idmef_target_clone(idmef_target_t *src, idmef_target_t **dst);
int idmef_target_compare(const idmef_target_t *obj1, const idmef_target_t *obj2);
idmef_target_t *idmef_target_ref(idmef_target_t *ptr);

#ifndef SWIG
int _idmef_target_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_target_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_target_destroy(idmef_target_t *ptr);
prelude_string_t *idmef_target_get_ident(idmef_target_t *ptr);
void idmef_target_set_ident(idmef_target_t *ptr, prelude_string_t *ident);
int idmef_target_new_ident(idmef_target_t *ptr, prelude_string_t **ret);

idmef_target_decoy_t idmef_target_get_decoy(idmef_target_t *ptr);
void idmef_target_set_decoy(idmef_target_t *ptr, idmef_target_decoy_t decoy);
int idmef_target_new_decoy(idmef_target_t *ptr, idmef_target_decoy_t **ret);

prelude_string_t *idmef_target_get_interface(idmef_target_t *ptr);
void idmef_target_set_interface(idmef_target_t *ptr, prelude_string_t *interface);
int idmef_target_new_interface(idmef_target_t *ptr, prelude_string_t **ret);

idmef_node_t *idmef_target_get_node(idmef_target_t *ptr);
void idmef_target_set_node(idmef_target_t *ptr, idmef_node_t *node);
int idmef_target_new_node(idmef_target_t *ptr, idmef_node_t **ret);

idmef_user_t *idmef_target_get_user(idmef_target_t *ptr);
void idmef_target_set_user(idmef_target_t *ptr, idmef_user_t *user);
int idmef_target_new_user(idmef_target_t *ptr, idmef_user_t **ret);

idmef_process_t *idmef_target_get_process(idmef_target_t *ptr);
void idmef_target_set_process(idmef_target_t *ptr, idmef_process_t *process);
int idmef_target_new_process(idmef_target_t *ptr, idmef_process_t **ret);

idmef_service_t *idmef_target_get_service(idmef_target_t *ptr);
void idmef_target_set_service(idmef_target_t *ptr, idmef_service_t *service);
int idmef_target_new_service(idmef_target_t *ptr, idmef_service_t **ret);

idmef_file_t *idmef_target_get_next_file(idmef_target_t *ptr, idmef_file_t *object);
void idmef_target_set_file(idmef_target_t *ptr, idmef_file_t *object, int pos);
int idmef_target_new_file(idmef_target_t *ptr, idmef_file_t **ret, int pos);



/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 *         prelude_string_t *analyzerid;
 * 
 *         prelude_string_t *name;
 *         prelude_string_t *manufacturer;
 *         prelude_string_t *model;
 *         prelude_string_t *version;
 *         prelude_string_t *class;
 *         prelude_string_t *ostype;
 *         prelude_string_t *osversion;
 * 
 *         idmef_node_t *node;
 *         idmef_process_t *process;
 * 
 * } TYPE_ID(idmef_analyzer_t, 31);
 */


typedef struct idmef_analyzer idmef_analyzer_t;

int idmef_analyzer_new(idmef_analyzer_t **ret);
int idmef_analyzer_copy(const idmef_analyzer_t *src, idmef_analyzer_t *dst);
int idmef_analyzer_clone(idmef_analyzer_t *src, idmef_analyzer_t **dst);
int idmef_analyzer_compare(const idmef_analyzer_t *obj1, const idmef_analyzer_t *obj2);
idmef_analyzer_t *idmef_analyzer_ref(idmef_analyzer_t *ptr);

#ifndef SWIG
int _idmef_analyzer_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_analyzer_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_analyzer_destroy(idmef_analyzer_t *ptr);
prelude_string_t *idmef_analyzer_get_analyzerid(idmef_analyzer_t *ptr);
void idmef_analyzer_set_analyzerid(idmef_analyzer_t *ptr, prelude_string_t *analyzerid);
int idmef_analyzer_new_analyzerid(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_name(idmef_analyzer_t *ptr);
void idmef_analyzer_set_name(idmef_analyzer_t *ptr, prelude_string_t *name);
int idmef_analyzer_new_name(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_manufacturer(idmef_analyzer_t *ptr);
void idmef_analyzer_set_manufacturer(idmef_analyzer_t *ptr, prelude_string_t *manufacturer);
int idmef_analyzer_new_manufacturer(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_model(idmef_analyzer_t *ptr);
void idmef_analyzer_set_model(idmef_analyzer_t *ptr, prelude_string_t *model);
int idmef_analyzer_new_model(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_version(idmef_analyzer_t *ptr);
void idmef_analyzer_set_version(idmef_analyzer_t *ptr, prelude_string_t *version);
int idmef_analyzer_new_version(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_class(idmef_analyzer_t *ptr);
void idmef_analyzer_set_class(idmef_analyzer_t *ptr, prelude_string_t *class_str);
int idmef_analyzer_new_class(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_ostype(idmef_analyzer_t *ptr);
void idmef_analyzer_set_ostype(idmef_analyzer_t *ptr, prelude_string_t *ostype);
int idmef_analyzer_new_ostype(idmef_analyzer_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_analyzer_get_osversion(idmef_analyzer_t *ptr);
void idmef_analyzer_set_osversion(idmef_analyzer_t *ptr, prelude_string_t *osversion);
int idmef_analyzer_new_osversion(idmef_analyzer_t *ptr, prelude_string_t **ret);

idmef_node_t *idmef_analyzer_get_node(idmef_analyzer_t *ptr);
void idmef_analyzer_set_node(idmef_analyzer_t *ptr, idmef_node_t *node);
int idmef_analyzer_new_node(idmef_analyzer_t *ptr, idmef_node_t **ret);

idmef_process_t *idmef_analyzer_get_process(idmef_analyzer_t *ptr);
void idmef_analyzer_set_process(idmef_analyzer_t *ptr, idmef_process_t *process);
int idmef_analyzer_new_process(idmef_analyzer_t *ptr, idmef_process_t **ret);



/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 * 
 *         prelude_string_t alertident;
 *         prelude_string_t *analyzerid;
 * 
 * } TYPE_ID(idmef_alertident_t, 32);
 */


typedef struct idmef_alertident idmef_alertident_t;

int idmef_alertident_new(idmef_alertident_t **ret);
int idmef_alertident_copy(const idmef_alertident_t *src, idmef_alertident_t *dst);
int idmef_alertident_clone(idmef_alertident_t *src, idmef_alertident_t **dst);
int idmef_alertident_compare(const idmef_alertident_t *obj1, const idmef_alertident_t *obj2);
idmef_alertident_t *idmef_alertident_ref(idmef_alertident_t *ptr);

#ifndef SWIG
int _idmef_alertident_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_alertident_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_alertident_destroy(idmef_alertident_t *ptr);
prelude_string_t *idmef_alertident_get_alertident(idmef_alertident_t *ptr);
void idmef_alertident_set_alertident(idmef_alertident_t *ptr, prelude_string_t *alertident);
int idmef_alertident_new_alertident(idmef_alertident_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_alertident_get_analyzerid(idmef_alertident_t *ptr);
void idmef_alertident_set_analyzerid(idmef_alertident_t *ptr, prelude_string_t *analyzerid);
int idmef_alertident_new_analyzerid(idmef_alertident_t *ptr, prelude_string_t **ret);

typedef enum {
        IDMEF_IMPACT_SEVERITY_ERROR = -1,
        IDMEF_IMPACT_SEVERITY_INFO = 1,
        IDMEF_IMPACT_SEVERITY_LOW = 2,
        IDMEF_IMPACT_SEVERITY_MEDIUM = 3,
        IDMEF_IMPACT_SEVERITY_HIGH = 4
} idmef_impact_severity_t;


idmef_impact_severity_t idmef_impact_severity_to_numeric(const char *name);
const char *idmef_impact_severity_to_string(idmef_impact_severity_t val);


typedef enum {
        IDMEF_IMPACT_COMPLETION_ERROR = -1,
        IDMEF_IMPACT_COMPLETION_FAILED = 1,
        IDMEF_IMPACT_COMPLETION_SUCCEEDED = 2
} idmef_impact_completion_t;


idmef_impact_completion_t idmef_impact_completion_to_numeric(const char *name);
const char *idmef_impact_completion_to_string(idmef_impact_completion_t val);


typedef enum {
        IDMEF_IMPACT_TYPE_ERROR = -1,
        IDMEF_IMPACT_TYPE_OTHER = 0,
        IDMEF_IMPACT_TYPE_ADMIN = 1,
        IDMEF_IMPACT_TYPE_DOS = 2,
        IDMEF_IMPACT_TYPE_FILE = 3,
        IDMEF_IMPACT_TYPE_RECON = 4,
        IDMEF_IMPACT_TYPE_USER = 5
} idmef_impact_type_t;


idmef_impact_type_t idmef_impact_type_to_numeric(const char *name);
const char *idmef_impact_type_to_string(idmef_impact_type_t val);




/*
 * struct {
 *         REFCOUNT;
 * 
 *         OPTIONAL_INT(idmef_impact_severity_t, severity);
 *         OPTIONAL_INT(idmef_impact_completion_t, completion);
 *         idmef_impact_type_t type;
 *         prelude_string_t *description;
 * } TYPE_ID(idmef_impact_t, 36);
 */


typedef struct idmef_impact idmef_impact_t;

int idmef_impact_new(idmef_impact_t **ret);
int idmef_impact_copy(const idmef_impact_t *src, idmef_impact_t *dst);
int idmef_impact_clone(idmef_impact_t *src, idmef_impact_t **dst);
int idmef_impact_compare(const idmef_impact_t *obj1, const idmef_impact_t *obj2);
idmef_impact_t *idmef_impact_ref(idmef_impact_t *ptr);

#ifndef SWIG
int _idmef_impact_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_impact_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_impact_destroy(idmef_impact_t *ptr);
void idmef_impact_unset_severity(idmef_impact_t *ptr);
idmef_impact_severity_t *idmef_impact_get_severity(idmef_impact_t *ptr);
void idmef_impact_set_severity(idmef_impact_t *ptr, idmef_impact_severity_t severity);
int idmef_impact_new_severity(idmef_impact_t *ptr, idmef_impact_severity_t **ret);

void idmef_impact_unset_completion(idmef_impact_t *ptr);
idmef_impact_completion_t *idmef_impact_get_completion(idmef_impact_t *ptr);
void idmef_impact_set_completion(idmef_impact_t *ptr, idmef_impact_completion_t completion);
int idmef_impact_new_completion(idmef_impact_t *ptr, idmef_impact_completion_t **ret);

idmef_impact_type_t idmef_impact_get_type(idmef_impact_t *ptr);
void idmef_impact_set_type(idmef_impact_t *ptr, idmef_impact_type_t type);
int idmef_impact_new_type(idmef_impact_t *ptr, idmef_impact_type_t **ret);

prelude_string_t *idmef_impact_get_description(idmef_impact_t *ptr);
void idmef_impact_set_description(idmef_impact_t *ptr, prelude_string_t *description);
int idmef_impact_new_description(idmef_impact_t *ptr, prelude_string_t **ret);

typedef enum {
        IDMEF_ACTION_CATEGORY_ERROR = -1,
        IDMEF_ACTION_CATEGORY_OTHER = 0,
        IDMEF_ACTION_CATEGORY_BLOCK_INSTALLED = 1,
        IDMEF_ACTION_CATEGORY_NOTIFICATION_SENT = 2,
        IDMEF_ACTION_CATEGORY_TAKEN_OFFLINE = 3
} idmef_action_category_t;


idmef_action_category_t idmef_action_category_to_numeric(const char *name);
const char *idmef_action_category_to_string(idmef_action_category_t val);




/*
 * struct {
 *         IS_LISTED;
 *         REFCOUNT;
 * 
 *         idmef_action_category_t category;
 *         prelude_string_t *description;
 * } TYPE_ID(idmef_action_t, 38);
 */


typedef struct idmef_action idmef_action_t;

int idmef_action_new(idmef_action_t **ret);
int idmef_action_copy(const idmef_action_t *src, idmef_action_t *dst);
int idmef_action_clone(idmef_action_t *src, idmef_action_t **dst);
int idmef_action_compare(const idmef_action_t *obj1, const idmef_action_t *obj2);
idmef_action_t *idmef_action_ref(idmef_action_t *ptr);

#ifndef SWIG
int _idmef_action_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_action_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_action_destroy(idmef_action_t *ptr);
idmef_action_category_t idmef_action_get_category(idmef_action_t *ptr);
void idmef_action_set_category(idmef_action_t *ptr, idmef_action_category_t category);
int idmef_action_new_category(idmef_action_t *ptr, idmef_action_category_t **ret);

prelude_string_t *idmef_action_get_description(idmef_action_t *ptr);
void idmef_action_set_description(idmef_action_t *ptr, prelude_string_t *description);
int idmef_action_new_description(idmef_action_t *ptr, prelude_string_t **ret);

typedef enum {
        IDMEF_CONFIDENCE_RATING_ERROR = -1,
        IDMEF_CONFIDENCE_RATING_NUMERIC = 0,
        IDMEF_CONFIDENCE_RATING_LOW = 1,
        IDMEF_CONFIDENCE_RATING_MEDIUM = 2,
        IDMEF_CONFIDENCE_RATING_HIGH = 3
} idmef_confidence_rating_t;


idmef_confidence_rating_t idmef_confidence_rating_to_numeric(const char *name);
const char *idmef_confidence_rating_to_string(idmef_confidence_rating_t val);




/*
 * struct {
 *         REFCOUNT;
 * 
 *         idmef_confidence_rating_t rating;
 *         float confidence;
 * } TYPE_ID(idmef_confidence_t, 40);
 */


typedef struct idmef_confidence idmef_confidence_t;

int idmef_confidence_new(idmef_confidence_t **ret);
int idmef_confidence_copy(const idmef_confidence_t *src, idmef_confidence_t *dst);
int idmef_confidence_clone(idmef_confidence_t *src, idmef_confidence_t **dst);
int idmef_confidence_compare(const idmef_confidence_t *obj1, const idmef_confidence_t *obj2);
idmef_confidence_t *idmef_confidence_ref(idmef_confidence_t *ptr);

#ifndef SWIG
int _idmef_confidence_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_confidence_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_confidence_destroy(idmef_confidence_t *ptr);
idmef_confidence_rating_t idmef_confidence_get_rating(idmef_confidence_t *ptr);
void idmef_confidence_set_rating(idmef_confidence_t *ptr, idmef_confidence_rating_t rating);
int idmef_confidence_new_rating(idmef_confidence_t *ptr, idmef_confidence_rating_t **ret);

float idmef_confidence_get_confidence(idmef_confidence_t *ptr);
void idmef_confidence_set_confidence(idmef_confidence_t *ptr, float confidence);
int idmef_confidence_new_confidence(idmef_confidence_t *ptr, float **ret);



/*
 * struct {
 *         REFCOUNT;
 * 
 *         idmef_impact_t *impact;
 *         LISTED_OBJECT(action_list, idmef_action_t);
 *         idmef_confidence_t *confidence;
 * } TYPE_ID(idmef_assessment_t, 41);
 */


typedef struct idmef_assessment idmef_assessment_t;

int idmef_assessment_new(idmef_assessment_t **ret);
int idmef_assessment_copy(const idmef_assessment_t *src, idmef_assessment_t *dst);
int idmef_assessment_clone(idmef_assessment_t *src, idmef_assessment_t **dst);
int idmef_assessment_compare(const idmef_assessment_t *obj1, const idmef_assessment_t *obj2);
idmef_assessment_t *idmef_assessment_ref(idmef_assessment_t *ptr);

#ifndef SWIG
int _idmef_assessment_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_assessment_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_assessment_destroy(idmef_assessment_t *ptr);
idmef_impact_t *idmef_assessment_get_impact(idmef_assessment_t *ptr);
void idmef_assessment_set_impact(idmef_assessment_t *ptr, idmef_impact_t *impact);
int idmef_assessment_new_impact(idmef_assessment_t *ptr, idmef_impact_t **ret);

idmef_action_t *idmef_assessment_get_next_action(idmef_assessment_t *ptr, idmef_action_t *object);
void idmef_assessment_set_action(idmef_assessment_t *ptr, idmef_action_t *object, int pos);
int idmef_assessment_new_action(idmef_assessment_t *ptr, idmef_action_t **ret, int pos);

idmef_confidence_t *idmef_assessment_get_confidence(idmef_assessment_t *ptr);
void idmef_assessment_set_confidence(idmef_assessment_t *ptr, idmef_confidence_t *confidence);
int idmef_assessment_new_confidence(idmef_assessment_t *ptr, idmef_confidence_t **ret);



/*
 * struct {
 *         REFCOUNT;
 * 
 *         prelude_string_t name;
 *         prelude_string_t *command;
 *         LISTED_OBJECT(alertident_list, idmef_alertident_t);
 * } TYPE_ID(idmef_tool_alert_t, 42);
 */


typedef struct idmef_tool_alert idmef_tool_alert_t;

int idmef_tool_alert_new(idmef_tool_alert_t **ret);
int idmef_tool_alert_copy(const idmef_tool_alert_t *src, idmef_tool_alert_t *dst);
int idmef_tool_alert_clone(idmef_tool_alert_t *src, idmef_tool_alert_t **dst);
int idmef_tool_alert_compare(const idmef_tool_alert_t *obj1, const idmef_tool_alert_t *obj2);
idmef_tool_alert_t *idmef_tool_alert_ref(idmef_tool_alert_t *ptr);

#ifndef SWIG
int _idmef_tool_alert_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_tool_alert_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_tool_alert_destroy(idmef_tool_alert_t *ptr);
prelude_string_t *idmef_tool_alert_get_name(idmef_tool_alert_t *ptr);
void idmef_tool_alert_set_name(idmef_tool_alert_t *ptr, prelude_string_t *name);
int idmef_tool_alert_new_name(idmef_tool_alert_t *ptr, prelude_string_t **ret);

prelude_string_t *idmef_tool_alert_get_command(idmef_tool_alert_t *ptr);
void idmef_tool_alert_set_command(idmef_tool_alert_t *ptr, prelude_string_t *command);
int idmef_tool_alert_new_command(idmef_tool_alert_t *ptr, prelude_string_t **ret);

idmef_alertident_t *idmef_tool_alert_get_next_alertident(idmef_tool_alert_t *ptr, idmef_alertident_t *object);
void idmef_tool_alert_set_alertident(idmef_tool_alert_t *ptr, idmef_alertident_t *object, int pos);
int idmef_tool_alert_new_alertident(idmef_tool_alert_t *ptr, idmef_alertident_t **ret, int pos);



/*
 * struct {
 *         REFCOUNT;
 * 
 *         prelude_string_t name;
 *         LISTED_OBJECT(alertident_list, idmef_alertident_t);
 * } TYPE_ID(idmef_correlation_alert_t, 43);
 */


typedef struct idmef_correlation_alert idmef_correlation_alert_t;

int idmef_correlation_alert_new(idmef_correlation_alert_t **ret);
int idmef_correlation_alert_copy(const idmef_correlation_alert_t *src, idmef_correlation_alert_t *dst);
int idmef_correlation_alert_clone(idmef_correlation_alert_t *src, idmef_correlation_alert_t **dst);
int idmef_correlation_alert_compare(const idmef_correlation_alert_t *obj1, const idmef_correlation_alert_t *obj2);
idmef_correlation_alert_t *idmef_correlation_alert_ref(idmef_correlation_alert_t *ptr);

#ifndef SWIG
int _idmef_correlation_alert_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_correlation_alert_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_correlation_alert_destroy(idmef_correlation_alert_t *ptr);
prelude_string_t *idmef_correlation_alert_get_name(idmef_correlation_alert_t *ptr);
void idmef_correlation_alert_set_name(idmef_correlation_alert_t *ptr, prelude_string_t *name);
int idmef_correlation_alert_new_name(idmef_correlation_alert_t *ptr, prelude_string_t **ret);

idmef_alertident_t *idmef_correlation_alert_get_next_alertident(idmef_correlation_alert_t *ptr, idmef_alertident_t *object);
void idmef_correlation_alert_set_alertident(idmef_correlation_alert_t *ptr, idmef_alertident_t *object, int pos);
int idmef_correlation_alert_new_alertident(idmef_correlation_alert_t *ptr, idmef_alertident_t **ret, int pos);



/*
 * struct {
 *         REFCOUNT;
 * 
 *         prelude_string_t program;
 *         OPTIONAL_INT(uint32_t, size);
 *         idmef_data_t *buffer;
 * } TYPE_ID(idmef_overflow_alert_t, 44);
 */


typedef struct idmef_overflow_alert idmef_overflow_alert_t;

int idmef_overflow_alert_new(idmef_overflow_alert_t **ret);
int idmef_overflow_alert_copy(const idmef_overflow_alert_t *src, idmef_overflow_alert_t *dst);
int idmef_overflow_alert_clone(idmef_overflow_alert_t *src, idmef_overflow_alert_t **dst);
int idmef_overflow_alert_compare(const idmef_overflow_alert_t *obj1, const idmef_overflow_alert_t *obj2);
idmef_overflow_alert_t *idmef_overflow_alert_ref(idmef_overflow_alert_t *ptr);

#ifndef SWIG
int _idmef_overflow_alert_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_overflow_alert_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_overflow_alert_destroy(idmef_overflow_alert_t *ptr);
prelude_string_t *idmef_overflow_alert_get_program(idmef_overflow_alert_t *ptr);
void idmef_overflow_alert_set_program(idmef_overflow_alert_t *ptr, prelude_string_t *program);
int idmef_overflow_alert_new_program(idmef_overflow_alert_t *ptr, prelude_string_t **ret);

void idmef_overflow_alert_unset_size(idmef_overflow_alert_t *ptr);
uint32_t *idmef_overflow_alert_get_size(idmef_overflow_alert_t *ptr);
void idmef_overflow_alert_set_size(idmef_overflow_alert_t *ptr, uint32_t size);
int idmef_overflow_alert_new_size(idmef_overflow_alert_t *ptr, uint32_t **ret);

idmef_data_t *idmef_overflow_alert_get_buffer(idmef_overflow_alert_t *ptr);
void idmef_overflow_alert_set_buffer(idmef_overflow_alert_t *ptr, idmef_data_t *buffer);
int idmef_overflow_alert_new_buffer(idmef_overflow_alert_t *ptr, idmef_data_t **ret);

typedef enum {
        IDMEF_ALERT_TYPE_ERROR = -1,
        IDMEF_ALERT_TYPE_DEFAULT = 0,
        IDMEF_ALERT_TYPE_TOOL = 1,
        IDMEF_ALERT_TYPE_CORRELATION = 2,
        IDMEF_ALERT_TYPE_OVERFLOW = 3
} idmef_alert_type_t;


idmef_alert_type_t idmef_alert_type_to_numeric(const char *name);
const char *idmef_alert_type_to_string(idmef_alert_type_t val);




/*
 * struct {
 *         REFCOUNT;
 *         prelude_string_t *messageid;
 * 
 *         LISTED_OBJECT(analyzer_list, idmef_analyzer_t);
 * 
 *         idmef_time_t create_time;
 *         idmef_classification_t *classification;
 *         idmef_time_t *detect_time;
 *         idmef_time_t *analyzer_time;
 * 
 *         LISTED_OBJECT(source_list, idmef_source_t);
 *         LISTED_OBJECT(target_list, idmef_target_t);
 * 
 *         idmef_assessment_t *assessment;
 * 
 *         LISTED_OBJECT(additional_data_list, idmef_additional_data_t);
 * 
 *         UNION(idmef_alert_type_t, type) {
 *                 UNION_MEMBER(IDMEF_ALERT_TYPE_TOOL, idmef_tool_alert_t, *tool_alert);
 *                 UNION_MEMBER(IDMEF_ALERT_TYPE_CORRELATION, idmef_correlation_alert_t, *correlation_alert);
 *                 UNION_MEMBER(IDMEF_ALERT_TYPE_OVERFLOW, idmef_overflow_alert_t, *overflow_alert);
 *         } detail;
 * 
 * } TYPE_ID(idmef_alert_t, 46);
 */


typedef struct idmef_alert idmef_alert_t;

int idmef_alert_new(idmef_alert_t **ret);
int idmef_alert_copy(const idmef_alert_t *src, idmef_alert_t *dst);
int idmef_alert_clone(idmef_alert_t *src, idmef_alert_t **dst);
int idmef_alert_compare(const idmef_alert_t *obj1, const idmef_alert_t *obj2);
idmef_alert_t *idmef_alert_ref(idmef_alert_t *ptr);

#ifndef SWIG
int _idmef_alert_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_alert_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_alert_destroy(idmef_alert_t *ptr);
prelude_string_t *idmef_alert_get_messageid(idmef_alert_t *ptr);
void idmef_alert_set_messageid(idmef_alert_t *ptr, prelude_string_t *messageid);
int idmef_alert_new_messageid(idmef_alert_t *ptr, prelude_string_t **ret);

idmef_analyzer_t *idmef_alert_get_next_analyzer(idmef_alert_t *ptr, idmef_analyzer_t *object);
void idmef_alert_set_analyzer(idmef_alert_t *ptr, idmef_analyzer_t *object, int pos);
int idmef_alert_new_analyzer(idmef_alert_t *ptr, idmef_analyzer_t **ret, int pos);

idmef_time_t *idmef_alert_get_create_time(idmef_alert_t *ptr);
void idmef_alert_set_create_time(idmef_alert_t *ptr, idmef_time_t *create_time);
int idmef_alert_new_create_time(idmef_alert_t *ptr, idmef_time_t **ret);

idmef_classification_t *idmef_alert_get_classification(idmef_alert_t *ptr);
void idmef_alert_set_classification(idmef_alert_t *ptr, idmef_classification_t *classification);
int idmef_alert_new_classification(idmef_alert_t *ptr, idmef_classification_t **ret);

idmef_time_t *idmef_alert_get_detect_time(idmef_alert_t *ptr);
void idmef_alert_set_detect_time(idmef_alert_t *ptr, idmef_time_t *detect_time);
int idmef_alert_new_detect_time(idmef_alert_t *ptr, idmef_time_t **ret);

idmef_time_t *idmef_alert_get_analyzer_time(idmef_alert_t *ptr);
void idmef_alert_set_analyzer_time(idmef_alert_t *ptr, idmef_time_t *analyzer_time);
int idmef_alert_new_analyzer_time(idmef_alert_t *ptr, idmef_time_t **ret);

idmef_source_t *idmef_alert_get_next_source(idmef_alert_t *ptr, idmef_source_t *object);
void idmef_alert_set_source(idmef_alert_t *ptr, idmef_source_t *object, int pos);
int idmef_alert_new_source(idmef_alert_t *ptr, idmef_source_t **ret, int pos);

idmef_target_t *idmef_alert_get_next_target(idmef_alert_t *ptr, idmef_target_t *object);
void idmef_alert_set_target(idmef_alert_t *ptr, idmef_target_t *object, int pos);
int idmef_alert_new_target(idmef_alert_t *ptr, idmef_target_t **ret, int pos);

idmef_assessment_t *idmef_alert_get_assessment(idmef_alert_t *ptr);
void idmef_alert_set_assessment(idmef_alert_t *ptr, idmef_assessment_t *assessment);
int idmef_alert_new_assessment(idmef_alert_t *ptr, idmef_assessment_t **ret);

idmef_additional_data_t *idmef_alert_get_next_additional_data(idmef_alert_t *ptr, idmef_additional_data_t *object);
void idmef_alert_set_additional_data(idmef_alert_t *ptr, idmef_additional_data_t *object, int pos);
int idmef_alert_new_additional_data(idmef_alert_t *ptr, idmef_additional_data_t **ret, int pos);

idmef_alert_type_t idmef_alert_get_type(idmef_alert_t *ptr);
idmef_tool_alert_t *idmef_alert_get_tool_alert(idmef_alert_t *ptr);
void idmef_alert_set_tool_alert(idmef_alert_t *ptr, idmef_tool_alert_t *tool_alert);
int idmef_alert_new_tool_alert(idmef_alert_t *ptr, idmef_tool_alert_t **ret);

idmef_correlation_alert_t *idmef_alert_get_correlation_alert(idmef_alert_t *ptr);
void idmef_alert_set_correlation_alert(idmef_alert_t *ptr, idmef_correlation_alert_t *correlation_alert);
int idmef_alert_new_correlation_alert(idmef_alert_t *ptr, idmef_correlation_alert_t **ret);

idmef_overflow_alert_t *idmef_alert_get_overflow_alert(idmef_alert_t *ptr);
void idmef_alert_set_overflow_alert(idmef_alert_t *ptr, idmef_overflow_alert_t *overflow_alert);
int idmef_alert_new_overflow_alert(idmef_alert_t *ptr, idmef_overflow_alert_t **ret);



/*
 * struct {
 *         REFCOUNT;
 * 
 *         prelude_string_t *messageid;
 *         LISTED_OBJECT(analyzer_list, idmef_analyzer_t);
 * 
 *         idmef_time_t create_time;
 *         idmef_time_t *analyzer_time;
 * 
 *         OPTIONAL_INT(uint32_t, heartbeat_interval);
 *         LISTED_OBJECT(additional_data_list, idmef_additional_data_t);
 * } TYPE_ID(idmef_heartbeat_t, 47);
 */


typedef struct idmef_heartbeat idmef_heartbeat_t;

int idmef_heartbeat_new(idmef_heartbeat_t **ret);
int idmef_heartbeat_copy(const idmef_heartbeat_t *src, idmef_heartbeat_t *dst);
int idmef_heartbeat_clone(idmef_heartbeat_t *src, idmef_heartbeat_t **dst);
int idmef_heartbeat_compare(const idmef_heartbeat_t *obj1, const idmef_heartbeat_t *obj2);
idmef_heartbeat_t *idmef_heartbeat_ref(idmef_heartbeat_t *ptr);

#ifndef SWIG
int _idmef_heartbeat_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_heartbeat_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_heartbeat_destroy(idmef_heartbeat_t *ptr);
prelude_string_t *idmef_heartbeat_get_messageid(idmef_heartbeat_t *ptr);
void idmef_heartbeat_set_messageid(idmef_heartbeat_t *ptr, prelude_string_t *messageid);
int idmef_heartbeat_new_messageid(idmef_heartbeat_t *ptr, prelude_string_t **ret);

idmef_analyzer_t *idmef_heartbeat_get_next_analyzer(idmef_heartbeat_t *ptr, idmef_analyzer_t *object);
void idmef_heartbeat_set_analyzer(idmef_heartbeat_t *ptr, idmef_analyzer_t *object, int pos);
int idmef_heartbeat_new_analyzer(idmef_heartbeat_t *ptr, idmef_analyzer_t **ret, int pos);

idmef_time_t *idmef_heartbeat_get_create_time(idmef_heartbeat_t *ptr);
void idmef_heartbeat_set_create_time(idmef_heartbeat_t *ptr, idmef_time_t *create_time);
int idmef_heartbeat_new_create_time(idmef_heartbeat_t *ptr, idmef_time_t **ret);

idmef_time_t *idmef_heartbeat_get_analyzer_time(idmef_heartbeat_t *ptr);
void idmef_heartbeat_set_analyzer_time(idmef_heartbeat_t *ptr, idmef_time_t *analyzer_time);
int idmef_heartbeat_new_analyzer_time(idmef_heartbeat_t *ptr, idmef_time_t **ret);

void idmef_heartbeat_unset_heartbeat_interval(idmef_heartbeat_t *ptr);
uint32_t *idmef_heartbeat_get_heartbeat_interval(idmef_heartbeat_t *ptr);
void idmef_heartbeat_set_heartbeat_interval(idmef_heartbeat_t *ptr, uint32_t heartbeat_interval);
int idmef_heartbeat_new_heartbeat_interval(idmef_heartbeat_t *ptr, uint32_t **ret);

idmef_additional_data_t *idmef_heartbeat_get_next_additional_data(idmef_heartbeat_t *ptr, idmef_additional_data_t *object);
void idmef_heartbeat_set_additional_data(idmef_heartbeat_t *ptr, idmef_additional_data_t *object, int pos);
int idmef_heartbeat_new_additional_data(idmef_heartbeat_t *ptr, idmef_additional_data_t **ret, int pos);

typedef enum {
        IDMEF_MESSAGE_TYPE_ERROR = -1,
        IDMEF_MESSAGE_TYPE_ALERT = 1,
        IDMEF_MESSAGE_TYPE_HEARTBEAT = 2
} idmef_message_type_t;


idmef_message_type_t idmef_message_type_to_numeric(const char *name);
const char *idmef_message_type_to_string(idmef_message_type_t val);




/*
 * struct {
 *         REFCOUNT;
 * 
 *         prelude_string_t version;
 * 
 *         UNION(idmef_message_type_t, type) {
 *                 UNION_MEMBER(IDMEF_MESSAGE_TYPE_ALERT, idmef_alert_t, *alert);
 *                 UNION_MEMBER(IDMEF_MESSAGE_TYPE_HEARTBEAT, idmef_heartbeat_t, *heartbeat);
 *         } message;
 * 
 *         HIDE(prelude_msg_t *, pmsg);
 * 
 * } TYPE_ID(idmef_message_t, 49);
 */


typedef struct idmef_message idmef_message_t;

int idmef_message_new(idmef_message_t **ret);
int idmef_message_copy(const idmef_message_t *src, idmef_message_t *dst);
int idmef_message_clone(idmef_message_t *src, idmef_message_t **dst);
int idmef_message_compare(const idmef_message_t *obj1, const idmef_message_t *obj2);
idmef_message_t *idmef_message_ref(idmef_message_t *ptr);

#ifndef SWIG
int _idmef_message_get_child(void *p, idmef_class_child_id_t child, void **childptr);
int _idmef_message_new_child(void *p, idmef_class_child_id_t child, int n, void **ret);
#endif

void idmef_message_destroy(idmef_message_t *ptr);
prelude_string_t *idmef_message_get_version(idmef_message_t *ptr);
void idmef_message_set_version(idmef_message_t *ptr, prelude_string_t *version);
int idmef_message_new_version(idmef_message_t *ptr, prelude_string_t **ret);

idmef_message_type_t idmef_message_get_type(idmef_message_t *ptr);
idmef_alert_t *idmef_message_get_alert(idmef_message_t *ptr);
void idmef_message_set_alert(idmef_message_t *ptr, idmef_alert_t *alert);
int idmef_message_new_alert(idmef_message_t *ptr, idmef_alert_t **ret);

idmef_heartbeat_t *idmef_message_get_heartbeat(idmef_message_t *ptr);
void idmef_message_set_heartbeat(idmef_message_t *ptr, idmef_heartbeat_t *heartbeat);
int idmef_message_new_heartbeat(idmef_message_t *ptr, idmef_heartbeat_t **ret);


void idmef_message_set_pmsg(idmef_message_t *message, prelude_msg_t *msg);

prelude_msg_t *idmef_message_get_pmsg(idmef_message_t *message);

#ifdef __cplusplus
  }
#endif
#define IDMEF_CLASS_ID_ADDITIONAL_DATA_TYPE 3
#define IDMEF_CLASS_ID_ADDITIONAL_DATA 4
#define IDMEF_CLASS_ID_REFERENCE_ORIGIN 5
#define IDMEF_CLASS_ID_REFERENCE 50
#define IDMEF_CLASS_ID_CLASSIFICATION 6
#define IDMEF_CLASS_ID_USER_ID_TYPE 7
#define IDMEF_CLASS_ID_USER_ID 8
#define IDMEF_CLASS_ID_USER_CATEGORY 9
#define IDMEF_CLASS_ID_USER 10
#define IDMEF_CLASS_ID_ADDRESS_CATEGORY 11
#define IDMEF_CLASS_ID_ADDRESS 12
#define IDMEF_CLASS_ID_PROCESS 13
#define IDMEF_CLASS_ID_WEB_SERVICE 14
#define IDMEF_CLASS_ID_SNMP_SERVICE 15
#define IDMEF_CLASS_ID_SERVICE_TYPE 16
#define IDMEF_CLASS_ID_SERVICE 17
#define IDMEF_CLASS_ID_NODE_CATEGORY 18
#define IDMEF_CLASS_ID_NODE 19
#define IDMEF_CLASS_ID_SOURCE_SPOOFED 20
#define IDMEF_CLASS_ID_SOURCE 21
#define IDMEF_CLASS_ID_FILE_ACCESS 22
#define IDMEF_CLASS_ID_INODE 23
#define IDMEF_CLASS_ID_CHECKSUM_ALGORITHM 53
#define IDMEF_CLASS_ID_CHECKSUM 52
#define IDMEF_CLASS_ID_FILE_CATEGORY 24
#define IDMEF_CLASS_ID_FILE_FSTYPE 25
#define IDMEF_CLASS_ID_FILE 26
#define IDMEF_CLASS_ID_LINKAGE_CATEGORY 27
#define IDMEF_CLASS_ID_LINKAGE 28
#define IDMEF_CLASS_ID_TARGET_DECOY 29
#define IDMEF_CLASS_ID_TARGET 30
#define IDMEF_CLASS_ID_ANALYZER 31
#define IDMEF_CLASS_ID_ALERTIDENT 32
#define IDMEF_CLASS_ID_IMPACT_SEVERITY 33
#define IDMEF_CLASS_ID_IMPACT_COMPLETION 34
#define IDMEF_CLASS_ID_IMPACT_TYPE 35
#define IDMEF_CLASS_ID_IMPACT 36
#define IDMEF_CLASS_ID_ACTION_CATEGORY 37
#define IDMEF_CLASS_ID_ACTION 38
#define IDMEF_CLASS_ID_CONFIDENCE_RATING 39
#define IDMEF_CLASS_ID_CONFIDENCE 40
#define IDMEF_CLASS_ID_ASSESSMENT 41
#define IDMEF_CLASS_ID_TOOL_ALERT 42
#define IDMEF_CLASS_ID_CORRELATION_ALERT 43
#define IDMEF_CLASS_ID_OVERFLOW_ALERT 44
#define IDMEF_CLASS_ID_ALERT_TYPE 45
#define IDMEF_CLASS_ID_ALERT 46
#define IDMEF_CLASS_ID_HEARTBEAT 47
#define IDMEF_CLASS_ID_MESSAGE_TYPE 48
#define IDMEF_CLASS_ID_MESSAGE 49

#endif /* _LIBPRELUDE_IDMEF_TREE_WRAP */
