/*

Copyright (C) 2000 - 2006 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd.h>
#include <libnd_arp.h>


static LND_Protocol *arp;

static gboolean
arp_header_complete(const LND_Packet *packet, guchar *data)
{
  struct arphdr *arphdr;

  if (!data)
    return FALSE;

  arphdr = (struct arphdr *) data;
  return (data + 8 <= libnd_packet_get_end(packet));
}


/* Plugin hook implementations: ---------------------------------------- */

const char *
name(void)
{
  return ("ARP Plugin");
}


const char *
description(void)
{
  return ("A plugin providing support for the ARP protocol.\n");
}


const char *
author(void)
{
  return ("Christian Kreibich, <christian@whoop.org>");
}


const char *
version(void)
{
  return VERSION;
}


LND_Protocol *
init(void)
{
  arp = libnd_proto_new("ARP", LND_PROTO_LAYER_NET, ETHERTYPE_ARP);

  /* For this protocol it makes sense to register multiple magics,
     since RARP and ARP are basically the same thing but have
     different magics: */

  libnd_proto_add_magic(arp, ETHERTYPE_REVARP);
			     		
  arp->init_packet     = libnd_arp_init_packet;
  arp->header_complete = libnd_arp_header_complete;

  return arp;
}


/* Protocol method implementations: ------------------------------------ */

guchar *
libnd_arp_init_packet(LND_Packet *packet, guchar *data, guchar *data_end)
{
  struct arphdr *arphdr;

  D_ENTER;

  arphdr = (struct arphdr *) data;

  if (!arp_header_complete(packet, data))
    {
      libnd_raw_proto_get()->init_packet(packet, data, data_end);
      D_RETURN_(data_end);
    }

  libnd_packet_add_proto_data(packet, arp, data, data_end);  
  
  /* ARP is at the end of the road, no need to multiplex anything
   * after we've come here. We should double-check though, this
   * is a FIXME.
   */
  D_RETURN_(data_end);
}


gboolean
libnd_arp_header_complete(const LND_Packet *packet, guint nesting)
{
  guchar      *data;

  if (!packet)
    return FALSE;

  data = libnd_packet_get_data(packet, arp, 0);

  return arp_header_complete(packet, data);
  TOUCH(nesting);
}


LND_Protocol *
libnd_arp_get(void)
{
  return arp;
}

