/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd.h>
#include <nd_gettext.h>

/* This is the basic Netdude plugin skeleton.
   Fill in as necessary. You don't need to fill
   in everything, the default functions simply
   do nothing. The return values are currently
   not used, except for nam() of course.

   You can always find out where plugins are
   installed by typing "netdude --plugin-dir".
*/


/* Return the name of the plugin, to be displayed
   in the Plugins menu.
*/
const char *
name(void)
{
  return _("Dummy Plugin");
}


/* A description of the plugin and what it does. */
const char *
description(void)
{
  return _("A Dummy plugin. Does .. uhm .. nothing :) "
	   "It's intended as a source code template only.");
}


const char *
author(void)
{
  return _("Christian Kreibich, <christian@whoop.org>");
}

const char *
version(void)
{
  return _("0.1.0");
}


/* Here's where the action is -- run() is
 * called to launch the plugin.
 * 
 * You can return an exit code. It's currently
 * ignored, so simply return 0.
 */
int
run(ND_Trace *trace)
{
  return 0;
}
