#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Upload cgi";
 name["francais"] = "cgi upload";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'upload.cgi' cgi is installed. This CGI has
a well known security flaw that lets anyone upload arbitrary
files on the remote web server, such as programs, that may
be executed by another mean.

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'upload.cgi' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe d'uploader
des fichiers arbitraires sur le serveur web, tels que des programmes,
qui seront ensuite executs par d'autres moyens.

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/upload.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/upload.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("upload.cgi"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_hole(port);
}
