#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_name(english:"Ftp PASV denial of service",
 	     francais:"Dni de service via la commande ftp PASV");
 
 script_description(english:"Some FTP servers allow users to make any amount
of PASV commands, thus blocking the free ports for legitimate services.

Solution: upgrade your FTP server to a version which solves this problem.

Risk factor : Medium",

	francais:"Certains serveurs FTP laissent les utilisateurs entrer
un nombre non-fini de commandes PASV, ce qui bloque les ports libres pour 
les services lgitimes.

Solution : changez votre serveur FTP pour une version qui rsoud ce probleme.

Facteur de risque : Moyen");

 script_summary(english:"Determines if a PASV DoS is feasible",
 francais:"Determine si un dni de service via la commande PASV est faisable");
 
 script_category(ACT_ATTACK);

 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
 		  francais: "Ce script est Copyright (C) 1999 Renaud Deraison");
 
 script_family(english:"FTP");
 script_dependencie("find_service.nes", "ftp_anonymous.nasl");
 
 exit(0);
}

#
# The script code starts here :
#

port = get_kb_item("Services/ftp");
if(!port)port = 21;
anon = get_kb_item("ftp/anonymous");
if(!anon)exit(0);
soc = open_sock_tcp(port);
if(soc)
{
if(ftp_log_in(socket:soc, user:"ftp", pass:"nessus@"))
{
 port1 = ftp_get_pasv_port(socket:soc);
 for(i=0;i<40;i=i+1)port2 = ftp_get_pasv_port(socket:soc);
 if(port1 == port2){
	close(soc);
	exit(0);
	}
 if(port2){
	soc1 = open_sock_tcp(port1);
 	if(soc1>0){
		security_hole(port);
		close(soc1);
		}
	}
} 
close(soc);
}
