#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Finger cgi";
 name["francais"] = "Finger cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'finger' cgi is installed. It is usually
not a good idea to have such a service installed, since
it usually gives more troubles than anything else. 

Double check that you really want to have this
service installed.

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'finger' est install. Ce n'est
gnrallement pas une bonne ide d'avoir un service
'finger' en accs libre, car cela cause plus de
problmes qu'autre chose.

Vrifiez donc que vous voulez rellement avoir
ce service install.

Solution : enlevez le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/finger";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/finger";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("finger"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_warning(port);
}
