#include <FL/Fl_StatusPanel.H>
#include <stdio.h>


FL_API Fl_StatusPanel::Fl_StatusPanel(int nx, int ny, int nw, int nh, const char *lbl)
	: Fl_Group(nx, ny, nw, nh, lbl)
{
	int bdx, bdy, bdh, bdw;
	box(FL_ENGRAVED_BOX);
	
#if (FL_MAJOR_VERSION > 1)
	bdx = box()->dx();
	bdy = box()->dy();
	bdw = box()->dw();
	bdh = box()->dh();
#else
	bdx = Fl::box_dx(box());
	bdy = Fl::box_dy(box());
	bdw = Fl::box_dw(box());
	bdh = Fl::box_dh(box());
#endif
	int ttop = ny + bdy;
	int theight = (nh - bdh);
	nx += bdx;
	nw -= bdx;
	

	StatusMsg = new Fl_Tile(nx, ttop, nw - (3*33), theight, "");
	StatusMsg->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	StatusMsg->label_size(12);
	StatusMsg->clear_flag(FL_ALIGN_MASK);
	StatusMsg->set_flag(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	int smbdx = StatusMsg->box()->dx();
	int smbdy = StatusMsg->box()->dy();
	int smbdh = StatusMsg->box()->dh();
#else
	StatusMsg->labelsize(12);
	StatusMsg->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	int smbdx = Fl::box_dx(StatusMsg->box());
	int smbdy = Fl::box_dy(StatusMsg->box());
	int smbdh = Fl::box_dh(StatusMsg->box());
#endif

	this->resizable(StatusMsg);

	INSlight = new Fl_Tile((nx+nw) - (3*33), ttop, 33, theight, "INS");
	INSlight->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	INSlight->label_size(12);
	INSlight->clear_flag(FL_ALIGN_MASK);
	INSlight->set_flag(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#else
	INSlight->labelsize(12);
	INSlight->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#endif
	INSlight->end();

	CAPlight = new Fl_Tile((nx+nw) - (2*33), ttop, 33, theight, "");	// caps lock
	CAPlight->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	CAPlight->label_size(12);
	CAPlight->clear_flag(FL_ALIGN_MASK);
	CAPlight->set_flag(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#else
	CAPlight->labelsize(12);
	CAPlight->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#endif
	CAPlight->end();

	NUMlight = new Fl_Tile((nx+nw) - 33, ttop, 33, theight, "");	// num lock
	NUMlight->box(FL_DOWN_BOX);
#if (FL_MAJOR_VERSION > 1)
	NUMlight->label_size(12);
	NUMlight->clear_flag(FL_ALIGN_MASK);
	NUMlight->set_flag(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#else
	NUMlight->labelsize(12);
	NUMlight->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
#endif
	NUMlight->end();

	
	PBar = new Fl_ProgressBox(StatusMsg->x() + smbdx, StatusMsg->y() + smbdy, StatusMsg->w() / 2, StatusMsg->h() - smbdh, "");
#if (FL_MAJOR_VERSION > 1)
	PBar->label_size(10);
#else
	PBar->labelsize(10);
#endif
	PBar->hide();
	
	StatusMsg->end();
	
	this->end();
}

FL_API Fl_StatusPanel::~Fl_StatusPanel()
{
	hide();
	// FLTK group will automatically delete its children...
	//return;
	if ( NUMlight )
	{
		this->remove(NUMlight);
		delete NUMlight;
	}
	if ( CAPlight )
	{
		this->remove(CAPlight);
		delete CAPlight;
	}
	if ( INSlight )
	{
		this->remove(INSlight);
		delete INSlight;
	}
	if ( StatusMsg )
	{
		this->remove(StatusMsg);
		if(PBar)
		{
			StatusMsg->remove(PBar);
			delete PBar;
		}
		delete StatusMsg;
	}
}

FL_API int Fl_StatusPanel::updatestatus()
{
	// update the keyboard status lights
	int changed = 1;
	int key = Fl::event_key(); 
	int state = Fl::event_state();
	switch ( key )
	{
		case FL_Caps_Lock:
			// if pressing the key, toggle the state for the check below...
			if(state & FL_CAPS_LOCK)
				state &= ~FL_CAPS_LOCK;
			else
				state |= FL_CAPS_LOCK;
			cap(state & FL_CAPS_LOCK);
			break;
		case FL_Num_Lock:
			if(state & FL_NUM_LOCK)
				state &= ~FL_NUM_LOCK;
			else
				state |= FL_NUM_LOCK;
			num(state & FL_NUM_LOCK);
			break;
		default:
			changed = 0;
			cap(state & FL_CAPS_LOCK);
			num(state & FL_NUM_LOCK);
//			CAPlight->label(( state  & FL_CAPS_LOCK ) ? "CAP" : "");
//			CAPlight->redraw();
//			NUMlight->label(( state & FL_NUM_LOCK ) ? "NUM" : "");
//			NUMlight->redraw();
			break;
	}
	return(changed);
}

FL_API int Fl_StatusPanel::handle(int event)
{
	return(updatestatus());
}

