/* $Id: input.c,v 1.13 1998/11/19 00:47:19 marcus Exp $
******************************************************************************

   Mouse inputlib init function

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "mouse.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#define SKIPWHITE(str)	while (isspace((int)*(str))) (str)++

static inline parser_type *match_mtype(char *mtype) {
	int i, j;

	SKIPWHITE(mtype);
	if (*mtype == ',') mtype++;
	SKIPWHITE(mtype);

	for (i = 0; _gii_mouse_parsers[i].parser != NULL; i++) {
		for (j = 0; _gii_mouse_parsers[i].names[j] != NULL; j++) {
			if (strcasecmp(mtype,
				       _gii_mouse_parsers[i].names[j]) == 0) {
				return &_gii_mouse_parsers[i];
			}
		}
	}
	return NULL;
}


int GIIdlinit(gii_input *inp, const char *args, void *argptr)
{
	int fd;
	char *mtype;
	parser_type *parser;
	mouse_priv *mpriv;
	
	if (! (args && *args
	       && (fd = strtol(args, &mtype, 0)) >= 0 && mtype != args
	       /* FIXME - we should allow PnP for the mousetype */
	       && *mtype != '\0')) {
		return GGI_EARGREQ;
	}
	
	if ((parser = match_mtype(mtype)) == NULL) {
		return GGI_EARGINVAL;
	}
	if (parser->init_data) {
		if (write(fd, parser->init_data, parser->init_len)
		    != parser->init_len) {
			return GGI_ENODEVICE;
		}
	}

	if ((mpriv = malloc(sizeof(mouse_priv))) == NULL) {
		return GGI_ENOMEM;
	}

	inp->GIIeventpoll = GII_mouse_poll;
	inp->GIIclose = NULL;

	inp->targetcan = emPointer;
	inp->curreventmask = emPointer;

	inp->maxfd = fd + 1;
	FD_SET(fd, &inp->fdset);

	mpriv->parser = parser->parser;
	mpriv->min_packet_len = parser->min_packet_len;
	mpriv->fd = fd;
	mpriv->eof = 0;

	mpriv->parse_state = mpriv->button_state = 0;
	mpriv->packet_len = 0;
	mpriv->sent = 0;

	inp->priv = mpriv;

	DPRINT_LIBS("mouse fully up\n");

	return 0;
}
