/* $Id: dlptlock.c,v 1.4 1998/12/15 03:04:20 marcus Exp $
******************************************************************************

   LibGG - Mutex implementation using pthreads. 
   Libpthreads is dlopen()ed to circumvent a libpthreads bug under Linux.

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <ggi/gg.h>
#include "plat.h"

#ifdef HAVE_PTHREAD_H
#define __C_ASM_H /* Fix for retarded Digital Unix header */
#include <pthread.h>
#endif

static int isup = 0;
static void *handle = NULL;

static int (*my_init)   (pthread_mutex_t   *mutex, const
			 pthread_mutexattr_t *mutexattr);
static int (*my_destroy)(pthread_mutex_t *mutex);
static int (*my_lock)   (pthread_mutex_t *mutex);
static int (*my_trylock)(pthread_mutex_t *mutex);
static int (*my_unlock) (pthread_mutex_t *mutex);

void  *ggLockCreate(void)
{
	pthread_mutex_t *ret;
	
	if ((ret = malloc(sizeof(pthread_mutex_t))) != NULL) {
		if (my_init(ret, NULL) != 0) {
			free((void *)ret);
			return (void *) NULL;
		}
	}
	return (void *) ret;
}

int ggLockDestroy(void *lock) {
	if (my_destroy((pthread_mutex_t*)lock) != 0) {
		return GGI_ELOCKBUSY;
	}
	free(lock);
	return 0;
}
	
int ggLock(void *lock) {
	if (my_lock((pthread_mutex_t*)lock) != 0) {
		return GGI_EUNKNOWN;
	}
	return 0;
}

int ggUnlock(void *lock) {
	if (my_unlock((pthread_mutex_t*)lock) != 0) {
		return GGI_EUNKNOWN;
	}
	return 0;
}


int ggTryLock(void *lock) {
	switch (my_trylock((pthread_mutex_t*)lock)) {
	case 0:	return 0;

	case EBUSY: return GGI_ELOCKBUSY;
	}
	return GGI_EUNKNOWN;
}

void _ggExitLocks(void)
{

/*	ARGH ! LibC seems to see the symbols from the dlopened pthreads and
	causes a segfault, when it is gone ... AAAAAHHH ! [becka] */
#if 0
	if (isup) dlclose(handle);
#endif
}

int _ggInitLocks(void)
{
	if (isup) return 0;

	handle = ggLoadModule("libpthread.so", 0);
	if (handle == GG_MODULE_NULL) {
		fprintf(stderr, "Can't load pthreads library.\n");
		return 1;
	}
	if ((my_init	= ggGetSymbolAddress(handle, "pthread_mutex_init"))
	    == NULL ||
	    (my_destroy	= ggGetSymbolAddress(handle, "pthread_mutex_destroy"))
	    == NULL ||
	    (my_lock	= ggGetSymbolAddress(handle, "pthread_mutex_lock"))
	    == NULL ||
	    (my_trylock = ggGetSymbolAddress(handle, "pthread_mutex_trylock"))
	    == NULL ||
	    (my_unlock  = ggGetSymbolAddress(handle, "pthread_mutex_unlock"))
	    == NULL) {
		_ggExitLocks();
		return 1;
	}
	isup = 1;

	return 0;
}
