/***************************************************************************
                          Kwin4  -  Four in a Row for KDE
                             -------------------
    begin                : March 2000 
    copyright            : (C) 1995-2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIN4_H
#define KWIN4_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstrlist.h>

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>

#include "KEMessage.h"
#include "KEInput.h"

#define KWIN4_VERSION "v0.9"

// forward declaration of the Kwin4 classes
class Kwin4Doc;
class Kwin4View;
class Geom;

extern int global_debug;

#define  DLGBACK QColor(128,128,255)

typedef enum  {Niemand=0,Gelb=1,Rot=2,Tip=3,Rand=4,GelbWin=9,RotWin=10} FARBE;
typedef enum  {Men=0,Computer=1,Remote=2} PLAYER;
typedef enum  {TSum,TWin,TRemis,TLost,TBrk} TABLE;
typedef enum  {GIllMove=-2,GNotAllowed=-1,GNormal=0,GYellowWin=1,GRedWin=2,GRemis=3,GTip=4} MOVESTATUS;

#define UPDATE_STATUS  1
#define UPDATE_TABLE   2
#define UPDATE_ARROW   4
#define UPDATE_XY      8


/**
  * The base class for Kwin4 application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of Kwin4View creates your center view, which is connected
  * to the window's Doc object.
  * Kwin4App reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class Kwin4App : public KMainWindow
{
  Q_OBJECT

  friend class Kwin4View;

  public:
    /** construtor of Kwin4App, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    Kwin4App();
    ~Kwin4App();
    /** enables menuentries/toolbar items
     */
    void enableCommand(int id_);
    /** disables menuentries/toolbar items
     */
    void disableCommand(int id_);
    /** add a opened file to the recent file list and update recent_file_menu
     */
    // void addRecentFile(const QString &file);
    /** opens a file specified by commandline option
     */
    void openDocumentFile(const char *_cmdl);
    /** returns a pointer to the current document connected to the KMainWindow instance and is used by
     * the View class to access the document object's methods
     */	
    Kwin4Doc *getDocument() const; 	

    /** Starts a new game */
    void NewGame(int mode);
  /** Ends the current game */
  void EndGame(TABLE mode);
  /** PErforms a game move */
  bool Move(int x,int id);
  /** Set the names in the mover field */
  void slotStatusNames();
  /** Uncheck Menuitem */
  void uncheckCommand(int id);
  /** Is the menuitem enabled? */
  bool isEnabled(int id);
  void SetGrafix(QString grafix);
  QString appTitle() {return mAppTitle;}


  protected:
    /** Create input device */
    bool MakeInputDevice(int i);

     /** Prepare the next move */
     bool NextMove(MOVESTATUS res );

    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
     * @see KAccel
     */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
     * @see KApplication#getHelpMenu
     */
    void initMenuBar();
    /** this creates the toolbars.
     */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KMainWindow#queryClose
     * @see KMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KMainWindow#queryExit
     * @see KMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);
  /** Check a menuitem */
  void checkCommand(int id);

  /** Put game into message */
  void prepareGame(KEMessage *msg);
  /** Extract game from message */
  int extractGame(KEMessage *msg);

  public slots:
    void slotPrepareProcessMove(KEMessage *msg);
    void slotPrepareRemoteMove(KEMessage *msg);
    void slotPrepareInteractiveMove(KEMessage *msg);
    void slotReceiveInput(KEMessage *msg,int id);


    /** Show menus? */
    void slotFileToShow();
    void slotEditToShow();
    void slotOptionsToShow();
    void slotStartcolorToShow();
    void slotRedToShow();
    void slotYellowToShow();
    void slotLevelToShow();

    void slotHelpAbout();

    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
    void statusCallback(int id_);
    /** open a new application window by creating a new instance of Kwin4App */
    // void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
     /** give a play hint */
     void slotFileHint();
     /** send mesasge */
     void slotFileMessage();
     /** show statistics */
     void slotFileStatistics();

    /** Undo move */
    void slotEditUndo();
    /** Redo move */
    void slotEditRedo();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    /** changes the start coulour */
    void slotStartcolourRed();
    void slotStartcolourYellow();
    void slotYellowPlayer();
    void slotYellowComputer();
    void slotYellowRemote();
    void slotRedPlayer();
    void slotRedComputer();
    void slotRedRemote();
    void slotLevel(int i);
    void slotOptionsNames();
    void slotOptionsAnimations();
    int slotOptionsNetwork();
    void slotOptionsNetworkserver();

    void slotStatusMover(const QString &text);
    void slotStatusTime();
    void slotStatusMsg(const QString &text);
    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);

  private:
    // Input handling
    KEInput *mInput;
    // Grafix
    QString mGrafix;

    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** the recent file menu containing the last five opened files */
    // QPopupMenu *recentFilesMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** options_menu contains all items of the menubar entry "Options" */
    QPopupMenu *optionsMenu;
    /** And its submenues */
    QPopupMenu *popStartcolor;
    QPopupMenu *popLevel;
    QPopupMenu *popYellow;
    QPopupMenu *popRed;


    /** help_menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu_;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    Kwin4View *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    Kwin4Doc *doc;
    QString mAppTitle;

protected slots: // Protected slots
  /** Triggers the status timer */
  void slotStatusTimer(void);
  void slotBlinkTimer(void);
protected: // Protected attributes
  /**  */
  /** Counts the time in the status bar */
  QTimer * statusTimer;
  QTimer * blinkTimer;
};
 
#endif // KWIN4_H
/** Pass on the about data */
