/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000,2001 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  $Log: kfibschat.h,v $
  Revision 1.3  2001/01/06 23:31:17  hoefkens
  Lots of small changes and fixed. Big thing is a rewrite of the join menu
  in kbgfibs.

  
*/

#ifndef __KFIBSCHAT_H 
#define __KFIBSCHAT_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qframe.h>
#include <keditcl.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qsplitter.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qstrlist.h>
#include <kapp.h>
#include <ktoolbar.h>
#include <qlayout.h>
#include <qtabdialog.h>
#include <klineedit.h>
#include <kaction.h>
#include <qtextview.h>
#include <qdict.h>

#include <kbgtextview.h>

class KFibsChat;
class KFibsEditGag;



/** 
 * Class of the KFibs Chat Windows
 *
 * This class inherits from QFrame and represents a widget for a chat window. 
 * It has a rich text view and a toolbar with a command selection combo box 
 * and entry fields.
 */
class KFibsChat : public QFrame
{
	Q_OBJECT

public:
	
	/**
	 * Constructor
	 */
	KFibsChat(QWidget *parent = 0, const char *name = 0);

	/**
	 * Destructor
	 */
	virtual ~KFibsChat();

protected:

	/*
	 * Catch show events, so the engine's menu can be update. 
	 */
	virtual void showEvent(QShowEvent *e);
	
	/*
	 * Catch hide events, so the engine's menu can be update. 
	 */
	virtual void hideEvent(QHideEvent *e);
	
private:

	enum MenuID  {Info, Invite, Talk, Gag, GagEdit, GagClear, Silent};

	enum Command {Kibitz, Shout, Tell, Whisper, Message, Say};
	
	/**
	 * Main window is an edit control
	 */
	KBgTextView *textWindow;
	
	/**
	 * Command selector 
	 */
	QComboBox *cmdSelect;

	/**
	 * Two entry fields for names and messages
	 */
	KLineEdit *cmdName, *cmdText;

	/**
	 * Separate the entry fields
	 */
	QSplitter *splitter;
	
	/**
	 * Context menu of the edit control
	 */
	QPopupMenu *contextMenu;

	/**
	 * Properly align the widgets in the dialog
	 */
	QBoxLayout *hl, *vl;

	/**
	 * list of users we do not want to hear shouting
	 */
	QStrList gagList;                  
	
	/**
	 * ignore all shouts ?
	 */
	bool silent;

	/**
	 * Name of the user that has been selected for the context menu
	 */
	QString currUser;

	/**
	 * List box in the setup dialog - gag list copy
	 */
	QListBox *lbg;

	/**
	 * User to be added to the gag list copy
	 */
	QLineEdit *leg;

public slots:

        /**
	 * Process and append msg to the text.
	 */
        void handleData(const QString &msg);

	/**
	 * Restore previously saved setting or provides defaults
	 */
        void readConfig();

	/**
	 * Save current settings
	 */
	void saveConfig();

	/**
	 * Set the opponents name and select whisper
	 */
        void startGame(const QString &name);

	/**
	 * Game is over. We won (or not) and have been playing (or not)
	 */
        void endGame();

	/**
	 * Start talking to name
	 */
	void fibsTalk(const QString &name);

protected slots:

        /**
	 * Request information on a user
	 */
        void infoUser();

	/**
	 * Invite a user - opens a dialog
	 */
        void inviteUser();

	/**
	 * Start talking to a user
	 */
	void talkToUser();
	
	/**
	 * Reflect current state of the program in the context menu
	 */
	void prepareMenu();

	/**
	 * Adds currUser to the gag list
	 */
	void gagUser();

	/**
	 * Opens up a dialog that allows removal of users from the gag list
	 */
	void editGagList();

	/**
	 * Clears the whole gag list
	 */
	void clearGagList();

	/**
	 * Set the silent flag
	 */
	void toggleSilent();

	/**
	 * Enable the first entry field
	 */
	void enableNameEdit(const QString &);

	/**
	 * Set up the command string.
	 */
	void prepareCommand(const QString &);
	
	/**
	 * Remove all selected users from the gag list copy
	 */
	void removeGagListEdit();

	/**
	 * Clear the whole gag list copy
	 */
	void clearGagListEdit();
	
	/**
	 * Add a new user to the gag list copy
	 */
	void addGagListEdit();

signals:

	/**
	 * Emits a string that can be sent to the server
	 */
	void fibsCommand(const QString &cmd);
	
        /**
	 * Request an invitation of player
	 */
	void fibsRequestInvitation(const QString &player);

	/**
	 * Text of a personal message
	 */
	void personalMessage(const QString &msg);

	/**
	 * Dialog is visible or not
	 */
	void windowVisible(bool v);
};


/** 
 * A simple dialog that lets the user remove multiple users from 
 * the gag list. The constructor gets the gag list and the new
 * list can be obtained afterwards.
 */
class KFibsEditGag : public QDialog
{
	Q_OBJECT
	
public:

	/**
	 * Constructor
	 */
	KFibsEditGag(const QStrList *gagList, QWidget *parent = 0, const char *name = 0);

	/**
	 * Destructor
	 */
	virtual ~KFibsEditGag();

	/**
	 * Return the modified gag List
	 */
	QStrList getGagList();
	
protected:
	
	/**
	 * Child widgets
	 */
	QListBox     *lb;
	QPushButton  *ok, *cancel;
	
	/**
	 * This stores the gag list
	 */
	QStrList l;
};


#endif // __KFIBSCHAT_H 
