#ifndef LINKABLEMAPOBJ_H
#define LINKABLEMAPOBJ_H

#include "frameobj.h"
#include "noteobj.h"
#include "headingobj.h"
#include "flagrowobj.h"

#define MAX_DEPTH 999

enum LinkOrient {OrientUndef,OrientLeftOfCenter, OrientRightOfCenter};
enum LinkStyle {
	StyleUndef,
	StyleLine, 
	StyleParabel, 
	StylePolyLine,
	StylePolyParabel
};
enum LinkPos {LinkMiddle,LinkBottom};
enum LinkColorHint {DefaultColor,HeadingColor};

class LinkableMapObj:public QObject, public MapObj {
	Q_OBJECT
public:
    LinkableMapObj ();
    LinkableMapObj (QCanvas*);
    LinkableMapObj (LinkableMapObj*);
    ~LinkableMapObj ();
	virtual void delLink();
    virtual void init ();
    virtual void copy (LinkableMapObj*);
    void setChildObj (LinkableMapObj*);
    virtual void setParObj (LinkableMapObj*);
    virtual void setParObjTmp (LinkableMapObj*,QPoint,int);	// Only for moving Obj around
	virtual void unsetParObjTmp();						// reuse original ParObj
	virtual bool hasParObjTmp();

	virtual void setUseRelPos (const bool&);
	virtual void setRelPos();				// set relPos to current parentPos
	virtual void setRelPos(const QPoint&);	
	virtual void setUseOrientation (const bool &);


	virtual int getTopPad();
	virtual int getLeftPad();
	virtual int getRightPad();
	LinkStyle getDefLinkStyle();
    void setLinkStyle(LinkStyle);            
	LinkStyle getLinkStyle();
	void setHideLinkUnselected(bool);
	bool getHideLinkUnselected();
	void setLinkPos (LinkPos);
	LinkPos getLinkPos ();

	virtual void setLinkColor();					// sets color according to colorhint, overloaded
	virtual void setLinkColor(QColor);
	QColor getLinkColor();
	virtual FrameType getFrameType ();
	virtual void setFrameType (const FrameType &);
	virtual void setFrameType (const QString &);
	virtual void setVisibility (bool);
    virtual void updateLink();				// update parPos and childPos
											// depending on pos
											// redraw link with given style
    LinkableMapObj* getChildObj();			// returns pointer to fromObj
    LinkableMapObj* getParObj();			// returns pointer to toObj
    virtual LinkableMapObj* findObjBySelect(QString s);	// find obj by selectstring
	virtual void setDockPos();				// sets childPos and parPos
    QPoint getChildPos();					// returns pos where childs dock
    QPoint getParPos();						// returns pos where parents dock
    QPoint getRelPos();						// get position relative to parent (or (0,0))
    LinkOrient getOrientation();			// get orientation
    virtual int getDepth();					// return depth
	virtual void setMapEditor(MapEditor*);	// set MapEditor (needed in LMO::updateNoteFlag)
	virtual MapEditor* getMapEditor();		// get MapEditor (usually from parent);
	virtual QPoint getRandPos();			// make randomised position

    virtual void alignRelativeTo(const QPoint );
	virtual void reposition();
	virtual void requestReposition();		// do reposition after next user event
	virtual void forceReposition();			// to force a reposition now (outside
											// of mapeditor e.g. in noteeditor
	virtual bool repositionRequested();

	virtual QRect getTotalBBox()=0;			// return BBox including childs			
	virtual QRect getBBoxSizeWithChilds()=0;// return size of BBox including childs  
	virtual void calcBBoxSizeWithChilds()=0;// calc size of  BBox including childs recursivly

	virtual void setSelBox();
    virtual void select();
    virtual void unselect();
	virtual	QString getSelectString()=0;
	virtual QString saveToDir (const QString&,const QString&, const QPoint&)=0;// Save data to tempdir

protected:
	void parabel(QPointArray &,double,double,double,double);	// Create Parabel connecting two points
	QString getLinkAttr();

    QPoint childPos;
    QPoint parPos;
	bool link2ParPos;				// While moving around, sometimes link to parent
	MapEditor* mapEditor;			// for updateNoteFlag() and toggleScroll()
    LinkOrient orientation;     
    int linkwidth;					// width of a link
    int depth;						// depth: undef=-1 mapCenter=0 branch=1..n
	QRect bboxTotal;				// bounding box including childs

    LinkableMapObj* childObj;
    LinkableMapObj* parObj;
    LinkableMapObj* parObjTmpBuf;	// temporary buffer the original parent
    int bottomlineY;                // vertical offset of dockpos to pos

	int thickness_start;			// for StylePoly*	
    LinkStyle style;				// Current style
	LinkPos linkpos;				// Link at bottom of object or middle of height
    QColor linkcolor;               // Link color
    QCanvasLine* l;                 // line style
	QCanvasPolygon* p;				// poly styles
    int arcsegs;                    // arc: number of segments
    QPtrList <QCanvasLine> segment; // a part of e.g. the parabel
	QPointArray pa0;				// For drawing of PolyParabel and PolyLine
	QPointArray pa1;				// For drawing of PolyParabel 
	QPointArray pa2;				// For drawing of PolyParabel	
    QCanvasLine* bottomline;        // on bottom of BBox
	bool repositionRequest;			// 

	bool selected;					// Used for marking the selection
	bool hideLinkUnselected;		// to hide links if unselected
	QCanvasRectangle* selbox;
	FrameObj *frame;				// frame around object
	int topPad, botPad,
		leftPad, rightPad;          // padding within bbox

	QPoint relPos;					// position relative to childPos of parent
	bool useRelPos;
	bool useOrientation;
};
#endif
