#include <config.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "http_utils.h"


/**
 *  General purpose http utility methods from the ancient NCSA HTTPd
 *  server written by Rob McCool.
 *
 *  @author Rob McCool 
 *
 *  @version \$Id: http_utils.c,v 1.3 2002/08/26 16:28:39 chopp Exp $
 *
 *  @file
 */


/* ------------------------------------------------------------------ Public */
  

/* Pices from the ancient NCSA HTTPd by Rob McCool */

char x2c(char *what) {
  
  register char digit;
  
  digit = ((what[0] >= 'A') ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  
  return(digit);
  
}


void unescape_url(char *url) {
  
  register int x,y;
  
  for(x=0,y=0;url[y];++x,++y) {
    if((url[x] = url[y]) == '%') {
      url[x] = x2c(&url[y+1]);
      y+=2;
    }
  }
  url[x] = '\0';
  
}


char *makeword(char *line, char stop) {

  int x= 0, y;
  char *word= xmalloc(sizeof(char) * (strlen(line) + 1));
  
  for(x=0;((line[x]) && (line[x] != stop));x++)
      word[x] = line[x];
  
  word[x] = '\0';
  if(line[x]) ++x;
  y=0;
  while((line[y++] = line[x++]));
  
  return word;
  
}


void plustospace(char *str) {

  register int x;
  
  for(x=0;str[x];x++) if(str[x] == '+') str[x] = ' ';
  
}
