/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <conf.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <ncurses.h>
#include <panel.h>
#include "mudix.h"

#define MAX_ARGS	10

char args_table[MAX_ARGS][MAX_STRING];

void build_arg_table(char *args)
{
    int i;

    for (i=0; i<MAX_ARGS; i++)
        args = get_arg(args, args_table[i]);	    
}

char *parse_input(char *src, char *args, char *dest, bool fReturn)
{
    char *pTmp;
    int   nested = 0;

    if (args)
	build_arg_table(args);

    while (*src != '\0') {
        if (*src == '{')	/* check for { } cos | is not valid then */
            nested++;
	else if (*src == '}')
	    nested--;
	else if (*src == '|' && nested == 0) {
	    src++;
	    fReturn = TRUE;
	    break;
	}

	if (*src != '%' || !args) {
	    *dest++ = *src++;    
            continue;
	}

	if (*(++src) == '\0')
	    break;
	if (!isdigit(*src))
	    continue;
	pTmp = args_table[*src - '0'];
        while (*pTmp != '\0')
	    *dest++ = *pTmp++;
	src++;
    }
    if (fReturn)
	*dest++ = '\n';
    *dest = '\0';

    return src;
}

char *get_arg(char *src, char *dst)
{
    int nested = 0;

    while (*src == ' ') /* strip leading spaces */
        src++;

    while (isprint(*src)) {
        if (*src == '{') {
            nested++;
	    if (nested == 1) {
		src++;
		continue;
	    }
	}
	else if (*src == '}') {
            nested--;
	    if (nested == 0) {
		src++;
		break;
	    }
	}
	else if (!nested && *src == ' ')
            break;

        *dst++ = *src++;
    }
    *dst++ = '\0';

    return src;
}

