#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

/* error() - output error messages */

void error(char *token,char *expected,char *keyword)
{
  printf("Parse Error: Expected '%s' and got '%s' in '%s' on line %d\n",expected,token,keyword,line);
}

/* push() - pushback a token (for looking ahead) */

void push(char *token,int tokentype)
{
  strcpy(tokenpush,token);
  tokentypepush=tokentype;
}

void push2(char *token,int tokentype)
{
  strcpy(tokenpush2,token);
  tokentypepush2=tokentype;
}

/* isnum() - check and see if current string is a number */

int isnum(char *s)
{
int l,t;

  l=strlen(s);

  for(t=0; t<l; t++)
  { if (s[t]<'0' || s[t]>'9') return 0; }

  return 1;
}

/* strcasestr - case insensitive version of strstr */

char *strcasestr(char *hejstack, char *needle)
{
int hejlen,neelen;
int t;

  hejlen=strlen(hejstack);
  neelen=strlen(needle);

  for(t=0; t<=hejlen-neelen; t++)
  {
    if (strncasecmp(&hejstack[t],needle,neelen)==0)
    { return &hejstack[t]; }
  }

  return (char *)0;
}

/* Decide the case of an asp variable and change */

void strcase(char *s)
{
int l,r;

  if (casesense==0) return;

  l=strlen(s);

  for(r=0; r<l; r++)
  {

    if (casesense==1)
    { s[r]=tolower(s[r]); }
      else
    { s[r]=toupper(s[r]); }
  }
}

int is_asp_filename(char *filename)
{
int t;

  for (t=0; t<aspextensions_ptr; t++)
  {
    if (strlen(filename)>strlen(aspextensions[t]))
    {
      if (strcasecmp(filename+(strlen(filename)-strlen(aspextensions[t])),aspextensions[t])==0)
      { return 1; }
    }
  }

  return 0;
}

int extcmp(char *filename, char *extension)
{
  if (strlen(filename)>strlen(extension))
  {
    if (strcasecmp(filename+(strlen(filename)-strlen(extension)),extension)==0)
    { return 1; }
  }

  return 0;
}

void change_extension(char *filename, char *extension)
{
int t,r;

  t=strlen(filename);

  for (r=t; r>=0; r--)
  {
    if (filename[r]=='.')
    {
      strcpy(filename+r,extension);
      return;
    }
  }
}

/* autoindent() - this sets up proper clean Kohnian style
   programming indenting in the outputted php code */

int autoindent()
{
int r;
char spaces[1024];

  /* if (column!=0) return 0; */
  strcpy(spaces,"");

  for (r=0; r<indent; r++)
  { strcat(spaces,"  "); }

  fprintf(out,"%s",spaces);

  return 0;
}

void add_indent(char *newtoken)
{
int r;

  for (r=0; r<indent; r++)
  { strcat(newtoken,"  "); }
}



