#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "globals.h"

#define VERSION "asp2php 0.75.12 - February 27, 2001\n" \
    "Copyright 2001 By Michael Kohn (naken@naken.cc)\n" \
    "License: GPL\n"
#include "functions.h"

/* ASP to PHP converter           */
/* Copyright 2001 by Michael Kohn */

/*
Token Types:

0: EOF
1: number
2: keyword
3: _
4: identifier
5: EOL
6: %>
7: +,-,*,/
8: >,<,<=,>=,<>
9: &
10: "    "
11: '    '
12: (,)
13: :
14: .
15: comment
16: ,

*/

/*

DataBase Types:

1: MySQL
2: ODBC
3: Oracle 8
4: Sybase
5: Postgres

Object Types:

-1: Nothing

 1: ADODB.Connection
 2: ADODB.RecordSet
 3: ADODB.Command
 5: File

*/

char tokenpush[TOKENSIZE]={ 0 };
int tokentypepush=0;
char tokenpush2[TOKENSIZE]={ 0 };
int tokentypepush2=0;
FILE *in,*out;
int pushback=-1;
char keywords[80][20]= 
  { "atn","case","cos","do","exp","if","else","elseif",
    "end","for","dim","log","randomize","rnd","sin","sqr","tan",
    "request","response","session","select","while","write",{ 0 } };
int indent=0,line=1,column=0;
char objects[80][50];
char objectstype[80][50];
int objectsptr=0;
int database_type=0;
int setvar=0;
int add_isnum=0,add_session=0,BOF=0;
int infunct=0,functptr;
char funct[80][50];
char global_uid[70];
char global_passwd[70];
char global_database[70];
char global_address[70];
char global_dsn[70];
char sessionpool[256][200];
int sessionptr=0;
int pngs=0,y2k=1,casesense=0,php=0;
int html=0,spacer=0;
char aspextensions[20][10];
int aspextensions_ptr=0;
int includes=0;
int requestvar=0;
int javascript=0;
int loopcount=0;

/* PHP 3.0 and lower didn't have an isnum type function
   close enough to asp this adds one into the output source
   if needed */

void convert(char *infile, char *outfile);

void insert_isnum()
{
  fprintf(out,"\nfunction IsNumeric($n)\n{\n");
  fprintf(out,"  $p=trim($n);\n  $l=strlen($p);\n\n");
  fprintf(out,"  for ($t=0; $t<$l; $t++)\n");
  fprintf(out,"  {\n    $c=substr($p,$t,1);\n");
  fprintf(out,"    if ($c<'0' || $c>'9')\n");
  fprintf(out,"    { if ($c!='.') return 0; }\n");
  fprintf(out,"  }\n\n  return 1;\n}\n");

  add_isnum=0;
}

/* getobject() - figure out what kind of object the
   next token is and place it in the literal pool */

int getobject(char *token)
{
int t;

  for (t=0; t<objectsptr; t++)
  { if (strcasecmp(token,objects[t])==0) break; }

  if (t==objectsptr) return 0;

  if (strcasestr(objectstype[t],"ADODB.Connection")!=0) return 1;
  if (strcasestr(objectstype[t],"ADODB.Execute")!=0) return 2;
  if (strcasestr(objectstype[t],"ADODB.Command")!=0) return 3;
  if (strcasestr(objectstype[t],"ADODB.RecordSet")!=0) return 2;
  if (strcasestr(objectstype[t],"File")!=0) return 5;

  return 0;
}

/* fixw2k changes occurances of .asp to .php3 and
   .htm to .html */

int fixw2k(char *token)
{
int l,sl,t;

  sl=strlen(token)-4;

  for (l=1; l<sl; l++)
  {
    if (token[l]=='.')
    {
      if ((token[l+1]=='a' || token[l+1]=='A') &&
         ((token[l+2]=='s' || token[l+2]=='S') &&
         (token[l+3]=='p' || token[l+3]=='P')))
      {
	if (!((token[l+4]>='a' && token[l+4]<='z') ||
	(token[l+4]>='A' && token[l+4]<='Z')))
        {
          token[l+1]='p';
          token[l+2]='h';
          token[l+3]='p';

          if (php!=0)
          {
            for (t=sl+4; t>l+3; t--)
            { token[t+1]=token[t]; }
            if (php==3)
            { token[l+4]='3'; }
              else
            { token[l+4]='4'; }
	    sl++;
	  }
        }
      }
	else
      if ((token[l+1]=='h' || token[l+1]=='H') &&
         ((token[l+2]=='t' || token[l+2]=='T') &&
         (token[l+3]=='m' || token[l+3]=='M')))
      {
	if (!((token[l+4]>='a' && token[l+4]<='z') ||
	(token[l+4]>='A' && token[l+4]<='Z')))
        {
          if (html==1)
          {
            for (t=sl+4; t>l+3; t--)
            { token[t+1]=token[t]; }
            token[l+4]='l';
            sl++;
          }
        }
      }
    }
  }

  return 0;
}

/* checks to see if the current token is a known
   defined function */

int isfunction(char *token)
{
int t=0;

  while(funct[t][0]!=0)
  {
    if (strcasecmp(funct[t],token)==0) return 1;
    t++;
  }

  return 0;
}

/* iskeyword() - I believe this is obsolete.  I was going
   to make asp2php test to see if tokens were known keywords
   before trying to use them */

int iskeyword(char *token)
{
int t=0;

  while(keywords[t][0]!=0)
  {
    if (strcasecmp(keywords[t],token)==0) return 1;
    t++;
  }

  return 0;
}

int parse_command_set(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);
  strcpy(newtoken,"");

  if (tokentype==2)
  {
    autoindent();
    fprintf(out,"$%s_%s=",variable,token);

    tokentype=gettoken(token);

    if (strcmp(token,"=")!=0)
    { error(token,"=","Command Object"); }
    eval_expression(" ");
  }

  return 0;
}

int parse_command(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
char temp[1024];

  sprintf(newtoken,"%s",variable);

  while(1)
  {
    tokentype=gettoken(token);

    if (tokentype!=2)
    { push(token,tokentype); break; }

    sprintf(temp,"_%s",token);

    tokentype=gettoken(token);

    if (strcmp(token,".")!=0)
    { push(token,tokentype); break; }
  }

  return 0;
}

int eval_funct(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
int parencount=1;
char molecule[LINELENGTH];

  tokentype=gettoken(token);
  if (strcmp("(",token)!=0)
  { error(token,"(","eval_funct"); return 0; }

  while((tokentype=gettoken(token))!=0)
  {
    if (strcmp("(",token)==0)
    { parencount++; strcat(newtoken,"("); }
      else
    if (strcmp(")",token)==0)
    { 
      parencount--;
      if (parencount!=0) 
      { strcat(newtoken,")"); }
	else
      { break; }
    }
      else
    if (strcmp(",",token)==0)
    { strcat(newtoken,","); }
      else
    { 
      eval_element(molecule,tokentype,token);
      strcat(newtoken,molecule);
    }
  }

  return 0;
}

int parse_server(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char temptoken[LINELENGTH];

  if ((tokentype=gettoken(token))!=14)
  {
    error(token,".","Server");
    return 0;
  }

  tokentype=gettoken(token);

  if (strcasecmp(token,"htmlencode")==0)
  { 
    strcat(newtoken,"htmlspecialchars("); 
    eval_funct(newtoken); 
    strcat(newtoken,")");
  } 
    else
  if (strcasecmp(token,"urlencode")==0)
  { 
    strcat(newtoken,"rawurlencode("); 
    eval_funct(newtoken); 
    strcat(newtoken,")");
  } 
    else
  if (strcasecmp(token,"scripttimeout")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,"=")!=0)
    { error(token,"=","ScriptTimeOut"); }
    strcat(newtoken,"set_time_limit(");
    eval_molecule(temptoken);
    strcat(newtoken,temptoken);
    strcat(newtoken,");\n");
  } 
    else
  { strcat(newtoken,"// asp2php says 'huh'?: "); eval_expression(" "); }

  return 0;
}

int parse_set(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char temptoken[TOKENSIZE];
char temp_spaces[100];
int t;

  temp_spaces[0]=0;
  tokentype=gettoken(token);

  for (t=0; t<objectsptr; t++)
  { if (strcasecmp(token,objects[t])==0) break; }

  strcpy(temptoken,token);

  if (t<objectsptr && getobject(token)==3)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);
      sprintf(newtoken,"$%s_%s=",temptoken,token);

      tokentype=gettoken(token);
      if (strcmp(token,"=")!=0)
      { error(token,"=","Set"); }

      tokentype=gettoken(token);
      if (getobject(token)==1)
      {
        strcat(newtoken,"$");
        strcat(newtoken,token);
      }

      while(tokentype!=5)
      { tokentype=gettoken(token); }

      strcat(newtoken,";");
      strcat(newtoken,"\n");

      return 0;
    }
      else
    { push(token,tokentype); }
  }

  strcpy(objects[t],token);
  strcpy(objectstype[t],"unkown");
  if (t==objectsptr) objectsptr++;

  tokentype=gettoken(token);
  if (strcmp(token,"=")!=0)
  { error(token,"=","Set"); }

  tokentype=gettoken(token);
  if (strcasecmp(token,"nothing")==0)
  { 
    add_indent(temp_spaces);
    sprintf(newtoken,"%s$%s=null;\n",temp_spaces,temptoken); 
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    { error(token,".","Server"); }

    tokentype=gettoken(token);
    if (strcasecmp(token,"createobject")==0)
    {
      tokentype=gettoken(token);
      if (strcmp(token,"(")!=0)
      { error(token,"(","CreateObject"); }

      tokentype=gettoken(token);
      if (tokentype!=10 && tokentype!=11)
      { error(token,"String Literal","CreateObject"); }

      strcpy(objectstype[t],token);
      if (t==objectsptr) objectsptr++;

      tokentype=gettoken(token);
      if (strcmp(token,")")!=0)
      { error(token,")","CreateObject"); }
      sprintf(newtoken,"// $%s is of type %s\n",objects[t],objectstype[t]);
    }
      else
    {
      setvar=t;
      eval_element(newtoken,tokentype,token);
      setvar=0;
      sprintf(newtoken,"// $%s is of type %s\n",objects[t],objectstype[t]);
    } 
    
  }
    else
  {
/* printf("Set NOT SERVER (eval_element): %s\n",token); */
    setvar=t;
    eval_element(newtoken,tokentype,token);
/* printf("came back: %s\n",newtoken); */
    setvar=0;
/*
    strcpy(tokenpush,token);
    tokentypepush=tokentype;
    eval_molecule(temptoken);
    sprintf(newtoken,"$%s=",objects[t]);
    strcat(newtoken,temptoken);
*/
  }

  return 0;
}

int parse_rem()
{
int ch;

  fprintf(out,"// ");

  while((ch=getc(in)))
  {
    if (ch=='\r') ch='\n';
    putc(ch,out);
    if (ch=='\n' || ch==EOF) return 0;
  }

  return 0;
}

int parse_dim()
{
char token[TOKENSIZE];
int tokentype;

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==5 || tokentype==13) break;
  }
  return 0;

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==6)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
      return 0; 
    }
      else
    if (tokentype==5 || tokentype==13)
    { putc('\n',out); return 0; }
      else
    if (tokentype!=2 && tokentype!=16)
    { error(token,", or variable","Dim"); }
      else
    if (tokentype==2)
    { fprintf(out,"$%s=0; ",token); }
  } 

  return 0;
}

int parse_at()
{
int tokentype;
char token[TOKENSIZE];

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==6)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
      return 0; 
    }
      else
    if (tokentype==5 || tokentype==13)
    { break; }
      else
    if (strcasecmp(token,"language")==0)
    { fprintf(out,"// LANGUAGE = asp2php converted\n"); }
  }

  return 0;
}

int eval_token(int tokentype,char *token)
{
char temptoken[TOKENSIZE];
char newtoken[1024];
int t,ch;

  if (strcasecmp(token,"exit")==0)
  { 
    if (loopcount==0)
    { 
      autoindent();
      fprintf(out,"exit();"); 
    }
      else
    { 
      autoindent();
      fprintf(out,"break;"); 
    }
  }
    else
  if (strcasecmp(token,"do")==0)
  { parse_do(); }
    else
  if (strcasecmp(token,"while")==0)
  { parse_while(); }
    else
  if (strcasecmp(token,"select")==0)
  { parse_select(); }
    else
  if (strcasecmp(token,"if")==0)
  { parse_if(); }
    else
  if (strcasecmp(token,"rem")==0)
  { parse_rem(); }
    else
  if (strcasecmp(token,"dim")==0)
  { parse_dim(); }
    else
  if (strcasecmp(token,"option")==0)
  { fprintf(out,"// Option "); eval_expression(" ");  }
    else
  if (tokentype==2 && strcasecmp(token,"set")==0)
  {
    parse_set(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"sub")==0)
  { parse_funct(2); }
    else
  if (strcasecmp(token,"function")==0)
  { parse_funct(1); }
    else
  if (strcasecmp(token,"session")==0)
  { parse_session(); }
    else
  if (strcasecmp(token,"response")==0)
  { parse_response(); }
    else
  if (strcasecmp(token,"const")==0)
  { 
    tokentype=gettoken(token);
    eval_expression(token); 
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    parse_server(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"for")==0)
  { parse_for(); }
    else
  if (strcmp(token,"@")==0)
  { parse_at(); }
    else
  if (strcmp(token,"=")==0)
  {
    autoindent();
    fprintf(out,"echo ");
    eval_expression(" ");
  }
    else
  if (tokentype==2 && ((t=getobject(token))!=0))
  {
    strcpy(temptoken,token);
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
    }

    strcase(temptoken);

    if (t==1) 
    { 
      if (database_type==0)
      { parse_adodb_connection_mysql(newtoken,temptoken); }
        else
      if (database_type==1)
      { parse_adodb_connection_odbc(newtoken,temptoken); }
        else
      if (database_type==2)
      { parse_adodb_connection_oracle(newtoken,temptoken); }
        else
      if (database_type==3)
      { parse_adodb_connection_sybase(newtoken,temptoken); }
        else
      if (database_type==4)
      { parse_adodb_connection_pg(newtoken,temptoken); }
    }
      else
    if (t==2) 
    { 
      if (database_type==0)
      { parse_adodb_rs_mysql(newtoken,temptoken); }
        else
      if (database_type==1)
      { parse_adodb_rs_odbc(newtoken,temptoken); }
        else
      if (database_type==2)
      { parse_adodb_rs_oracle(newtoken,temptoken); }
        else
      if (database_type==3)
      { parse_adodb_rs_sybase(newtoken,temptoken); }
        else
      if (database_type==4)
      { parse_adodb_rs_pg(newtoken,temptoken); }
    }
      else
    if (t==3) { parse_command_set(newtoken,temptoken); }

    autoindent();
    fprintf(out,"%s",newtoken);
  }
    else
  if (tokentype==11)
  {
    /* This kinda sucks but.. if token is 11 at the beginning of the line
    lets assume that it's a comment line.. this might cause problems..
    if you have problems, comment this crap out */
    fprintf(out,"//%s",&token[1]);
    ch=0;
    while (ch!='\r' && ch!='\n')
    {
      if (pushback!=-1)
      { ch=pushback; pushback=-1; }
        else
      { ch=getc(in); }
      if (ch==EOF) break;
      putc(ch,out);
    }
    line++;
    pushback=getc(in);
    if (pushback=='\n' || pushback=='\r')
    { if (ch!=pushback) pushback=-1; }
  }
    else
  { eval_expression(token); }

  return 0;
}

int eval_molecule(char *newtoken)
{
char token[TOKENSIZE];
char temptoken[LINELENGTH];
int tokentype;
int isstring=0;
int r;
int paren=0;

  strcpy(newtoken,"");

  while((tokentype=gettoken(token))!=0)
  {
    if (strcmp(token,"(")==0) paren++;
      else
    if (strcmp(token,")")==0) paren--;

    if (paren<0) return 1;

    if (tokentype==10 || tokentype==11)
    { isstring=1; strcat(newtoken,token); }
      else
    if (tokentype==6)
    {
      tokentypepush=tokentype;
      strcpy(tokenpush,token);
      break;
    }
      else
    if (tokentype==5 || tokentype==13)
    { break; }
      else
    if (strcmp(token,"&")==0)
    { strcat(newtoken,"."); }
      else
    if (strcmp(token,",")==0)
    { break; }
      else
/*
    if (strcmp(token,"+")==0 && isstring==1)
    { strcat(newtoken,"."); }
      else
*/
    if (tokentype==2 && strcasecmp(token,"AND")==0)
    { strcat(newtoken,"&"); }
      else
    if (tokentype==2 && strcasecmp(token,"OR")==0)
    { strcat(newtoken,"|"); }
      else
    if (tokentype==1)
    { strcat(newtoken,token); }
      else
    if (tokentype==3)
    {
      strcat(newtoken,"\n");
      for (r=0; r<indent+1; r++) strcat(newtoken,"  ");
    }
      else
    if (tokentype!=2)
    { strcat(newtoken,token); }
      else
    {
      eval_element(temptoken,tokentype,token);
      strcat(newtoken,temptoken);
    }
  }

  return 0;
}

int parse_body(int iflag)
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c,ch;

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==5 && iflag==1)
    { break; }
      else
    if (tokentype==5)
    { putc('\n',out);  /* THIS MIGHT SUCK */  }
      else
    if (tokentype==6)
    {
      if (iflag==1)
      {
	tokentypepush=tokentype;
	strcpy(tokenpush,token);
	putc('\n',out);
	return 0;
      }

      fprintf(out,"?>"); copyhtml();
    }
      else
    if (strcasecmp(token,"case")==0)
    { strcpy(tokenpush,token); tokentypepush=tokentype; break; }
      else
    if ((strcasecmp(token,"loop")==0 || strcasecmp(token,"wend")==0) ||
         (strcasecmp(token,"end")==0 || strcasecmp(token,"next")==0))
    { break; }
      else
    if (strcasecmp(token,"elseif")==0)
    { 
      indent--;
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"if ");
      parse_condition();
      fprintf(out,"\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (strcasecmp(token,"session")==0)
    { parse_session(); }
      else
    if (strcasecmp(token,"else")==0)
    { 
      indent--;
      autoindent();
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (tokentype==15)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==0)
    { return 0; }
      else
    if (isfunction(token)==1)
    {
      c=gettoken(token);
      if (strcmp(token,"=")==0)
      {
        autoindent();
	fprintf(out,"return ");
	eval_expression(" ");
      }
	else
      if (strcmp(token,"(")==0)
      {
	fprintf(out,"%s(",token);
	strcpy(tokenpush,"(");
	tokentypepush=tokentype;
	eval_funct(newtoken);
	fprintf(out,"%s);",newtoken);
      }
	else
      {
	error(token,"= or (","body");
      }
    }
      else
    if (tokentype==2 || strcmp("=",token)==0) 
    { 
      eval_token(tokentype,token); 
    }
      else
    if (tokentype==11)
    {
      /* This kinda sucks but.. if token is 11 at the beginning of the line
      lets assume that it's a comment line.. this might cause problems..
      if you have problems, comment this crap out */
      fprintf(out,"//%s",&token[1]);
      ch=0;
      while (ch!='\r' && ch!='\n')
      {
        if (pushback!=-1)
        { ch=pushback; pushback=-1; }
          else
        { ch=getc(in); }
        if (ch==EOF) break;
        putc(ch,out);
      }
      line++;
      pushback=getc(in);
      if (pushback=='\n' || pushback=='\r')
      { if (ch!=pushback) pushback=-1; }
    }
   
    if (iflag==1) break;
  }
 
  if (tokentype==5) { putc('\n',out); }
  if (strcasecmp(token,"end")==0) return 1;

return 0;
}

int parse_funct(int isfunct)
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c;

  infunct=isfunct; 

  tokentype=gettoken(token);
  fprintf(out,"function %s",token);

  tokentype=gettoken(token);
  strcpy(tokenpush,token);
  tokentypepush=tokentype;

  newtoken[0]=0;

  if (strcmp(token,"(")==0)
  { eval_funct(newtoken); fprintf(out,"(%s)",newtoken); }
    else
  { fprintf(out,"()"); }

  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  tokentype=gettoken(token);

  if (isfunct==1)
  {
    if (strcasecmp(token,"function")!=0)
    { error(token,"function","function"); }
  }
    else
  if (isfunct==2)
  {
    if (strcasecmp(token,"sub")!=0)
    { error(token,"sub","Sub"); }
  }
  infunct=0;

  return 0;
}

int is_endscript()
{
char token[1024];
int tokentype;
char molecule[4096];

  strcpy(molecule,"<");
  tokentype=gettoken(token);
  strcat(molecule,token);
  tokentype=gettoken(token);
  strcat(molecule,token);
  tokentype=gettoken(token);
  strcat(molecule,token);

  if (strcasecmp("</script>",molecule)==0)
  { return 1; }

  return 0;
}

int parse()
{
char token[1024];
int tokentype;

  copyhtml();

  while((tokentype=gettoken(token))!=0)
  {
    if (add_isnum==1 && php==3)
    { insert_isnum(); }

    if (tokentype==15)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==5)
    { fprintf(out,"\n"); }
      else
    if (tokentype==6)
    { 
      putc('?',out);
      putc('>',out);
      if (copyhtml()==1) return 0;
      continue;
    }
      else
    if (strcmp(token,"<")==0)
    {
      if (is_endscript()==1)
      {
        putc('?',out);
        putc('>',out);
        if (copyhtml()==1) return 0;
        continue;
      }
    }
      else
    if (tokentype==11)
    { eval_token(tokentype,token); }
      else
    { if (tokentype==2 || strcmp(token,"=")==0) eval_token(tokentype,token); }
  }

  return 1;
}

int copyfiles(char *sourcedir, char *targetdir)
{
DIR *dp_asp;
DIR *dp_php;
struct dirent *direntp;
struct stat statbuf;
char newdir[2048];
char filename_asp[1024];
char filename_php[1024];
int t;

  dp_asp=opendir(sourcedir);

  while ((direntp=readdir(dp_asp))!=NULL)
  {
    if (strcmp(direntp->d_name,".")==0) continue;
    if (strcmp(direntp->d_name,"..")==0) continue;

    sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);
    printf("working on file: %s\n",filename_asp);

    if (stat(filename_asp,&statbuf)==-1)
    {
      printf("Error: Couldn't stat file: %s\n\n",sourcedir);
      return 1;
    }

    if (statbuf.st_mode & S_IFDIR)
    {
      sprintf(filename_php,"%s/%s",targetdir,direntp->d_name);
      sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);

      dp_php=opendir(filename_php);

      if (dp_php==0)
      {
        /* sprintf(newdir,"mkdir -p \"%s\"",filename_php); */
        sprintf(newdir,"mkdir -p \"%s\"",filename_php);
	if (system(newdir)!=0)
        {
          printf("Error: Couldn't create dir: %s\n\n",filename_php);
	  return 1;
        }
      }
        else
      { closedir(dp_php); }

      if (copyfiles(filename_asp,filename_php)==1) return 1;
    }
      else
    {
      sprintf(filename_php,"%s/%s",targetdir,direntp->d_name);
      sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);

      t=strlen(filename_php);

      if (is_asp_filename(filename_asp))
      {
        if (php==3) { change_extension(filename_php,".php3"); }
          else
        if (php==4) { change_extension(filename_php,".php4"); }
          else
        { change_extension(filename_php,".php"); }

        convert(filename_asp,filename_php);

        /* strcat(newdir,arguments); */

/* Why the fuck did i leave those 5 lines in?

        if (system(newdir)!=0)
	{
          printf("Error: Couldn't copy file: %s\n\n",filename_asp);
	  return 1;
	}
*/
      }
        else
      if (extcmp(filename_php,".htm")==1 || extcmp(filename_php,".html")==1)
      {
        if (html==1 && extcmp(filename_php,".htm")==1)
        {
          change_extension(filename_php,".html");
        }

        convert(filename_asp,filename_php);

/*
        if (pngs==1)
	{ sprintf(newdir,"unipiss \"%s\" \"%s\"",filename_asp,filename_php); }
	  else
	{ sprintf(newdir,"cp \"%s\" \"%s\"",filename_asp,filename_php); }
        if (system(newdir)!=0)
	{
          printf("Error: Couldn't copy file: %s\n\n",filename_asp);
	  return 1;
	}
*/
      }
        else
      {
        if (pngs==1 && extcmp(filename_php,".gif")==1)
        {
          change_extension(filename_php,".png");
	  sprintf(newdir,"convert \"%s\" \"%s\"",filename_asp,filename_php);
        }
          else
	{ sprintf(newdir,"cp \"%s\" \"%s\"",filename_asp,filename_php); }

        if (system(newdir)!=0)
	{
          printf("Error: Couldn't copy file: %s\n\n",filename_asp);
	  return 1;
	}
      }
    }
  }

  closedir(dp_asp);
  return 0; 
}

void start (char *infile, char *outfile)
{
char sourcedir[2048];
char targetdir[2048];
char command[2048];
DIR *dp_asp;
DIR *dp_php;
int t;

/* if something looks redundant it's cause I took this code
   from GTKap2php and adapted it to work here :) */

  strcpy(sourcedir,infile);
  strcpy(targetdir,outfile);

  t=strlen(sourcedir);
  while (t>0 && sourcedir[t-1]=='/') { sourcedir[t-1]=0; t--; }
  t=strlen(targetdir);
  while (t>0 && targetdir[t-1]=='/') { targetdir[t-1]=0; t--; }

  dp_asp=opendir(sourcedir);
  if (dp_asp==0)
  {
    printf("Error: ASP Source Dir %s doesn't exist.\n\n",sourcedir);
    return;
  } 
  
  dp_php=opendir(targetdir);
  if (dp_php==0)
  {
    printf("Creating PHP target dir: %s\n\n",targetdir);

    sprintf(command,"mkdir -p \"%s\"",targetdir);
    t=system(command);

    if (t!=0)
    {
      printf("Error: Couldn't create PHP target dir\n\n");
      return;
    }

    // closedir(dp_php);
    dp_php=opendir(targetdir);

    if (dp_php==0)
    {
      printf("Error: Couldn't create PHP target dir\n");
      return;
    }
  }

  closedir(dp_asp);
  closedir(dp_php);

  printf("Source Dir: %s\n",sourcedir);
  printf("Target Dir: %s\n\n",targetdir);

  fflush(stdout);
/*  printf("copying files\n"); */

  if (copyfiles(sourcedir,targetdir)==1)
  { return; }

}

void convert(char *infile, char *outfile)
{
int t,tokentype,ch,lastchar;
char token[TOKENSIZE];
char temp[TOKENSIZE];

  add_session=0;
  objectsptr=0;
  infunct=0;
  functptr=0;
  indent=0;
  line=1;
  column=0;
  javascript=0;
  loopcount=0;

  if (strlen(outfile)==0)
  {
    strcpy(outfile,infile);
    t=strlen(outfile);
    while (outfile[t]!='.' && t>0) t--;
    if (t!=0) outfile[t]=0;

    if (php==0)
    { strcat(outfile,".php"); }
      else
    if (php==3)
    { strcat(outfile,".php3"); }
      else
    if (php==4)
    { strcat(outfile,".php4"); }
  }

  in=fopen(infile,"r");
  if (in==NULL)
  { printf("Error reading file: %s\n",infile); exit(1); }

  out=fopen(outfile,"w");
  if (out==NULL)
  { printf("Error opening output file: %s\n",outfile); exit(1); }

  printf("Opening file: %s\n",infile);
  printf("Creating file: %s\n\n",outfile);

  while((ch=getc(in))!=EOF)
  {
    if (lastchar=='<' && ch=='%')
    {
      while((tokentype=gettoken(token))!=0)
      {
	if (tokentype==6) break;
	if (strcasecmp(token,"isnumeric")==0) add_isnum=1;
	if (strcasecmp(token,"bof")==0) BOF=1;
	if (strcasecmp(token,"Function")==0)
	{
	  tokentype=gettoken(token);
	  strcpy(funct[functptr++],token);
	}
	  else
	if (strcasecmp(token,"Sub")==0)
	{
	  tokentype=gettoken(token);
	  strcpy(funct[functptr++],token);
	}

	if (strcasecmp(token,"session")==0) 
	{
	  add_session=1;
	  tokentype=gettoken(token);
	  if (strcmp(token,"(")==0)
	  {
	    tokentype=gettoken(token);

	    if (tokentype==10 || tokentype==11)
	    {
	      t=gettoken(temp);

	      if (strcmp(temp,")")==0)
	      {
                for (t=0; t<sessionptr; t++)
                {
                  if (strcmp(token,sessionpool[t])==0) break;
                }
              }
                else
              { t=0; }

              if (sessionptr==t)
              {
                strcpy(sessionpool[sessionptr++],token);
              }
            }
	  }
	}
      }
    }
    lastchar=ch;
  }

  fclose(in);

  for (t=0; t<80; t++)
  { objects[t][0]=0; }

  in=fopen(infile,"r");
  if (in==NULL)
  { printf("Error reading file: %s\n",infile); exit(1); }

  if (add_session==1) insert_session();

  parse();
/*
  if (parse()==1)
  { printf("Parse Error occurred\n"); }
*/
  putc('\n',out);

  printf("Done.\n");

  fclose(in);
  fclose(out);
}

int main(int argc, char *argv[])
{
char infile[2048];
char outfile[2048];
int supress=0,dirr=0,t;

  if (argc<2)
  {
    printf("Usage: asp2php <infile.asp> -o <output filename>\n");
    printf("          -dir (infile/outfile are dirs [READ DOCS!!])\n");
    printf("          -mysql -odbc -oracle -sybase -postgres (to select database)\n");
    printf("          -uid <database username>\n");
    printf("          -passwd <database password>\n");
    printf("          -database <database name or sid>\n");
    printf("          -address <database ip address or ip name>\n");
    printf("          -dsn <database ODBC dsn>\n");
    printf("          -pngs (for Unipiss mode [read docs])\n");
    printf("          -y2k (if your asp came from a non-y2k compliant NT Box)\n");
    printf("          -php3 or -php4 (change extension to .php3 or .php4 instead of .php)\n");
    printf("          -toupper (change all variables to uppercase)\n");
    printf("          -tolower (change all variables to lowercase)\n");
    printf("          -html (change all references from htm to html)\n");
    printf("          -includes (change #inludes to php requires())\n");
    printf("          -addextension .xxx (filenames with .xxx extension get asp2php translated)\n");
    printf("          -spacer (space things out more)\n\n");
    printf(VERSION);
    exit(1);
  }

  strcpy(infile,argv[1]);
  strcpy(outfile,"");

  global_uid[0]=0;
  global_passwd[0]=0;
  global_dsn[0]=0;
  global_database[0]=0;
  global_address[0]=0;

  strcpy(aspextensions[aspextensions_ptr++],".asp");
  strcpy(aspextensions[aspextensions_ptr++],".asa");

  for(t=2; t<argc; t++)
  {
    if (strcasecmp(argv[t],"-o")==0)
    { strcpy(outfile,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-mysql")==0)
    { database_type=0; }
      else
    if (strcasecmp(argv[t],"-odbc")==0)
    { database_type=1; }
      else
    if (strcasecmp(argv[t],"-oracle")==0)
    { database_type=2; }
      else
    if (strcasecmp(argv[t],"-sybase")==0)
    { database_type=3; }
      else
    if (strcasecmp(argv[t],"-postgres")==0)
    { database_type=4; }
      else
    if (strcasecmp(argv[t],"-uid")==0)
    { strcpy(global_uid,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-y2k")==0)
    { y2k=0; }
      else
    if (strcasecmp(argv[t],"-passwd")==0)
    { strcpy(global_passwd,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-database")==0)
    { strcpy(global_database,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-address")==0)
    { strcpy(global_address,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-dsn")==0)
    { strcpy(global_dsn,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-supress")==0)
    { supress=1; }
      else
    if (strcasecmp(argv[t],"-pngs")==0)
    { pngs=1; }
      else
    if (strcasecmp(argv[t],"-toupper")==0)
    { casesense=2; }
      else
    if (strcasecmp(argv[t],"-tolower")==0)
    { casesense=1; }
      else
    if (strcasecmp(argv[t],"-php3")==0)
    { php=3; }
      else
    if (strcasecmp(argv[t],"-php4")==0)
    { php=4; }
      else
    if (strcasecmp(argv[t],"-dir")==0)
    { dirr=1; }
      else
    if (strcasecmp(argv[t],"-html")==0)
    { html=1; }
      else
    if (strcasecmp(argv[t],"-spacer")==0)
    { spacer=1; }
      else
    if (strcasecmp(argv[t],"-requestvar")==0)
    { requestvar=1; }
      else
    if (strcasecmp(argv[t],"-includes")==0)
    { includes=1; }
      else
    if (strcasecmp(argv[t],"-addextension")==0)
    { strcpy(aspextensions[aspextensions_ptr++],argv[++t]); }
      else
    { printf("Unknown option: %s\n",argv[t]); }
  }

  if (supress==0)
  {
    printf("-----------------------------------------------------\n");
    printf(VERSION);
    printf("-----------------------------------------------------\n\n");
  }

  if (pngs==1)
  { printf("Unipiss mode: convert all gifs to pngs\n\n"); }

  if (dirr==1)
  { 
    printf("The following extensions will be treated as asp:\n\n");

    for (t=0; t<aspextensions_ptr; t++)
    {
      printf("-->  %s\n",aspextensions[t]);
    }

    if (outfile[0]==0)
    { printf("You must set the output dir with the -o option.\n\n"); }
      else
    { start(infile,outfile); }
  }
    else
  { convert(infile,outfile); }

  return 0;
}

