/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MutableStaticFields
extends BytecodeScanningDetector {
    LinkedList<XField> seen = new LinkedList();
    boolean publicClass;
    boolean zeroOnTOS;
    boolean emptyArrayOnTOS;
    boolean inStaticInitializer;
    String packageName;
    Set<String> readAnywhere = new HashSet<String>();
    Set<String> unsafeValue = new HashSet<String>();
    Set<String> interfaces = new HashSet<String>();
    Set<String> notFinal = new HashSet<String>();
    Set<String> outsidePackage = new HashSet<String>();
    Map<String, SourceLineAnnotation> firstFieldUse = new HashMap<String, SourceLineAnnotation>();
    private BugReporter bugReporter;

    static String extractPackage(String c) {
        int i = c.lastIndexOf(47);
        if (i < 0) {
            return "";
        }
        return c.substring(0, i);
    }

    static boolean mutableSignature(String sig) {
        return sig.equals("Ljava/util/Hashtable;") || sig.equals("Ljava/util/Date;") || sig.charAt(0) == '[';
    }

    public MutableStaticFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        boolean bl = this.publicClass = (flags & 1) != 0 && !this.getDottedClassName().startsWith("sun.");
        if ((flags & 0x200) != 0) {
            this.interfaces.add(this.getDottedClassName());
        }
        this.packageName = MutableStaticFields.extractPackage(this.getClassName());
    }

    public void visit(Method obj) {
        this.zeroOnTOS = false;
        this.inStaticInitializer = this.getMethodName().equals("<clinit>");
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 178: 
            case 179: {
                boolean samePackage = this.packageName.equals(MutableStaticFields.extractPackage(this.getClassConstantOperand()));
                boolean initOnly = seen == 178 || this.getClassName().equals(this.getClassConstantOperand()) && this.inStaticInitializer;
                boolean safeValue = seen == 178 || this.emptyArrayOnTOS || !MutableStaticFields.mutableSignature(this.getSigConstantOperand());
                String name = (this.getClassConstantOperand() + "." + this.getNameConstantOperand()).replace('/', '.');
                if (seen == 178) {
                    this.readAnywhere.add(name);
                }
                if (!samePackage) {
                    this.outsidePackage.add(name);
                }
                if (!initOnly) {
                    this.notFinal.add(name);
                }
                if (!safeValue) {
                    this.unsafeValue.add(name);
                }
                if (!this.inStaticInitializer || this.firstFieldUse.containsKey(name)) break;
                SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
                this.firstFieldUse.put(name, sla);
                break;
            }
            case 188: 
            case 189: {
                if (this.zeroOnTOS) {
                    this.emptyArrayOnTOS = true;
                }
                this.zeroOnTOS = false;
                return;
            }
            case 3: {
                this.zeroOnTOS = true;
                this.emptyArrayOnTOS = false;
                return;
            }
        }
        this.zeroOnTOS = false;
        this.emptyArrayOnTOS = false;
    }

    public void visit(Field obj) {
        boolean isArray;
        boolean isProtected;
        boolean isVolatile;
        boolean isStatic;
        super.visit(obj);
        int flags = obj.getAccessFlags();
        boolean bl = isStatic = (flags & 8) != 0;
        if (!isStatic) {
            return;
        }
        boolean bl2 = isVolatile = (flags & 0x40) != 0;
        if (isVolatile) {
            return;
        }
        boolean isFinal = (flags & 0x10) != 0;
        boolean isPublic = this.publicClass && (flags & 1) != 0;
        boolean bl3 = isProtected = this.publicClass && (flags & 4) != 0;
        if (!isPublic && !isProtected) {
            return;
        }
        boolean isHashtable = this.getFieldSig().equals("Ljava/util/Hashtable;");
        boolean bl4 = isArray = this.getFieldSig().charAt(0) == '[';
        if (isFinal && !isHashtable && !isArray) {
            return;
        }
        this.seen.add(XFactory.createXField((PreorderVisitor)this));
    }

    public void report() {
        Iterator i$ = this.seen.iterator();
        while (i$.hasNext()) {
            String bugType;
            XField f = (XField)i$.next();
            boolean isFinal = f.isFinal();
            String className = f.getClassName();
            String fieldSig = f.getSignature();
            String fieldName = f.getName();
            String name = className + "." + fieldName;
            boolean couldBeFinal = !isFinal && !this.notFinal.contains(name);
            boolean isPublic = f.isPublic();
            boolean couldBePackage = !this.outsidePackage.contains(name);
            boolean movedOutofInterface = couldBePackage && this.interfaces.contains(className);
            boolean isHashtable = fieldSig.equals("Ljava.util.Hashtable;");
            boolean isArray = fieldSig.charAt(0) == '[' && this.unsafeValue.contains(name);
            boolean isReadAnywhere = this.readAnywhere.contains(name);
            int priority = 2;
            if (isFinal && !isHashtable && !isArray) continue;
            if (movedOutofInterface) {
                bugType = "MS_OOI_PKGPROTECT";
            } else if (couldBePackage && couldBeFinal && (isHashtable || isArray)) {
                bugType = "MS_FINAL_PKGPROTECT";
            } else if (couldBeFinal && !isHashtable && !isArray) {
                bugType = "MS_SHOULD_BE_FINAL";
                if (fieldName.equals(fieldName.toUpperCase()) || fieldSig.charAt(0) == 'L') {
                    priority = 1;
                }
            } else if (couldBePackage) {
                bugType = "MS_PKGPROTECT";
            } else if (isHashtable) {
                bugType = "MS_MUTABLE_HASHTABLE";
                if (!isFinal) {
                    priority = 1;
                }
            } else if (isArray) {
                bugType = "MS_MUTABLE_ARRAY";
                if (fieldSig.indexOf("L") >= 0 || !isFinal) {
                    priority = 1;
                }
            } else if (!isFinal) {
                bugType = "MS_CANNOT_BE_FINAL";
            } else {
                throw new IllegalStateException("impossible");
            }
            if (!isReadAnywhere) {
                priority = 3;
            }
            BugInstance bug = new BugInstance((Detector)this, bugType, priority).addClass(className).addField(f);
            SourceLineAnnotation firstPC = this.firstFieldUse.get(className + "." + fieldName);
            if (firstPC != null) {
                bug.addSourceLine(firstPC);
            }
            this.bugReporter.reportBug(bug);
        }
    }
}

