/*
 * $Id: sstrings.c,v 1.11 1993/03/03 07:41:48 proj Exp $
 */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	Version 4.0
 */
#include "commonhd.h"
#include <stdio.h>
#include "wnn_os.h"
#include "wnn_string.h"

extern int eeuc_to_ieuc();
extern int ieuc_to_eeuc();

int 
wnn_sStrcpy(c , w)
register char *c;
register w_char *w;
{
    register int ret;

    ret = ieuc_to_eeuc(c, w, -1);
    c[ret] = '\0';
    return(ret);
}


int
wnn_Sstrcpy(w , c )
w_char *w;
unsigned char *c;
{
    register int ret;

    ret = eeuc_to_ieuc(w, c, -1)/sizeof(w_char);
    w[ret] = (w_char)0;
    return(ret);
}

#ifdef nodef
char *
wnn_Stos(c)
w_char *c;
{
    char *c1 = (char *)c;
    for(;*c;c++){
	if(ASCIIP(*c)){
	    *c1++ = *c;
	}else{
	    *c1++ = (*c << 8);
	    *c1++ = *c;
	}	
    }
    return((char *)c);
}
#endif

char *wnn_sStrncpy(s1,s2,n)
register char *s1;
register w_char *s2;
register int n;
{
    eeuc_to_ieuc(s1, s2, n/sizeof(w_char));
    return s1;
}

#ifdef CHINESE
int
wnn_Sstrcat(w , c )
w_char *w;
unsigned char *c;
{
    w_char *w0 = w;
    register int ret;

    if (!c || !*c) return(0);
    for ( ; *w; w++);
    ret = eeuc_to_ieuc(w, c, strlen(c))/sizeof(w_char);
    w[ret] = (w_char)0;
    ret += (w - w0);
    return(ret);
}
#endif
