/****************************************************************************
** $Id:  qt/ftpview.h   3.0.2   edited Oct 12 12:18 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef FTPVIEW_H
#define FTPVIEW_H

#include <qlistview.h>
#include <qvaluelist.h>
#include <qurlinfo.h>

class FtpViewItem : public QListViewItem
{
public:
    FtpViewItem( QListView *parent, const QUrlInfo &i );
    
    int compare( QListViewItem * i, int col, bool ascending ) const;
    QString text( int c ) const;
    const QPixmap* pixmap( int c ) const;
    
    QUrlInfo entryInfo() {
	return info;
    }
    
private:
    QUrlInfo info;
    
};

class FtpView : public QListView
{
    Q_OBJECT
    
public:
    FtpView( QWidget *parent );
    QValueList<QUrlInfo> selectedItems() const;
    
public slots:
    void slotInsertEntries( const QValueList<QUrlInfo> &info );
    
signals:
    void itemSelected( const QUrlInfo &info );
    
private slots:
    void slotSelected( QListViewItem *item );
    
};

#endif
