/*
 *  Copyright (C) 2004 Galeon Developers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* IMPORTANT: This file contains functions that require the old style
 * string api, i.e those that CAN'T use nsEmbedString
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define MOZILLA_INTERNAL_API
/***** BEGIN UNSAFE HEADERS ******/
#include <nsIPrintOptions.h>
#include <nsIDocument.h>
#include <nsIPresShell.h>
#include <nsICSSLoader.h>
#include <nsICSSStyleSheet.h>
#include <nsIScriptContext.h>
#include <nsIHTMLDocument.h>
#include <nsString.h>

#include "MozillaPrivate.h"
/***** END UNSAFE HEADERS ******/

#include <nsIServiceManager.h>
#undef MOZILLA_INTERNAL_API
#include <nsISupportsPrimitives.h>
#include <nsIInterfaceRequestorUtils.h>
#include <nsIPrintSettingsService.h>
#include <nsIScriptGlobalObject.h>
#include <nsISimpleEnumerator.h>
#include <nsIDocShell.h>
#include <nsIDOMWindow.h>
#include <nsIDOMNSDocument.h>
#include <nsCOMPtr.h>

#include "GaleonUtils.h"

GList *
MozillaPrivate::GetPrinterList (gint* defaultPrinterIndex)
{
	GList *printerList = NULL;
	nsresult rv = NS_OK;

	*defaultPrinterIndex = -1;

	nsCOMPtr<nsIPrintSettingsService> pss =
		do_GetService("@mozilla.org/gfx/printsettings-service;1", &rv);
	NS_ENSURE_SUCCESS(rv, NULL);

	nsCOMPtr<nsIPrintOptions> po = do_QueryInterface(pss, &rv);
	NS_ENSURE_SUCCESS(rv, NULL);

	nsXPIDLString defaultPrinter;
	rv = pss->GetDefaultPrinterName(getter_Copies(defaultPrinter));
	NS_ENSURE_SUCCESS(rv, NULL);

	nsCOMPtr<nsISimpleEnumerator> printers;
	rv = po->AvailablePrinters(getter_AddRefs(printers));
	NS_ENSURE_SUCCESS(rv, NULL);

	PRBool more = PR_FALSE;
	gint index = 0;

	for (printers->HasMoreElements(&more), index = 0;
	     more == PR_TRUE;
	     printers->HasMoreElements(&more), index++)
	{
		nsCOMPtr<nsISupports> i;
		rv = printers->GetNext(getter_AddRefs(i));
		NS_ENSURE_SUCCESS(rv, NULL);

		nsCOMPtr<nsISupportsString> printer = do_QueryInterface(i, &rv);
		NS_ENSURE_SUCCESS(rv, NULL);

		nsAutoString name;
		rv = printer->GetData(name);
		NS_ENSURE_SUCCESS(rv, NULL);

		if (defaultPrinter.Equals(name)) *defaultPrinterIndex = index;

		nsCOMPtr<nsIPrintSettings> ps;
		rv = pss->GetNewPrintSettings(getter_AddRefs(ps));
		NS_ENSURE_SUCCESS(rv, NULL);

		rv = pss->InitPrintSettingsFromPrinter(name.get(), ps);
		NS_ENSURE_SUCCESS(rv, NULL);

		// Name field isn't inited. How dumb can we get?
		rv = ps->SetPrinterName(name.get());
		NS_ENSURE_SUCCESS(rv, NULL);

		EmbedPrintInfo *info;
		GaleonUtils::PrintSettingsToEmbedPrintInfo(ps, &info);
		printerList = g_list_append(printerList, info);

		rv = printers->HasMoreElements(&more);
		NS_ENSURE_SUCCESS(rv, NULL);
	}

	return printerList;
}


nsresult
MozillaPrivate::LoadOverrideStyleSheet (nsIDocShell *aDocShell, nsIURI *aUri,
					nsIStyleSheet**aStyleSheet)
{
	nsresult rv;

	nsCOMPtr<nsIPresShell> presShell;
	aDocShell->GetPresShell (getter_AddRefs(presShell));
	NS_ENSURE_TRUE (presShell, NS_ERROR_FAILURE);
	
#ifdef HAVE_NSIPRESSHELL_DECOMTAMINATE
	nsIDocument *doc = presShell->GetDocument();
#else
	nsCOMPtr<nsIDocument> doc;
	presShell->GetDocument(getter_AddRefs(doc));
#endif
	NS_ENSURE_TRUE (doc, NS_ERROR_FAILURE);

#ifdef HAVE_NSIDOCUMENT_CSSLOADER
	nsICSSLoader *loader = doc->CSSLoader();
#else
	nsICSSLoader *loader = doc->GetCSSLoader();
#endif
	NS_ENSURE_TRUE (loader, NS_ERROR_FAILURE);

	/* load sheet */
	nsCOMPtr<nsICSSStyleSheet> sheet;
#ifdef HAVE_NSICSSLOADER_LOADSHEETSYNC
	rv = loader->LoadSheetSync(aUri, getter_AddRefs(sheet));
#else
	rv = loader->LoadAgentSheet(aUri, getter_AddRefs(sheet));
#endif
	NS_ENSURE_SUCCESS (rv, rv);

	/* catch stylesheet stuff and apply by appending it as a override
	 * sheet and enabling stylesheets */
	nsCOMPtr<nsIStyleSheet> styleSheet = do_QueryInterface(sheet);
	NS_ENSURE_TRUE (styleSheet, NS_ERROR_FAILURE);
	
	/* Override - Agent */
	presShell->AddOverrideStyleSheet(styleSheet);
	styleSheet->SetOwningDocument(doc);

	/* notify mozilla that stylesheets have changed */
	styleSheet->SetEnabled(PR_FALSE);
	styleSheet->SetEnabled(PR_TRUE);
	/* This is Right[tm], but not working for some people (?!)
	doc->SetStyleSheetDisabledState(styleSheet, PR_FALSE);
	*/

	NS_ADDREF(*aStyleSheet = styleSheet);
	
	return NS_OK;
}

nsresult
MozillaPrivate::RemoveOverrideStyleSheet (nsIDocShell *aDocShell,
					  nsIStyleSheet* aStyleSheet)
{
	nsCOMPtr<nsIPresShell> ps;
	aDocShell->GetPresShell (getter_AddRefs(ps));
	NS_ENSURE_TRUE (ps, NS_ERROR_FAILURE);

	/* remove it */
	ps->RemoveOverrideStyleSheet (aStyleSheet);
	aStyleSheet->SetEnabled(PR_FALSE);

	return NS_OK;
}


nsresult
MozillaPrivate::EvaluateJS (nsIDOMWindow *aDOMWindow, const nsAString &aScript,
			    nsAString& result, PRBool *isUndefined)
{
	nsresult rv;

	nsCOMPtr<nsIScriptGlobalObject> globalObject = 
		do_QueryInterface (aDOMWindow);
	NS_ENSURE_TRUE (globalObject, NS_ERROR_FAILURE);

	nsIScriptContext *context = globalObject->GetContext();
	NS_ENSURE_TRUE (context, NS_ERROR_FAILURE);

	context->SetProcessingScriptTag(PR_TRUE);

	*isUndefined = PR_TRUE;

	nsAutoString ret;
#ifdef HAVE_NSISCRIPTCONTEXT_NSASTRING_P
	rv = context->EvaluateString(aScript, nsnull, nsnull, nsnull,
				     0, nsnull, &ret, isUndefined);  
#else
	rv = context->EvaluateString(aScript, nsnull, nsnull, nsnull,
				     0, nsnull, ret, isUndefined);  
#endif

	context->SetProcessingScriptTag(PR_FALSE);
	NS_ENSURE_SUCCESS (rv, rv);
	
	result = ret;
	return NS_OK;
}


nsresult
MozillaPrivate::GetCompatibilityMode (nsIDOMNSDocument *aDoc,
				      EmbedPageRenderMode *aMode)
{
	nsCOMPtr<nsIHTMLDocument> htmlDoc = do_QueryInterface (aDoc);
	NS_ENSURE_TRUE(htmlDoc, NS_ERROR_FAILURE);

	nsCompatibility compat = htmlDoc->GetCompatibilityMode();
	switch (compat)
	{
	case eCompatibility_FullStandards:
		*aMode = EMBED_RENDER_FULL_STANDARDS;
		break;
	case eCompatibility_AlmostStandards:
		*aMode = EMBED_RENDER_ALMOST_STANDARDS;
		break;
	case eCompatibility_NavQuirks:
		*aMode = EMBED_RENDER_QUIRKS;
		break;
	}

	return NS_OK;
}

