/*
 * This file was generated by optab.pl - do not edit.
 */

#include "common-x86.h"
#include "operands-x86.h"
#include "optab-x86.h"
#include "regs-x86.h"

static struct x86OpCode Instruction_AAA[] = {
  { I_AAA, 0, { 0, 0, 0 }, "\x37", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_AAD[] = {
  { I_AAD, 0, { 0, 0, 0 }, "\xD5\x0A", 2, -1, { -1, -1, -1 } },
  { I_AAD, 1, { IMMEDIATE|BITS8, 0, 0 }, "\xD5", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_AAM[] = {
  { I_AAM, 0, { 0, 0, 0 }, "\xD4\x0A", 2, -1, { -1, -1, -1 } },
  { I_AAM, 1, { IMMEDIATE|BITS8, 0, 0 }, "\xD4", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_AAS[] = {
  { I_AAS, 0, { 0, 0, 0 }, "\x3F", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ADC[] = {
  { I_ADC, 2, { REGISTER|BITS8, IMMEDIATE|BITS8, 0 }, "\x14", 1, -1, { R_AL, -1, -1 } },
  { I_ADC, 2, { REGISTER|BITS16, IMMEDIATE|BITS16, 0 }, "\x15", 1, -1, { R_AX, -1, -1 } },
  { I_ADC, 2, { REGISTER|BITS32, IMMEDIATE|BITS32, 0 }, "\x15", 1, -1, { R_EAX, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 2, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 2, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 2, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 2, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 2, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS8, REG8, 0 }, "\x10", 1, REGRM, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS16, REG16, 0 }, "\x11", 1, REGRM, { -1, -1, -1 } },
  { I_ADC, 2, { REGMEM|BITS32, REG32, 0 }, "\x11", 1, REGRM, { -1, -1, -1 } },
  { I_ADC, 2, { REG8, REGMEM|BITS8, 0 }, "\x12", 1, REGRM, { -1, -1, -1 } },
  { I_ADC, 2, { REG16, REGMEM|BITS16, 0 }, "\x13", 1, REGRM, { -1, -1, -1 } },
  { I_ADC, 2, { REG32, REGMEM|BITS32, 0 }, "\x13", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ADD[] = {
  { I_ADD, 2, { REGISTER|BITS8, IMMEDIATE|BITS8, 0 }, "\x04", 1, -1, { R_AL, -1, -1 } },
  { I_ADD, 2, { REGISTER|BITS16, IMMEDIATE|BITS16, 0 }, "\x05", 1, -1, { R_AX, -1, -1 } },
  { I_ADD, 2, { REGISTER|BITS32, IMMEDIATE|BITS32, 0 }, "\x05", 1, -1, { R_EAX, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 0, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 0, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 0, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 0, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 0, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS8, REG8, 0 }, "\x00", 1, REGRM, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS16, REG16, 0 }, "\x01", 1, REGRM, { -1, -1, -1 } },
  { I_ADD, 2, { REGMEM|BITS32, REG32, 0 }, "\x01", 1, REGRM, { -1, -1, -1 } },
  { I_ADD, 2, { REG8, REGMEM|BITS8, 0 }, "\x02", 1, REGRM, { -1, -1, -1 } },
  { I_ADD, 2, { REG16, REGMEM|BITS16, 0 }, "\x03", 1, REGRM, { -1, -1, -1 } },
  { I_ADD, 2, { REG32, REGMEM|BITS32, 0 }, "\x03", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ADDPS[] = {
  { I_ADDPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x58", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_AND[] = {
  { I_AND, 2, { REGISTER|BITS8, IMMEDIATE|BITS8, 0 }, "\x24", 1, -1, { R_AL, -1, -1 } },
  { I_AND, 2, { REGISTER|BITS16, IMMEDIATE|BITS16, 0 }, "\x25", 1, -1, { R_AX, -1, -1 } },
  { I_AND, 2, { REGISTER|BITS32, IMMEDIATE|BITS32, 0 }, "\x25", 1, -1, { R_EAX, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 4, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 4, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 4, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 4, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 4, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS8, REG8, 0 }, "\x20", 1, REGRM, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS16, REG16, 0 }, "\x21", 1, REGRM, { -1, -1, -1 } },
  { I_AND, 2, { REGMEM|BITS32, REG32, 0 }, "\x21", 1, REGRM, { -1, -1, -1 } },
  { I_AND, 2, { REG8, REGMEM|BITS8, 0 }, "\x22", 1, REGRM, { -1, -1, -1 } },
  { I_AND, 2, { REG16, REGMEM|BITS16, 0 }, "\x23", 1, REGRM, { -1, -1, -1 } },
  { I_AND, 2, { REG32, REGMEM|BITS32, 0 }, "\x23", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ARPL[] = {
  { I_ARPL, 2, { REGMEM|BITS16, REG16, 0 }, "\x63", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BOUND[] = {
  { I_BOUND, 2, { REG16, MEMORY|BITS16, 0 }, "\x62", 1, REGRM, { -1, -1, -1 } },
  { I_BOUND, 2, { REG32, MEMORY|BITS32, 0 }, "\x62", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BSF[] = {
  { I_BSF, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\xBC", 2, REGRM, { -1, -1, -1 } },
  { I_BSF, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\xBC", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BSR[] = {
  { I_BSR, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\xBD", 2, REGRM, { -1, -1, -1 } },
  { I_BSR, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\xBD", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BSWAP[] = {
  { I_BSWAP, 1, { REG32, 0, 0 }, "\x0F\xC8", 2, REGCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BT[] = {
  { I_BT, 2, { REGMEM|BITS16, REG16, 0 }, "\x0F\xA3", 2, REGRM, { -1, -1, -1 } },
  { I_BT, 2, { REGMEM|BITS32, REG32, 0 }, "\x0F\xA3", 2, REGRM, { -1, -1, -1 } },
  { I_BT, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 4, { -1, -1, -1 } },
  { I_BT, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BTC[] = {
  { I_BTC, 2, { REGMEM|BITS16, REG16, 0 }, "\x0F\xBB", 2, REGRM, { -1, -1, -1 } },
  { I_BTC, 2, { REGMEM|BITS32, REG32, 0 }, "\x0F\xBB", 2, REGRM, { -1, -1, -1 } },
  { I_BTC, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 7, { -1, -1, -1 } },
  { I_BTC, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BTR[] = {
  { I_BTR, 2, { REGMEM|BITS16, REG16, 0 }, "\x0F\xB3", 2, REGRM, { -1, -1, -1 } },
  { I_BTR, 2, { REGMEM|BITS32, REG32, 0 }, "\x0F\xB3", 2, REGRM, { -1, -1, -1 } },
  { I_BTR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 6, { -1, -1, -1 } },
  { I_BTR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_BTS[] = {
  { I_BTS, 2, { REGMEM|BITS16, REG16, 0 }, "\x0F\xAB", 2, REGRM, { -1, -1, -1 } },
  { I_BTS, 2, { REGMEM|BITS32, REG32, 0 }, "\x0F\xAB", 2, REGRM, { -1, -1, -1 } },
  { I_BTS, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 5, { -1, -1, -1 } },
  { I_BTS, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x0F\xBA", 2, 5, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CALL[] = {
  { I_CALL, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\xE8", 1, -1, { -1, -1, -1 } },
  { I_CALL, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\xE8", 1, -1, { -1, -1, -1 } },
  { I_CALL, 1, { REGMEM|BITS16|NEAR, 0, 0 }, "\xFF", 1, 2, { -1, -1, -1 } },
  { I_CALL, 1, { REGMEM|BITS32|NEAR, 0, 0 }, "\xFF", 1, 2, { -1, -1, -1 } },
  { I_CALL, 1, { SEG16|OFF16|FAR, 0, 0 }, "\x9A", 1, -1, { -1, -1, -1 } },
  { I_CALL, 1, { SEG16|OFF32|BITS32|FAR, 0, 0 }, "\x9A", 1, -1, { -1, -1, -1 } },
  { I_CALL, 1, { REGMEM|BITS16|FAR, 0, 0 }, "\xFF", 1, 3, { -1, -1, -1 } },
  { I_CALL, 1, { REGMEM|BITS32|FAR, 0, 0 }, "\xFF", 1, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CBW[] = {
  { I_CBW, 0, { 0, 0, 0 }, "\x98", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CDQ[] = {
  { I_CDQ, 0, { BITS32, 0, 0 }, "\x99", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CLC[] = {
  { I_CLC, 0, { 0, 0, 0 }, "\xF8", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CLD[] = {
  { I_CLD, 0, { 0, 0, 0 }, "\xFC", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CLI[] = {
  { I_CLI, 0, { 0, 0, 0 }, "\xFA", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CLTS[] = {
  { I_CLTS, 0, { 0, 0, 0 }, "\x0F\x06", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMC[] = {
  { I_CMC, 0, { 0, 0, 0 }, "\xF5", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVA[] = {
  { I_CMOVA, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x47", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVA, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x47", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVC[] = {
  { I_CMOVC, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x42", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVC, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x42", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVE[] = {
  { I_CMOVE, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x44", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVE, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x44", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVG[] = {
  { I_CMOVG, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x4F", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVG, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x4F", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVL[] = {
  { I_CMOVL, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x4C", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVL, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x4C", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVLE[] = {
  { I_CMOVLE, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x4E", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVLE, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x4E", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNA[] = {
  { I_CMOVNA, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x46", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNA, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x46", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNC[] = {
  { I_CMOVNC, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x43", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNC, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x43", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNE[] = {
  { I_CMOVNE, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x45", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNE, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x45", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNL[] = {
  { I_CMOVNL, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x4D", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNL, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x4D", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNO[] = {
  { I_CMOVNO, 2, { REG16, REGMEM|BITS32, 0 }, "\x0F\x41", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNO, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x41", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNP[] = {
  { I_CMOVNP, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x4B", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNP, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x4B", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVNS[] = {
  { I_CMOVNS, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x49", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVNS, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x49", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVO[] = {
  { I_CMOVO, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x40", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVO, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x40", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVP[] = {
  { I_CMOVP, 2, { REG16, REGMEM|BITS32, 0 }, "\x0F\x4A", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVP, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x4A", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMOVS[] = {
  { I_CMOVS, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x48", 2, REGRM, { -1, -1, -1 } },
  { I_CMOVS, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x48", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMP[] = {
  { I_CMP, 2, { REGISTER|BITS8, IMMEDIATE|BITS8, 0 }, "\x3C", 1, -1, { R_AL, -1, -1 } },
  { I_CMP, 2, { REGISTER|BITS16, IMMEDIATE|BITS16, 0 }, "\x3D", 1, -1, { R_AX, -1, -1 } },
  { I_CMP, 2, { REGISTER|BITS32, IMMEDIATE|BITS32, 0 }, "\x3D", 1, -1, { R_EAX, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 7, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 7, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 7, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 7, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 7, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS8, REG8, 0 }, "\x38", 1, REGRM, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS16, REG16, 0 }, "\x39", 1, REGRM, { -1, -1, -1 } },
  { I_CMP, 2, { REGMEM|BITS32, REG32, 0 }, "\x39", 1, REGRM, { -1, -1, -1 } },
  { I_CMP, 2, { REG8, REGMEM|BITS8, 0 }, "\x3A", 1, REGRM, { -1, -1, -1 } },
  { I_CMP, 2, { REG16, REGMEM|BITS16, 0 }, "\x3B", 1, REGRM, { -1, -1, -1 } },
  { I_CMP, 2, { REG32, REGMEM|BITS32, 0 }, "\x3B", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMPSB[] = {
  { I_CMPSB, 0, { 0, 0, 0 }, "\xA6", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMPSD[] = {
  { I_CMPSD, 0, { BITS32, 0, 0 }, "\xA7", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMPSW[] = {
  { I_CMPSW, 0, { 0, 0, 0 }, "\xA7", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMPXCHG[] = {
  { I_CMPXCHG, 2, { REGMEM|BITS8, REG8, 0 }, "\x0F\xB0", 2, REGRM, { -1, -1, -1 } },
  { I_CMPXCHG, 2, { REGMEM|BITS16, REG16, 0 }, "\x0F\xB1", 2, REGRM, { -1, -1, -1 } },
  { I_CMPXCHG, 2, { REGMEM|BITS32, REG32, 0 }, "\x0F\xB1", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CMPXCHG8B[] = {
  { I_CMPXCHG8B, 1, { MEMORY|BITS64, 0, 0 }, "\x0F\xC7", 2, 1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CPUID[] = {
  { I_CPUID, 0, { 0, 0, 0 }, "\x0F\xA2", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CWD[] = {
  { I_CWD, 0, { 0, 0, 0 }, "\x99", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_CWDE[] = {
  { I_CWDE, 0, { BITS32, 0, 0 }, "\x98", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_DAA[] = {
  { I_DAA, 0, { 0, 0, 0 }, "\x27", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_DAS[] = {
  { I_DAS, 0, { 0, 0, 0 }, "\x2F", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_DEC[] = {
  { I_DEC, 1, { REGMEM|BITS8, 0, 0 }, "\xFE", 1, 1, { -1, -1, -1 } },
  { I_DEC, 1, { REGMEM|BITS16, 0, 0 }, "\xFF", 1, 1, { -1, -1, -1 } },
  { I_DEC, 1, { REGMEM|BITS32, 0, 0 }, "\xFF", 1, 1, { -1, -1, -1 } },
  { I_DEC, 1, { REG16, 0, 0 }, "\x48", 1, REGCODE, { -1, -1, -1 } },
  { I_DEC, 1, { REG32, 0, 0 }, "\x48", 1, REGCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_DIV[] = {
  { I_DIV, 1, { REGMEM|BITS8, 0, 0 }, "\xF6", 1, 6, { -1, -1, -1 } },
  { I_DIV, 1, { REGMEM|BITS16, 0, 0 }, "\xF7", 1, 6, { -1, -1, -1 } },
  { I_DIV, 1, { REGMEM|BITS32, 0, 0 }, "\xF7", 1, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_EMMS[] = {
  { I_EMMS, 0, { 0, 0, 0 }, "\x0F\x77", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ENTER[] = {
  { I_ENTER, 2, { IMMEDIATE|BITS16, IMMEDIATE|BITS8, 0 }, "\xC8", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_F2XM1[] = {
  { I_F2XM1, 0, { 0, 0, 0 }, "\xD9\xF0", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FABS[] = {
  { I_FABS, 0, { 0, 0, 0 }, "\xD9\xE1", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FADD[] = {
  { I_FADD, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 0, { R_ST0, -1, -1 } },
  { I_FADD, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 0, { R_ST0, -1, -1 } },
  { I_FADD, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xC0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { I_FADD, 2, { REG_FPU, REGISTER, 0 }, "\xDC\xC0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FADDP[] = {
  { I_FADDP, 2, { REG_FPU, REGISTER, 0 }, "\xDE\xC0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FBLD[] = {
  { I_FBLD, 2, { REGISTER, MEMORY|BITS80, 0 }, "\xDF", 1, 4, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FBSTP[] = {
  { I_FBSTP, 2, { MEMORY|BITS80, REGISTER, 0 }, "\xDF", 1, 6, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCHS[] = {
  { I_FCHS, 1, { REGISTER, 0, 0 }, "\xD9\xE0", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCLEX[] = {
  { I_FCLEX, 0, { 0, 0, 0 }, "\x9B\xDB\xE2", 3, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVB[] = {
  { I_FCMOVB, 2, { REGISTER, REG_FPU, 0 }, "\xDA\xC0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVBE[] = {
  { I_FCMOVBE, 2, { REGISTER, REG_FPU, 0 }, "\xDA\xD0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVE[] = {
  { I_FCMOVE, 2, { REGISTER, REG_FPU, 0 }, "\xDA\xC8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVNB[] = {
  { I_FCMOVNB, 2, { REGISTER, REG_FPU, 0 }, "\xDB\xC0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVNBE[] = {
  { I_FCMOVNBE, 2, { REGISTER, REG_FPU, 0 }, "\xDB\xD0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVNE[] = {
  { I_FCMOVNE, 2, { REGISTER, REG_FPU, 0 }, "\xDB\xC8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVNU[] = {
  { I_FCMOVNU, 2, { REGISTER, REG_FPU, 0 }, "\xDB\xD8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCMOVU[] = {
  { I_FCMOVU, 2, { REGISTER, REG_FPU, 0 }, "\xDA\xD8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCOM[] = {
  { I_FCOM, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 2, { R_ST0, -1, -1 } },
  { I_FCOM, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 2, { R_ST0, -1, -1 } },
  { I_FCOM, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xD0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCOMI[] = {
  { I_FCOMI, 2, { REGISTER, REG_FPU, 0 }, "\xDB\xF0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCOMIP[] = {
  { I_FCOMIP, 2, { REGISTER, REG_FPU, 0 }, "\xDF\xF0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCOMP[] = {
  { I_FCOMP, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 3, { R_ST0, -1, -1 } },
  { I_FCOMP, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 3, { R_ST0, -1, -1 } },
  { I_FCOMP, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xD8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCOMPP[] = {
  { I_FCOMPP, 2, { REGISTER, REGISTER, 0 }, "\xDE\xD9", 2, -1, { R_ST1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FCOS[] = {
  { I_FCOS, 1, { REGISTER, 0, 0 }, "\xD9\xFF", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FDECSTP[] = {
  { I_FDECSTP, 0, { 0, 0, 0 }, "\xD9\xF6", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FDIV[] = {
  { I_FDIV, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 6, { R_ST0, -1, -1 } },
  { I_FDIV, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 6, { R_ST0, -1, -1 } },
  { I_FDIV, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xF0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { I_FDIV, 2, { REG_FPU, REGISTER, 0 }, "\xDC\xF8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FDIVP[] = {
  { I_FDIVP, 2, { REG_FPU, REGISTER, 0 }, "\xDE\xF8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FDIVR[] = {
  { I_FDIVR, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 7, { R_ST0, -1, -1 } },
  { I_FDIVR, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 7, { R_ST0, -1, -1 } },
  { I_FDIVR, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xF8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { I_FDIVR, 2, { REG_FPU, REGISTER, 0 }, "\xDC\xF0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FDIVRP[] = {
  { I_FDIVRP, 2, { REG_FPU, REGISTER, 0 }, "\xDE\xF0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FFREE[] = {
  { I_FFREE, 1, { REG_FPU, 0, 0 }, "\xDD\xC0", 2, FPUCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FIADD[] = {
  { I_FIADD, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 0, { R_ST0, -1, -1 } },
  { I_FIADD, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 0, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FICOM[] = {
  { I_FICOM, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 2, { R_ST0, -1, -1 } },
  { I_FICOM, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 2, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FICOMP[] = {
  { I_FICOMP, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 3, { R_ST0, -1, -1 } },
  { I_FICOMP, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 3, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FIDIV[] = {
  { I_FIDIV, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 6, { R_ST0, -1, -1 } },
  { I_FIDIV, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 6, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FIDIVR[] = {
  { I_FIDIVR, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 7, { R_ST0, -1, -1 } },
  { I_FIDIVR, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 7, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FILD[] = {
  { I_FILD, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDF", 1, 0, { R_ST0, -1, -1 } },
  { I_FILD, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDB", 1, 0, { R_ST0, -1, -1 } },
  { I_FILD, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDF", 1, 5, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FIMUL[] = {
  { I_FIMUL, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 1, { R_ST0, -1, -1 } },
  { I_FIMUL, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FINCSTP[] = {
  { I_FINCSTP, 0, { 0, 0, 0 }, "\xD9\xF7", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FINIT[] = {
  { I_FINIT, 0, { 0, 0, 0 }, "\x9B\xDB\xE3", 3, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FIST[] = {
  { I_FIST, 2, { MEMORY|BITS16, REGISTER, 0 }, "\xDF", 1, 2, { -1, R_ST0, -1 } },
  { I_FIST, 2, { MEMORY|BITS32, REGISTER, 0 }, "\xDB", 1, 2, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FISTP[] = {
  { I_FISTP, 2, { MEMORY|BITS16, REGISTER, 0 }, "\xDF", 1, 3, { -1, R_ST0, -1 } },
  { I_FISTP, 2, { MEMORY|BITS32, REGISTER, 0 }, "\xDB", 1, 3, { -1, R_ST0, -1 } },
  { I_FISTP, 2, { MEMORY|BITS64, REGISTER, 0 }, "\xDF", 1, 7, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FISUB[] = {
  { I_FISUB, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 4, { R_ST0, -1, -1 } },
  { I_FISUB, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 4, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FISUBR[] = {
  { I_FISUBR, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xDA", 1, 5, { R_ST0, -1, -1 } },
  { I_FISUBR, 2, { REGISTER, MEMORY|BITS16, 0 }, "\xDE", 1, 5, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLD[] = {
  { I_FLD, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD9", 1, 0, { R_ST0, -1, -1 } },
  { I_FLD, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDD", 1, 0, { R_ST0, -1, -1 } },
  { I_FLD, 2, { REGISTER, MEMORY|BITS80, 0 }, "\xDB", 1, 5, { R_ST0, -1, -1 } },
  { I_FLD, 1, { REG_FPU, 0, 0 }, "\xD9\xC0", 2, FPUCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLD1[] = {
  { I_FLD1, 1, { REGISTER, 0, 0 }, "\xD9\xE8", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDCW[] = {
  { I_FLDCW, 1, { REGMEM, 0, 0 }, "\xD9", 1, 5, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDENV[] = {
  { I_FLDENV, 1, { REGMEM, 0, 0 }, "\xD9", 1, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDL2E[] = {
  { I_FLDL2E, 1, { REGISTER, 0, 0 }, "\xD9\xEA", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDL2T[] = {
  { I_FLDL2T, 1, { REGISTER, 0, 0 }, "\xD9\xE9", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDLG2[] = {
  { I_FLDLG2, 1, { REGISTER, 0, 0 }, "\xD9\xEC", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDLN2[] = {
  { I_FLDLN2, 1, { REGISTER, 0, 0 }, "\xD9\xED", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDPI[] = {
  { I_FLDPI, 1, { REGISTER, 0, 0 }, "\xD9\xEB", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FLDZ[] = {
  { I_FLDZ, 1, { REGISTER, 0, 0 }, "\xD9\xEE", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FMUL[] = {
  { I_FMUL, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 1, { R_ST0, -1, -1 } },
  { I_FMUL, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 1, { R_ST0, -1, -1 } },
  { I_FMUL, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xC8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { I_FMUL, 2, { REG_FPU, REGISTER, 0 }, "\xDC\xC8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FMULP[] = {
  { I_FMULP, 2, { REG_FPU, REGISTER, 0 }, "\xDE\xC8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNCLEX[] = {
  { I_FNCLEX, 0, { 0, 0, 0 }, "\xDB\xE2", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNINIT[] = {
  { I_FNINIT, 0, { 0, 0, 0 }, "\xDB\xE3", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNOP[] = {
  { I_FNOP, 0, { 0, 0, 0 }, "\xD9\xD0", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNSAVE[] = {
  { I_FNSAVE, 2, { REGISTER, MEMORY, 0 }, "\xDD", 1, 6, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNSTCW[] = {
  { I_FNSTCW, 1, { MEMORY, 0, 0 }, "\xD9", 1, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNSTENV[] = {
  { I_FNSTENV, 1, { MEMORY, 0, 0 }, "\xD9", 1, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FNSTSW[] = {
  { I_FNSTSW, 1, { MEMORY|BITS16, 0, 0 }, "\xDD", 1, 7, { -1, -1, -1 } },
  { I_FNSTSW, 1, { REGISTER|BITS16, 0, 0 }, "\xDF\xE0", 2, -1, { R_AX, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FPATAN[] = {
  { I_FPATAN, 1, { REGISTER, 0, 0 }, "\xD9\xF3", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FPREM[] = {
  { I_FPREM, 1, { REGISTER, 0, 0 }, "\xD9\xF8", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FPREM1[] = {
  { I_FPREM1, 1, { REGISTER, 0, 0 }, "\xD9\xF5", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FPTAN[] = {
  { I_FPTAN, 1, { REGISTER, 0, 0 }, "\xD9\xF2", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FRNDINT[] = {
  { I_FRNDINT, 1, { REGISTER, 0, 0 }, "\xD9\xFC", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FRSTOR[] = {
  { I_FRSTOR, 2, { REGISTER, MEMORY, 0 }, "\xDD", 1, 4, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSAVE[] = {
  { I_FSAVE, 2, { REGISTER, MEMORY, 0 }, "\x9B\xDD", 2, 6, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSCALE[] = {
  { I_FSCALE, 1, { REGISTER, 0, 0 }, "\xD9\xFD", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSIN[] = {
  { I_FSIN, 1, { REGISTER, 0, 0 }, "\xD9\xFE", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSINCOS[] = {
  { I_FSINCOS, 1, { REGISTER, 0, 0 }, "\xD9\xFB", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSQRT[] = {
  { I_FSQRT, 1, { REGISTER, 0, 0 }, "\xD9\xFA", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FST[] = {
  { I_FST, 2, { MEMORY|BITS32, REGISTER, 0 }, "\xD9", 1, 2, { -1, R_ST0, -1 } },
  { I_FST, 2, { MEMORY|BITS64, REGISTER, 0 }, "\xDD", 1, 2, { -1, R_ST0, -1 } },
  { I_FST, 2, { REG_FPU, REGISTER, 0 }, "\xDD\xD0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSTCW[] = {
  { I_FSTCW, 1, { MEMORY, 0, 0 }, "\x9B\xD9", 2, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSTENV[] = {
  { I_FSTENV, 1, { MEMORY, 0, 0 }, "\x9B\xD9", 2, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSTP[] = {
  { I_FSTP, 2, { MEMORY|BITS32, REGISTER, 0 }, "\xD9", 1, 3, { -1, R_ST0, -1 } },
  { I_FSTP, 2, { MEMORY|BITS64, REGISTER, 0 }, "\xDD", 1, 3, { -1, R_ST0, -1 } },
  { I_FSTP, 2, { MEMORY|BITS80, REGISTER, 0 }, "\xDB", 1, 7, { -1, R_ST0, -1 } },
  { I_FSTP, 2, { REG_FPU, REGISTER, 0 }, "\xDD\xD8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSTSW[] = {
  { I_FSTSW, 1, { MEMORY, 0, 0 }, "\x9B\xDD", 2, 7, { -1, -1, -1 } },
  { I_FSTSW, 1, { REGISTER|BITS16, 0, 0 }, "\x9B\xDF\xE0", 3, -1, { R_AX, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSUB[] = {
  { I_FSUB, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 4, { R_ST0, -1, -1 } },
  { I_FSUB, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 4, { R_ST0, -1, -1 } },
  { I_FSUB, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xE0", 2, FPUCODE, { R_ST0, -1, -1 } },
  { I_FSUB, 2, { REG_FPU, REGISTER, 0 }, "\xDC\xE8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSUBP[] = {
  { I_FSUBP, 2, { REG_FPU, REGISTER, 0 }, "\xDE\xE8", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSUBR[] = {
  { I_FSUBR, 2, { REGISTER, MEMORY|BITS32, 0 }, "\xD8", 1, 5, { R_ST0, -1, -1 } },
  { I_FSUBR, 2, { REGISTER, MEMORY|BITS64, 0 }, "\xDC", 1, 5, { R_ST0, -1, -1 } },
  { I_FSUBR, 2, { REGISTER, REG_FPU, 0 }, "\xD8\xE8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { I_FSUBR, 2, { REG_FPU, REGISTER, 0 }, "\xDC\xE0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FSUBRP[] = {
  { I_FSUBRP, 2, { REG_FPU, REGISTER, 0 }, "\xDE\xE0", 2, FPUCODE, { -1, R_ST0, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FTST[] = {
  { I_FTST, 1, { REGISTER, 0, 0 }, "\xD9\xE4", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FUCOM[] = {
  { I_FUCOM, 1, { REG_FPU, 0, 0 }, "\xDD\xE0", 2, FPUCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FUCOMI[] = {
  { I_FUCOMI, 2, { REGISTER, REG_FPU, 0 }, "\xDB\xE8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FUCOMIP[] = {
  { I_FUCOMIP, 2, { REGISTER, REG_FPU, 0 }, "\xDF\xE8", 2, FPUCODE, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FUCOMP[] = {
  { I_FUCOMP, 1, { REG_FPU, 0, 0 }, "\xDD\xE8", 2, FPUCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FUCOMPP[] = {
  { I_FUCOMPP, 1, { REGISTER, 0, 0 }, "\xDA\xE9", 2, -1, { R_ST1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FXAM[] = {
  { I_FXAM, 1, { REGISTER, 0, 0 }, "\xD9\xE5", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FXCH[] = {
  { I_FXCH, 1, { REG_FPU, 0, 0 }, "\xD9\xC8", 2, FPUCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FXTRACT[] = {
  { I_FXTRACT, 1, { REGISTER, 0, 0 }, "\xD9\xF4", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FYL2X[] = {
  { I_FYL2X, 1, { REGISTER, 0, 0 }, "\xD9\xF1", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_FYL2XP1[] = {
  { I_FYL2XP1, 1, { REGISTER, 0, 0 }, "\xD9\xF9", 2, -1, { R_ST0, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_HLT[] = {
  { I_HLT, 0, { 0, 0, 0 }, "\xF4", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_IDIV[] = {
  { I_IDIV, 1, { REGMEM|BITS8, 0, 0 }, "\xF6", 1, 7, { -1, -1, -1 } },
  { I_IDIV, 1, { REGMEM|BITS16, 0, 0 }, "\xF7", 1, 7, { -1, -1, -1 } },
  { I_IDIV, 1, { REGMEM|BITS32, 0, 0 }, "\xF7", 1, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_IMUL[] = {
  { I_IMUL, 1, { REGMEM|BITS8, 0, 0 }, "\xF6", 1, 5, { -1, -1, -1 } },
  { I_IMUL, 1, { REGMEM|BITS16, 0, 0 }, "\xF7", 1, 5, { -1, -1, -1 } },
  { I_IMUL, 1, { REGMEM|BITS32, 0, 0 }, "\xF7", 1, 5, { -1, -1, -1 } },
  { I_IMUL, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\xAF", 2, REGRM, { -1, -1, -1 } },
  { I_IMUL, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\xAF", 2, REGRM, { -1, -1, -1 } },
  { I_IMUL, 3, { REG16, REGMEM|BITS16, IMMEDIATE|BITS8 }, "\x6B", 1, REGRM, { -1, -1, -1 } },
  { I_IMUL, 3, { REG32, REGMEM|BITS32, IMMEDIATE|BITS8 }, "\x6B", 1, REGRM, { -1, -1, -1 } },
  { I_IMUL, 3, { REG16, REGMEM|BITS16, IMMEDIATE|BITS16 }, "\x69", 1, REGRM, { -1, -1, -1 } },
  { I_IMUL, 3, { REG32, REGMEM|BITS32, IMMEDIATE|BITS32 }, "\x69", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_IN[] = {
  { I_IN, 2, { REGISTER|BITS8, IMMEDIATE|BITS8, 0 }, "\xE4", 1, -1, { R_AL, -1, -1 } },
  { I_IN, 2, { REGISTER|BITS16, IMMEDIATE|BITS8, 0 }, "\xE5", 1, -1, { R_AX, -1, -1 } },
  { I_IN, 2, { REGISTER|BITS32, IMMEDIATE|BITS8, 0 }, "\xE5", 1, -1, { R_EAX, -1, -1 } },
  { I_IN, 2, { REGISTER|BITS8, REGISTER|BITS16, 0 }, "\xEC", 1, -1, { R_AL, R_DX, -1 } },
  { I_IN, 2, { REGISTER|BITS16, REGISTER|BITS16, 0 }, "\xED", 1, -1, { R_AX, R_DX, -1 } },
  { I_IN, 2, { REGISTER|BITS32, REGISTER|BITS16, 0 }, "\xED", 1, -1, { R_EAX, R_DX, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INC[] = {
  { I_INC, 1, { REGMEM|BITS8, 0, 0 }, "\xFE", 1, 0, { -1, -1, -1 } },
  { I_INC, 1, { REGMEM|BITS16, 0, 0 }, "\xFF", 1, 0, { -1, -1, -1 } },
  { I_INC, 1, { REGMEM|BITS32, 0, 0 }, "\xFF", 1, 0, { -1, -1, -1 } },
  { I_INC, 1, { REG16, 0, 0 }, "\x40", 1, REGCODE, { -1, -1, -1 } },
  { I_INC, 1, { REG32, 0, 0 }, "\x40", 1, REGCODE, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INSB[] = {
  { I_INSB, 0, { 0, 0, 0 }, "\x6C", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INSD[] = {
  { I_INSD, 0, { BITS32, 0, 0 }, "\x6D", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INSW[] = {
  { I_INSW, 0, { 0, 0, 0 }, "\x6D", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INT[] = {
  { I_INT, 1, { IMMEDIATE|BITS8, 0, 0 }, "\xCD", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INT3[] = {
  { I_INT3, 0, { 0, 0, 0 }, "\xCC", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INTO[] = {
  { I_INTO, 0, { 0, 0, 0 }, "\xCE", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INVD[] = {
  { I_INVD, 0, { 0, 0, 0 }, "\x0F\x08", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_INVLPG[] = {
  { I_INVLPG, 1, { MEMORY, 0, 0 }, "\x0F\x01", 2, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_IRET[] = {
  { I_IRET, 0, { 0, 0, 0 }, "\xCF", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_IRETD[] = {
  { I_IRETD, 0, { BITS32, 0, 0 }, "\xCF", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JA[] = {
  { I_JA, 1, { RELATIVE|BITS8, 0, 0 }, "\x77", 1, -1, { -1, -1, -1 } },
  { I_JA, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x87", 2, -1, { -1, -1, -1 } },
  { I_JA, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x87", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JC[] = {
  { I_JC, 1, { RELATIVE|BITS8, 0, 0 }, "\x72", 1, -1, { -1, -1, -1 } },
  { I_JC, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x82", 2, -1, { -1, -1, -1 } },
  { I_JC, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x82", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JCXZ[] = {
  { I_JCXZ, 1, { RELATIVE|BITS8, 0, 0 }, "\xE3", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JE[] = {
  { I_JE, 1, { RELATIVE|BITS8, 0, 0 }, "\x74", 1, -1, { -1, -1, -1 } },
  { I_JE, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x84", 2, -1, { -1, -1, -1 } },
  { I_JE, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x84", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JG[] = {
  { I_JG, 1, { RELATIVE|BITS8, 0, 0 }, "\x7F", 1, -1, { -1, -1, -1 } },
  { I_JG, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x8F", 2, -1, { -1, -1, -1 } },
  { I_JG, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x8F", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JL[] = {
  { I_JL, 1, { RELATIVE|BITS8, 0, 0 }, "\x7C", 1, -1, { -1, -1, -1 } },
  { I_JL, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x8C", 2, -1, { -1, -1, -1 } },
  { I_JL, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x8C", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JLE[] = {
  { I_JLE, 1, { RELATIVE|BITS8, 0, 0 }, "\x7E", 1, -1, { -1, -1, -1 } },
  { I_JLE, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x8E", 2, -1, { -1, -1, -1 } },
  { I_JLE, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x8E", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JMP[] = {
  { I_JMP, 1, { RELATIVE|BITS8|SHORT, 0, 0 }, "\xEB", 1, -1, { -1, -1, -1 } },
  { I_JMP, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\xE9", 1, -1, { -1, -1, -1 } },
  { I_JMP, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\xE9", 1, -1, { -1, -1, -1 } },
  { I_JMP, 1, { REGMEM|BITS16|NEAR, 0, 0 }, "\xFF", 1, 4, { -1, -1, -1 } },
  { I_JMP, 1, { REGMEM|BITS32|NEAR, 0, 0 }, "\xFF", 1, 4, { -1, -1, -1 } },
  { I_JMP, 1, { SEG16|OFF16|FAR, 0, 0 }, "\xEA", 1, -1, { -1, -1, -1 } },
  { I_JMP, 1, { SEG16|OFF32|BITS32|FAR, 0, 0 }, "\xEA", 1, -1, { -1, -1, -1 } },
  { I_JMP, 1, { REGMEM|BITS16|FAR, 0, 0 }, "\xFF", 1, 5, { -1, -1, -1 } },
  { I_JMP, 1, { REGMEM|BITS32|FAR, 0, 0 }, "\xFF", 1, 5, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNA[] = {
  { I_JNA, 1, { RELATIVE|BITS8, 0, 0 }, "\x76", 1, -1, { -1, -1, -1 } },
  { I_JNA, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x86", 2, -1, { -1, -1, -1 } },
  { I_JNA, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x86", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNC[] = {
  { I_JNC, 1, { RELATIVE|BITS8, 0, 0 }, "\x73", 1, -1, { -1, -1, -1 } },
  { I_JNC, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x83", 2, -1, { -1, -1, -1 } },
  { I_JNC, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x83", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNE[] = {
  { I_JNE, 1, { RELATIVE|BITS8, 0, 0 }, "\x75", 1, -1, { -1, -1, -1 } },
  { I_JNE, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x85", 2, -1, { -1, -1, -1 } },
  { I_JNE, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x85", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNL[] = {
  { I_JNL, 1, { RELATIVE|BITS8, 0, 0 }, "\x7D", 1, -1, { -1, -1, -1 } },
  { I_JNL, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x8D", 2, -1, { -1, -1, -1 } },
  { I_JNL, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x8D", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNO[] = {
  { I_JNO, 1, { RELATIVE|BITS8, 0, 0 }, "\x71", 1, -1, { -1, -1, -1 } },
  { I_JNO, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x81", 2, -1, { -1, -1, -1 } },
  { I_JNO, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x81", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNP[] = {
  { I_JNP, 1, { RELATIVE|BITS8, 0, 0 }, "\x7B", 1, -1, { -1, -1, -1 } },
  { I_JNP, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x8B", 2, -1, { -1, -1, -1 } },
  { I_JNP, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x8B", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JNS[] = {
  { I_JNS, 1, { RELATIVE|BITS8, 0, 0 }, "\x79", 1, -1, { -1, -1, -1 } },
  { I_JNS, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x89", 2, -1, { -1, -1, -1 } },
  { I_JNS, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x89", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JO[] = {
  { I_JO, 1, { RELATIVE|BITS8, 0, 0 }, "\x70", 1, -1, { -1, -1, -1 } },
  { I_JO, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x80", 2, -1, { -1, -1, -1 } },
  { I_JO, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x80", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JP[] = {
  { I_JP, 1, { RELATIVE|BITS8, 0, 0 }, "\x7A", 1, -1, { -1, -1, -1 } },
  { I_JP, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x8A", 2, -1, { -1, -1, -1 } },
  { I_JP, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x8A", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_JS[] = {
  { I_JS, 1, { RELATIVE|BITS8, 0, 0 }, "\x78", 1, -1, { -1, -1, -1 } },
  { I_JS, 1, { RELATIVE|BITS16|NEAR, 0, 0 }, "\x0F\x88", 2, -1, { -1, -1, -1 } },
  { I_JS, 1, { RELATIVE|BITS32|NEAR, 0, 0 }, "\x0F\x88", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LAHF[] = {
  { I_LAHF, 0, { 0, 0, 0 }, "\x9F", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LAR[] = {
  { I_LAR, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x02", 2, REGRM, { -1, -1, -1 } },
  { I_LAR, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x02", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LDS[] = {
  { I_LDS, 2, { REG16, REGMEM|BITS16, 0 }, "\xC5", 1, REGRM, { -1, -1, -1 } },
  { I_LDS, 2, { REG32, REGMEM|BITS32, 0 }, "\xC5", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LEA[] = {
  { I_LEA, 2, { REG16, MEMORY, 0 }, "\x8D", 1, REGRM, { -1, -1, -1 } },
  { I_LEA, 2, { REG32, MEMORY, 0 }, "\x8D", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LEAVE[] = {
  { I_LEAVE, 0, { 0, 0, 0 }, "\xC9", 1, -1, { -1, -1, -1 } },
  { I_LEAVE, 0, { BITS32, 0, 0 }, "\xC9", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LES[] = {
  { I_LES, 2, { REG16, REGMEM|BITS16, 0 }, "\xC4", 1, REGRM, { -1, -1, -1 } },
  { I_LES, 2, { REG32, REGMEM|BITS32, 0 }, "\xC4", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LFS[] = {
  { I_LFS, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\xB4", 2, REGRM, { -1, -1, -1 } },
  { I_LFS, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\xB4", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LGDT[] = {
  { I_LGDT, 1, { MEMORY|BITS16, 0, 0 }, "\x0F\x01", 2, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LGS[] = {
  { I_LGS, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\xB5", 2, REGRM, { -1, -1, -1 } },
  { I_LGS, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\xB5", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LIDT[] = {
  { I_LIDT, 1, { MEMORY|BITS32, 0, 0 }, "\x0F\x01", 2, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LLDT[] = {
  { I_LLDT, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x00", 2, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LMSW[] = {
  { I_LMSW, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x01", 2, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LOCK[] = {
  { I_LOCK, 0, { 0, 0, 0 }, "\xF0", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LODSB[] = {
  { I_LODSB, 0, { 0, 0, 0 }, "\xAC", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LODSD[] = {
  { I_LODSD, 0, { BITS32, 0, 0 }, "\xAD", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LODSW[] = {
  { I_LODSW, 0, { 0, 0, 0 }, "\xAD", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LOOP[] = {
  { I_LOOP, 1, { RELATIVE|BITS8, 0, 0 }, "\xE2", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LOOPE[] = {
  { I_LOOPE, 1, { RELATIVE|BITS8, 0, 0 }, "\xE1", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LOOPNE[] = {
  { I_LOOPNE, 1, { RELATIVE|BITS8, 0, 0 }, "\xE0", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LSL[] = {
  { I_LSL, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\x03", 2, REGRM, { -1, -1, -1 } },
  { I_LSL, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\x03", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LSS[] = {
  { I_LSS, 2, { REG16, REGMEM|BITS16, 0 }, "\x0F\xB2", 2, REGRM, { -1, -1, -1 } },
  { I_LSS, 2, { REG32, REGMEM|BITS32, 0 }, "\x0F\xB2", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_LTR[] = {
  { I_LTR, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x00", 2, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOV[] = {
  { I_MOV, 2, { REGMEM|BITS8, REG8, 0 }, "\x88", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REGMEM|BITS16, REG16, 0 }, "\x89", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REGMEM|BITS32, REG32, 0 }, "\x89", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REG8, REGMEM|BITS8, 0 }, "\x8A", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REG16, REGMEM|BITS16, 0 }, "\x8B", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REG32, REGMEM|BITS32, 0 }, "\x8B", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REGMEM|BITS16, REG_SR, 0 }, "\x8C", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REG_SR, REGMEM|BITS16, 0 }, "\x8E", 1, REGRM, { -1, -1, -1 } },
  { I_MOV, 2, { REGISTER|BITS8, MEMOFFS, 0 }, "\xA0", 1, -1, { R_AL, -1, -1 } },
  { I_MOV, 2, { REGISTER|BITS16, MEMOFFS, 0 }, "\xA1", 1, -1, { R_AX, -1, -1 } },
  { I_MOV, 2, { REGISTER|BITS32, MEMOFFS, 0 }, "\xA1", 1, -1, { R_EAX, -1, -1 } },
  { I_MOV, 2, { MEMOFFS, REGISTER|BITS8, 0 }, "\xA2", 1, -1, { -1, R_AL, -1 } },
  { I_MOV, 2, { MEMOFFS, REGISTER|BITS16, 0 }, "\xA3", 1, -1, { -1, R_AX, -1 } },
  { I_MOV, 2, { MEMOFFS, REGISTER|BITS32, 0 }, "\xA3", 1, -1, { -1, R_EAX, -1 } },
  { I_MOV, 2, { REG8, IMMEDIATE|BITS8, 0 }, "\xB0", 1, REGCODE, { -1, -1, -1 } },
  { I_MOV, 2, { REG16, IMMEDIATE|BITS16, 0 }, "\xB8", 1, REGCODE, { -1, -1, -1 } },
  { I_MOV, 2, { REG32, IMMEDIATE|BITS32, 0 }, "\xB8", 1, REGCODE, { -1, -1, -1 } },
  { I_MOV, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC6", 1, 0, { -1, -1, -1 } },
  { I_MOV, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\xC7", 1, 0, { -1, -1, -1 } },
  { I_MOV, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\xC7", 1, 0, { -1, -1, -1 } },
  { I_MOV, 2, { REG_CONTROL, REG32, 0 }, "\x0F\x22", 2, REGRM, { -1, MODFIELD_RM, -1 } },
  { I_MOV, 2, { REG32, REG_CONTROL, 0 }, "\x0F\x20", 2, REGRM, { MODFIELD_RM, -1, -1 } },
  { I_MOV, 2, { REG32, REG_DEBUG, 0 }, "\x0F\x21", 2, REGRM, { MODFIELD_RM, -1, -1 } },
  { I_MOV, 2, { REG_DEBUG, REG32, 0 }, "\x0F\x23", 2, REGRM, { -1, MODFIELD_RM, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVAPS[] = {
  { I_MOVAPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x28", 2, REGRM, { -1, -1, -1 } },
  { I_MOVAPS, 2, { MEMORY|BITS128, REG_XMM, 0 }, "\x0F\x29", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVD[] = {
  { I_MOVD, 2, { REG_MMX, REGMEM|BITS32, 0 }, "\x0F\x6E", 2, REGRM, { -1, -1, -1 } },
  { I_MOVD, 2, { REGMEM|BITS32, REG_MMX, 0 }, "\x0F\x7E", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVHPS[] = {
  { I_MOVHPS, 2, { REG_XMM, MEMORY|BITS64, 0 }, "\x0F\x16", 2, REGRM, { -1, -1, -1 } },
  { I_MOVHPS, 2, { MEMORY|BITS64, REG_XMM, 0 }, "\x0F\x17", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVLPS[] = {
  { I_MOVLPS, 2, { REG_XMM, MEMORY|BITS64, 0 }, "\x0F\x12", 2, REGRM, { -1, -1, -1 } },
  { I_MOVLPS, 2, { MEMORY|BITS64, REG_XMM, 0 }, "\x0F\x13", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVMSKPS[] = {
  { I_MOVMSKPS, 2, { REG32, REG_XMM, 0 }, "\x0F\x50", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVNTPS[] = {
  { I_MOVNTPS, 2, { MEMORY, REG_XMM, 0 }, "\x0F\x2B", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVNTQ[] = {
  { I_MOVNTQ, 2, { MEMORY, REG_MMX, 0 }, "\x0F\xE7", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVQ[] = {
  { I_MOVQ, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x6F", 2, REGRM, { -1, -1, -1 } },
  { I_MOVQ, 2, { MEMORY|BITS64, REG_MMX, 0 }, "\x0F\x7F", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVSB[] = {
  { I_MOVSB, 0, { 0, 0, 0 }, "\xA4", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVSD[] = {
  { I_MOVSD, 0, { BITS32, 0, 0 }, "\xA5", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVSS[] = {
  { I_MOVSS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\xF3\x0F\x10", 3, REGRM, { -1, -1, -1 } },
  { I_MOVSS, 2, { MEMORY|BITS128, REG_XMM, 0 }, "\xF3\x0F\x11", 3, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVSW[] = {
  { I_MOVSW, 0, { 0, 0, 0 }, "\xA5", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVSX[] = {
  { I_MOVSX, 2, { REG16, REGMEM|BITS8, 0 }, "\x0F\xBE", 2, REGRM, { -1, -1, -1 } },
  { I_MOVSX, 2, { REG32, REGMEM|BITS8, 0 }, "\x0F\xBE", 2, REGRM, { -1, -1, -1 } },
  { I_MOVSX, 2, { REG32, REGMEM|BITS16, 0 }, "\x0F\xBF", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVUPS[] = {
  { I_MOVUPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x10", 2, REGRM, { -1, -1, -1 } },
  { I_MOVUPS, 2, { MEMORY|BITS128, REG_XMM, 0 }, "\x0F\x11", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MOVZX[] = {
  { I_MOVZX, 2, { REG16, REGMEM|BITS8, 0 }, "\x0F\xB6", 2, REGRM, { -1, -1, -1 } },
  { I_MOVZX, 2, { REG32, REGMEM|BITS8, 0 }, "\x0F\xB6", 2, REGRM, { -1, -1, -1 } },
  { I_MOVZX, 2, { REG32, REGMEM|BITS16, 0 }, "\x0F\xB7", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MUL[] = {
  { I_MUL, 1, { REGMEM|BITS8, 0, 0 }, "\xF6", 1, 4, { -1, -1, -1 } },
  { I_MUL, 1, { REGMEM|BITS16, 0, 0 }, "\xF7", 1, 4, { -1, -1, -1 } },
  { I_MUL, 1, { REGMEM|BITS32, 0, 0 }, "\xF7", 1, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MULPS[] = {
  { I_MULPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x59", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_MULSS[] = {
  { I_MULSS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\xF3\x0F\x59", 3, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_NEG[] = {
  { I_NEG, 1, { REGMEM|BITS8, 0, 0 }, "\xF6", 1, 3, { -1, -1, -1 } },
  { I_NEG, 1, { REGMEM|BITS16, 0, 0 }, "\xF7", 1, 3, { -1, -1, -1 } },
  { I_NEG, 1, { REGMEM|BITS32, 0, 0 }, "\xF7", 1, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_NOP[] = {
  { I_NOP, 0, { 0, 0, 0 }, "\x90", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_NOT[] = {
  { I_NOT, 1, { REGMEM|BITS8, 0, 0 }, "\xF6", 1, 2, { -1, -1, -1 } },
  { I_NOT, 1, { REGMEM|BITS16, 0, 0 }, "\xF7", 1, 2, { -1, -1, -1 } },
  { I_NOT, 1, { REGMEM|BITS32, 0, 0 }, "\xF7", 1, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_OR[] = {
  { I_OR, 2, { REGISTER|BITS8, IMMEDIATE|BITS8, 0 }, "\x0C", 1, -1, { R_AL, -1, -1 } },
  { I_OR, 2, { REGISTER|BITS16, IMMEDIATE|BITS16, 0 }, "\x0D", 1, -1, { R_AX, -1, -1 } },
  { I_OR, 2, { REGISTER|BITS32, IMMEDIATE|BITS32, 0 }, "\x0D", 1, -1, { R_EAX, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 1, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 1, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 1, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 1, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 1, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS8, REG8, 0 }, "\x08", 1, REGRM, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS16, REG16, 0 }, "\x09", 1, REGRM, { -1, -1, -1 } },
  { I_OR, 2, { REGMEM|BITS32, REG32, 0 }, "\x09", 1, REGRM, { -1, -1, -1 } },
  { I_OR, 2, { REG8, REGMEM|BITS8, 0 }, "\x0A", 1, REGRM, { -1, -1, -1 } },
  { I_OR, 2, { REG16, REGMEM|BITS16, 0 }, "\x0B", 1, REGRM, { -1, -1, -1 } },
  { I_OR, 2, { REG32, REGMEM|BITS32, 0 }, "\x0B", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ORPS[] = {
  { I_ORPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x56", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_OUT[] = {
  { I_OUT, 2, { IMMEDIATE|BITS8, REGISTER|BITS8, 0 }, "\xE6", 1, -1, { -1, R_AL, -1 } },
  { I_OUT, 2, { IMMEDIATE|BITS8, REGISTER|BITS16, 0 }, "\xE7", 1, -1, { -1, R_AX, -1 } },
  { I_OUT, 2, { IMMEDIATE|BITS8, REGISTER|BITS32, 0 }, "\xE7", 1, -1, { -1, R_EAX, -1 } },
  { I_OUT, 2, { REGISTER|BITS16, REGISTER|BITS8, 0 }, "\xEE", 1, -1, { R_DX, R_AL, -1 } },
  { I_OUT, 2, { REGISTER|BITS16, REGISTER|BITS16, 0 }, "\xEF", 1, -1, { R_DX, R_AX, -1 } },
  { I_OUT, 2, { REGISTER|BITS16, REGISTER|BITS32, 0 }, "\xEF", 1, -1, { R_DX, R_EAX, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_OUTSB[] = {
  { I_OUTSB, 0, { 0, 0, 0 }, "\x6E", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_OUTSD[] = {
  { I_OUTSD, 0, { BITS32, 0, 0 }, "\x6F", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_OUTSW[] = {
  { I_OUTSW, 0, { 0, 0, 0 }, "\x6F", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PACKSSDW[] = {
  { I_PACKSSDW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x6B", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PACKSSWB[] = {
  { I_PACKSSWB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x63", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PACKUSWB[] = {
  { I_PACKUSWB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x67", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDB[] = {
  { I_PADDB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xFC", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDD[] = {
  { I_PADDD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xFE", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDSB[] = {
  { I_PADDSB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xEC", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDSW[] = {
  { I_PADDSW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xED", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDUSB[] = {
  { I_PADDUSB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xDC", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDUSW[] = {
  { I_PADDUSW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xDD", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PADDW[] = {
  { I_PADDW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xFD", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PAND[] = {
  { I_PAND, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xDB", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PANDN[] = {
  { I_PANDN, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xDF", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PAVGB[] = {
  { I_PAVGB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE0", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PAVGW[] = {
  { I_PAVGW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE3", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PCMPEQB[] = {
  { I_PCMPEQB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x74", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PCMPEQD[] = {
  { I_PCMPEQD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x76", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PCMPEQW[] = {
  { I_PCMPEQW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x75", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PCMPGTB[] = {
  { I_PCMPGTB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x64", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PCMPGTD[] = {
  { I_PCMPGTD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x66", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PCMPGTW[] = {
  { I_PCMPGTW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x65", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PEXTRW[] = {
  { I_PEXTRW, 3, { REG32, REG_MMX, IMMEDIATE|BITS8 }, "\x0F\xC5", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PINSRW[] = {
  { I_PINSRW, 3, { REG_MMX, MEMORY|BITS16, IMMEDIATE|BITS8 }, "\x0F\xC4", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMADDWD[] = {
  { I_PMADDWD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF5", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMAXSW[] = {
  { I_PMAXSW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xEE", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMAXUB[] = {
  { I_PMAXUB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xDE", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMINSW[] = {
  { I_PMINSW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xEA", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMINUB[] = {
  { I_PMINUB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xDA", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMOVMSKB[] = {
  { I_PMOVMSKB, 2, { REG32, REG_MMX, 0 }, "\x0F\xD7", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMULHUW[] = {
  { I_PMULHUW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE4", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMULHW[] = {
  { I_PMULHW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE5", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PMULLW[] = {
  { I_PMULLW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xD5", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_POP[] = {
  { I_POP, 1, { MEMORY|BITS16, 0, 0 }, "\x8F", 1, 0, { -1, -1, -1 } },
  { I_POP, 1, { MEMORY|BITS32, 0, 0 }, "\x8F", 1, 0, { -1, -1, -1 } },
  { I_POP, 1, { REG16, 0, 0 }, "\x58", 1, REGCODE, { -1, -1, -1 } },
  { I_POP, 1, { REG32, 0, 0 }, "\x58", 1, REGCODE, { -1, -1, -1 } },
  { I_POP, 1, { REGISTER, 0, 0 }, "\x1F", 1, -1, { R_DS, -1, -1 } },
  { I_POP, 1, { REGISTER, 0, 0 }, "\x07", 1, -1, { R_ES, -1, -1 } },
  { I_POP, 1, { REGISTER, 0, 0 }, "\x17", 1, -1, { R_SS, -1, -1 } },
  { I_POP, 1, { REGISTER, 0, 0 }, "\x0F\xA1", 2, -1, { R_FS, -1, -1 } },
  { I_POP, 1, { REGISTER, 0, 0 }, "\x0F\xA9", 2, -1, { R_GS, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_POPA[] = {
  { I_POPA, 0, { 0, 0, 0 }, "\x61", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_POPAD[] = {
  { I_POPAD, 0, { BITS32, 0, 0 }, "\x61", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_POPF[] = {
  { I_POPF, 0, { 0, 0, 0 }, "\x9D", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_POPFD[] = {
  { I_POPFD, 0, { BITS32, 0, 0 }, "\x9D", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_POR[] = {
  { I_POR, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xEB", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PREFETCHNTA[] = {
  { I_PREFETCHNTA, 1, { MEMORY|BITS8, 0, 0 }, "\x0F\x18", 2, 0, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PREFETCHT0[] = {
  { I_PREFETCHT0, 1, { MEMORY|BITS8, 0, 0 }, "\x0F\x18", 2, 1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PREFETCHT1[] = {
  { I_PREFETCHT1, 1, { MEMORY|BITS8, 0, 0 }, "\x0F\x18", 2, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PREFETCHT2[] = {
  { I_PREFETCHT2, 1, { MEMORY|BITS8, 0, 0 }, "\x0F\x18", 2, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSADBW[] = {
  { I_PSADBW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF6", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSHUFW[] = {
  { I_PSHUFW, 3, { REG_MMX, MEMORY|BITS64, IMMEDIATE|BITS8 }, "\x0F\x70", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSLLD[] = {
  { I_PSLLD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF2", 2, REGRM, { -1, -1, -1 } },
  { I_PSLLD, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x72", 2, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSLLQ[] = {
  { I_PSLLQ, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF3", 2, REGRM, { -1, -1, -1 } },
  { I_PSLLQ, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x73", 2, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSLLW[] = {
  { I_PSLLW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF1", 2, REGRM, { -1, -1, -1 } },
  { I_PSLLW, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x71", 2, 6, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSRAD[] = {
  { I_PSRAD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE2", 2, REGRM, { -1, -1, -1 } },
  { I_PSRAD, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x72", 2, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSRAW[] = {
  { I_PSRAW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE1", 2, REGRM, { -1, -1, -1 } },
  { I_PSRAW, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x71", 2, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSRLD[] = {
  { I_PSRLD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xD2", 2, REGRM, { -1, -1, -1 } },
  { I_PSRLD, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x72", 2, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSRLQ[] = {
  { I_PSRLQ, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xD3", 2, REGRM, { -1, -1, -1 } },
  { I_PSRLQ, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x73", 2, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSRLW[] = {
  { I_PSRLW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xD1", 2, REGRM, { -1, -1, -1 } },
  { I_PSRLW, 2, { REG_MMX, IMMEDIATE|BITS8, 0 }, "\x0F\x71", 2, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBB[] = {
  { I_PSUBB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF8", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBD[] = {
  { I_PSUBD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xFA", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBSB[] = {
  { I_PSUBSB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE8", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBSW[] = {
  { I_PSUBSW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xE9", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBUSB[] = {
  { I_PSUBUSB, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xD8", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBUSW[] = {
  { I_PSUBUSW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xD9", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PSUBW[] = {
  { I_PSUBW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xF9", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUNPCKHBW[] = {
  { I_PUNPCKHBW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x68", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUNPCKHDQ[] = {
  { I_PUNPCKHDQ, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x6A", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUNPCKHWD[] = {
  { I_PUNPCKHWD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x69", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUNPCKLBW[] = {
  { I_PUNPCKLBW, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x60", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUNPCKLDQ[] = {
  { I_PUNPCKLDQ, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x62", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUNPCKLWD[] = {
  { I_PUNPCKLWD, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\x61", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUSH[] = {
  { I_PUSH, 1, { REGMEM|BITS16, 0, 0 }, "\xFF", 1, 6, { -1, -1, -1 } },
  { I_PUSH, 1, { REGMEM|BITS32, 0, 0 }, "\xFF", 1, 6, { -1, -1, -1 } },
  { I_PUSH, 1, { REG16, 0, 0 }, "\x50", 1, REGCODE, { -1, -1, -1 } },
  { I_PUSH, 1, { REG32, 0, 0 }, "\x50", 1, REGCODE, { -1, -1, -1 } },
  { I_PUSH, 1, { IMMEDIATE|BITS8, 0, 0 }, "\x6A", 1, -1, { -1, -1, -1 } },
  { I_PUSH, 1, { IMMEDIATE|BITS16, 0, 0 }, "\x68", 1, -1, { -1, -1, -1 } },
  { I_PUSH, 1, { IMMEDIATE|BITS32, 0, 0 }, "\x68", 1, -1, { -1, -1, -1 } },
  { I_PUSH, 1, { REGISTER, 0, 0 }, "\x0E", 1, -1, { R_CS, -1, -1 } },
  { I_PUSH, 1, { REGISTER, 0, 0 }, "\x16", 1, -1, { R_SS, -1, -1 } },
  { I_PUSH, 1, { REGISTER, 0, 0 }, "\x1E", 1, -1, { R_DS, -1, -1 } },
  { I_PUSH, 1, { REGISTER, 0, 0 }, "\x06", 1, -1, { R_ES, -1, -1 } },
  { I_PUSH, 1, { REGISTER, 0, 0 }, "\x0F\xA0", 2, -1, { R_FS, -1, -1 } },
  { I_PUSH, 1, { REGISTER, 0, 0 }, "\x0F\xA8", 2, -1, { R_GS, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUSHA[] = {
  { I_PUSHA, 0, { 0, 0, 0 }, "\x60", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUSHAD[] = {
  { I_PUSHAD, 0, { BITS32, 0, 0 }, "\x60", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUSHF[] = {
  { I_PUSHF, 0, { 0, 0, 0 }, "\x9C", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PUSHFD[] = {
  { I_PUSHFD, 0, { BITS32, 0, 0 }, "\x9C", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_PXOR[] = {
  { I_PXOR, 2, { REG_MMX, MEMORY|BITS64, 0 }, "\x0F\xEF", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RCL[] = {
  { I_RCL, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 2, { -1, 1, -1 } },
  { I_RCL, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 2, { -1, R_CL, -1 } },
  { I_RCL, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 2, { -1, -1, -1 } },
  { I_RCL, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 2, { -1, 1, -1 } },
  { I_RCL, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 2, { -1, R_CL, -1 } },
  { I_RCL, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 2, { -1, -1, -1 } },
  { I_RCL, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 2, { -1, 1, -1 } },
  { I_RCL, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 2, { -1, R_CL, -1 } },
  { I_RCL, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 2, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RCPPS[] = {
  { I_RCPPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x53", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RCPSS[] = {
  { I_RCPSS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\xF3\x0F\x53", 3, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RCR[] = {
  { I_RCR, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 3, { -1, 1, -1 } },
  { I_RCR, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 3, { -1, R_CL, -1 } },
  { I_RCR, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 3, { -1, -1, -1 } },
  { I_RCR, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 3, { -1, 1, -1 } },
  { I_RCR, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 3, { -1, R_CL, -1 } },
  { I_RCR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 3, { -1, -1, -1 } },
  { I_RCR, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 3, { -1, 1, -1 } },
  { I_RCR, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 3, { -1, R_CL, -1 } },
  { I_RCR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RDMSR[] = {
  { I_RDMSR, 0, { 0, 0, 0 }, "\x0F\x32", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RDPMC[] = {
  { I_RDPMC, 0, { 0, 0, 0 }, "\x0F\x33", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RDTSC[] = {
  { I_RDTSC, 0, { 0, 0, 0 }, "\x0F\x31", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RETF[] = {
  { I_RETF, 0, { 0, 0, 0 }, "\xCB", 1, -1, { -1, -1, -1 } },
  { I_RETF, 1, { IMMEDIATE|BITS16, 0, 0 }, "\xCA", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RETN[] = {
  { I_RETN, 0, { 0, 0, 0 }, "\xC3", 1, -1, { -1, -1, -1 } },
  { I_RETN, 1, { IMMEDIATE|BITS16, 0, 0 }, "\xC2", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ROL[] = {
  { I_ROL, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 0, { -1, 1, -1 } },
  { I_ROL, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 0, { -1, R_CL, -1 } },
  { I_ROL, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 0, { -1, -1, -1 } },
  { I_ROL, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 0, { -1, 1, -1 } },
  { I_ROL, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 0, { -1, R_CL, -1 } },
  { I_ROL, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 0, { -1, -1, -1 } },
  { I_ROL, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 0, { -1, 1, -1 } },
  { I_ROL, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 0, { -1, R_CL, -1 } },
  { I_ROL, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 0, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_ROR[] = {
  { I_ROR, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 1, { -1, 1, -1 } },
  { I_ROR, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 1, { -1, R_CL, -1 } },
  { I_ROR, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 1, { -1, -1, -1 } },
  { I_ROR, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 1, { -1, 1, -1 } },
  { I_ROR, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 1, { -1, R_CL, -1 } },
  { I_ROR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 1, { -1, -1, -1 } },
  { I_ROR, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 1, { -1, 1, -1 } },
  { I_ROR, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 1, { -1, R_CL, -1 } },
  { I_ROR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RSM[] = {
  { I_RSM, 0, { 0, 0, 0 }, "\x0F\xAA", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RSQRTPS[] = {
  { I_RSQRTPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x52", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_RSQRTSS[] = {
  { I_RSQRTSS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\xF3\x0F\x52", 3, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SAHF[] = {
  { I_SAHF, 0, { 0, 0, 0 }, "\x9E", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SAR[] = {
  { I_SAR, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 7, { -1, 1, -1 } },
  { I_SAR, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 7, { -1, R_CL, -1 } },
  { I_SAR, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 7, { -1, -1, -1 } },
  { I_SAR, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 7, { -1, 1, -1 } },
  { I_SAR, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 7, { -1, R_CL, -1 } },
  { I_SAR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 7, { -1, -1, -1 } },
  { I_SAR, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 7, { -1, 1, -1 } },
  { I_SAR, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 7, { -1, R_CL, -1 } },
  { I_SAR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SBB[] = {
  { I_SBB, 2, { REGISTER, IMMEDIATE|BITS8, 0 }, "\x1C", 1, -1, { R_AL, -1, -1 } },
  { I_SBB, 2, { REGISTER, IMMEDIATE|BITS16, 0 }, "\x1D", 1, -1, { R_AX, -1, -1 } },
  { I_SBB, 2, { REGISTER, IMMEDIATE|BITS32, 0 }, "\x1D", 1, -1, { R_EAX, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 3, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 3, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 3, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 3, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 3, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS8, REG8, 0 }, "\x18", 1, REGRM, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS16, REG16, 0 }, "\x19", 1, REGRM, { -1, -1, -1 } },
  { I_SBB, 2, { REGMEM|BITS32, REG32, 0 }, "\x19", 1, REGRM, { -1, -1, -1 } },
  { I_SBB, 2, { REG8, REGMEM|BITS8, 0 }, "\x1A", 1, REGRM, { -1, -1, -1 } },
  { I_SBB, 2, { REG16, REGMEM|BITS16, 0 }, "\x1B", 1, REGRM, { -1, -1, -1 } },
  { I_SBB, 2, { REG32, REGMEM|BITS32, 0 }, "\x1B", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SCASB[] = {
  { I_SCASB, 0, { 0, 0, 0 }, "\xAE", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SCASD[] = {
  { I_SCASD, 0, { BITS32, 0, 0 }, "\xAF", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SCASW[] = {
  { I_SCASW, 0, { 0, 0, 0 }, "\xAF", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETA[] = {
  { I_SETA, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x97", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETC[] = {
  { I_SETC, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x92", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETE[] = {
  { I_SETE, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x94", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETG[] = {
  { I_SETG, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x9F", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETL[] = {
  { I_SETL, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x9C", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNA[] = {
  { I_SETNA, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x96", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNC[] = {
  { I_SETNC, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x93", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNE[] = {
  { I_SETNE, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x95", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNG[] = {
  { I_SETNG, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x9E", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNL[] = {
  { I_SETNL, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x9D", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNO[] = {
  { I_SETNO, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x91", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNP[] = {
  { I_SETNP, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x9B", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETNS[] = {
  { I_SETNS, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x99", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETO[] = {
  { I_SETO, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x90", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETP[] = {
  { I_SETP, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x9A", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SETS[] = {
  { I_SETS, 1, { REGMEM|BITS8, 0, 0 }, "\x0F\x98", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SFENCE[] = {
  { I_SFENCE, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\xAE", 2, 7, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SGDT[] = {
  { I_SGDT, 1, { MEMORY, 0, 0 }, "\x0F\x01", 2, 0, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SHL[] = {
  { I_SHL, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 4, { -1, 1, -1 } },
  { I_SHL, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 4, { -1, R_CL, -1 } },
  { I_SHL, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 4, { -1, -1, -1 } },
  { I_SHL, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 4, { -1, 1, -1 } },
  { I_SHL, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 4, { -1, R_CL, -1 } },
  { I_SHL, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 4, { -1, -1, -1 } },
  { I_SHL, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 4, { -1, 1, -1 } },
  { I_SHL, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 4, { -1, R_CL, -1 } },
  { I_SHL, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SHLD[] = {
  { I_SHLD, 3, { REGMEM|BITS16, REG16, IMMEDIATE|BITS8 }, "\x0F\xA4", 2, REGRM, { -1, -1, -1 } },
  { I_SHLD, 3, { REGMEM|BITS16, REG16, REGISTER }, "\x0F\xA5", 2, REGRM, { -1, -1, R_CL } },
  { I_SHLD, 3, { REGMEM|BITS32, REG32, IMMEDIATE|BITS8 }, "\x0F\xA4", 2, REGRM, { -1, -1, -1 } },
  { I_SHLD, 3, { REGMEM|BITS32, REG32, REGISTER }, "\x0F\xA5", 2, REGRM, { -1, -1, R_CL } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SHR[] = {
  { I_SHR, 2, { REGMEM|BITS8, CONSTANT, 0 }, "\xD0", 1, 5, { -1, 1, -1 } },
  { I_SHR, 2, { REGMEM|BITS8, REGISTER, 0 }, "\xD2", 1, 5, { -1, R_CL, -1 } },
  { I_SHR, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xC0", 1, 5, { -1, -1, -1 } },
  { I_SHR, 2, { REGMEM|BITS16, CONSTANT, 0 }, "\xD1", 1, 5, { -1, 1, -1 } },
  { I_SHR, 2, { REGMEM|BITS16, REGISTER, 0 }, "\xD3", 1, 5, { -1, R_CL, -1 } },
  { I_SHR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 5, { -1, -1, -1 } },
  { I_SHR, 2, { REGMEM|BITS32, CONSTANT, 0 }, "\xD1", 1, 5, { -1, 1, -1 } },
  { I_SHR, 2, { REGMEM|BITS32, REGISTER, 0 }, "\xD3", 1, 5, { -1, R_CL, -1 } },
  { I_SHR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\xC1", 1, 5, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SHRD[] = {
  { I_SHRD, 3, { REGMEM|BITS16, REG16, IMMEDIATE|BITS8 }, "\x0F\xAC", 2, REGRM, { -1, -1, -1 } },
  { I_SHRD, 3, { REGMEM|BITS16, REG16, REGISTER }, "\x0F\xAD", 2, REGRM, { -1, -1, R_CL } },
  { I_SHRD, 3, { REGMEM|BITS32, REG32, IMMEDIATE|BITS8 }, "\x0F\xAC", 2, REGRM, { -1, -1, -1 } },
  { I_SHRD, 3, { REGMEM|BITS32, REG32, REGISTER }, "\x0F\xAD", 2, REGRM, { -1, -1, R_CL } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SHUFPS[] = {
  { I_SHUFPS, 3, { REG_XMM, MEMORY|BITS128, IMMEDIATE|BITS8 }, "\x0F\xC6", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SIDT[] = {
  { I_SIDT, 1, { MEMORY, 0, 0 }, "\x0F\x01", 2, 1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SLDT[] = {
  { I_SLDT, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x00", 2, 0, { -1, -1, -1 } },
  { I_SLDT, 1, { REGMEM|BITS32, 0, 0 }, "\x0F\x00", 2, 0, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SMSW[] = {
  { I_SMSW, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x01", 2, 4, { -1, -1, -1 } },
  { I_SMSW, 1, { MEMORY|BITS32, 0, 0 }, "\x0F\x01", 2, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SQRTPS[] = {
  { I_SQRTPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x51", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SQRTSS[] = {
  { I_SQRTSS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\xF3\x0F\x51", 3, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STC[] = {
  { I_STC, 0, { 0, 0, 0 }, "\xF9", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STD[] = {
  { I_STD, 0, { 0, 0, 0 }, "\xFD", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STI[] = {
  { I_STI, 0, { 0, 0, 0 }, "\xFB", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STMXCSR[] = {
  { I_STMXCSR, 1, { MEMORY|BITS32, 0, 0 }, "\x0F\xAE", 2, 3, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STOSB[] = {
  { I_STOSB, 0, { 0, 0, 0 }, "\xAA", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STOSD[] = {
  { I_STOSD, 0, { BITS32, 0, 0 }, "\xAB", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STOSW[] = {
  { I_STOSW, 0, { 0, 0, 0 }, "\xAB", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_STR[] = {
  { I_STR, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x00", 2, 1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SUB[] = {
  { I_SUB, 2, { REGISTER, IMMEDIATE|BITS8, 0 }, "\x2C", 1, -1, { R_AL, -1, -1 } },
  { I_SUB, 2, { REGISTER, IMMEDIATE|BITS16, 0 }, "\x2D", 1, -1, { R_AX, -1, -1 } },
  { I_SUB, 2, { REGISTER, IMMEDIATE|BITS32, 0 }, "\x2D", 1, -1, { R_EAX, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 5, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 5, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 5, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 5, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 5, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS8, REG8, 0 }, "\x28", 1, REGRM, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS16, REG16, 0 }, "\x29", 1, REGRM, { -1, -1, -1 } },
  { I_SUB, 2, { REGMEM|BITS32, REG32, 0 }, "\x29", 1, REGRM, { -1, -1, -1 } },
  { I_SUB, 2, { REG8, REGMEM|BITS8, 0 }, "\x2A", 1, REGRM, { -1, -1, -1 } },
  { I_SUB, 2, { REG16, REGMEM|BITS16, 0 }, "\x2B", 1, REGRM, { -1, -1, -1 } },
  { I_SUB, 2, { REG32, REGMEM|BITS32, 0 }, "\x2B", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SUBPS[] = {
  { I_SUBPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x5C", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SUBSS[] = {
  { I_SUBSS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\xF3\x0F\x5C", 3, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SYSENTER[] = {
  { I_SYSENTER, 0, { 0, 0, 0 }, "\x0F\x34", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_SYSEXIT[] = {
  { I_SYSEXIT, 0, { 0, 0, 0 }, "\x0F\x35", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_TEST[] = {
  { I_TEST, 2, { REGISTER, IMMEDIATE|BITS8, 0 }, "\xA8", 1, -1, { R_AL, -1, -1 } },
  { I_TEST, 2, { REGISTER, IMMEDIATE|BITS16, 0 }, "\xA9", 1, -1, { R_AX, -1, -1 } },
  { I_TEST, 2, { REGISTER, IMMEDIATE|BITS32, 0 }, "\xA9", 1, -1, { R_EAX, -1, -1 } },
  { I_TEST, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\xF6", 1, 0, { -1, -1, -1 } },
  { I_TEST, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\xF7", 1, 0, { -1, -1, -1 } },
  { I_TEST, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\xF7", 1, 0, { -1, -1, -1 } },
  { I_TEST, 2, { REGMEM|BITS8, REG8, 0 }, "\x84", 1, REGRM, { -1, -1, -1 } },
  { I_TEST, 2, { REGMEM|BITS16, REG16, 0 }, "\x85", 1, REGRM, { -1, -1, -1 } },
  { I_TEST, 2, { REGMEM|BITS32, REG32, 0 }, "\x85", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_UCOMISS[] = {
  { I_UCOMISS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x2E", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_UD2[] = {
  { I_UD2, 0, { 0, 0, 0 }, "\x0F\x0B", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_UNPCKHPS[] = {
  { I_UNPCKHPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x15", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_UNPCKLPS[] = {
  { I_UNPCKLPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x14", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_VERR[] = {
  { I_VERR, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x00", 2, 4, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_VERW[] = {
  { I_VERW, 1, { REGMEM|BITS16, 0, 0 }, "\x0F\x00", 2, 5, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_WAIT[] = {
  { I_WAIT, 0, { 0, 0, 0 }, "\x9B", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_WBINVD[] = {
  { I_WBINVD, 0, { 0, 0, 0 }, "\x0F\x09", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_WRMSR[] = {
  { I_WRMSR, 0, { 0, 0, 0 }, "\x0F\x30", 2, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_XADD[] = {
  { I_XADD, 2, { REGMEM|BITS8, REG8, 0 }, "\x0F\xC0", 2, REGRM, { -1, -1, -1 } },
  { I_XADD, 2, { REGMEM|BITS16, REG16, 0 }, "\x0F\xC1", 2, REGRM, { -1, -1, -1 } },
  { I_XADD, 2, { REGMEM|BITS32, REG32, 0 }, "\x0F\xC1", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_XCHG[] = {
  { I_XCHG, 2, { REGISTER, REG16, 0 }, "\x90", 1, REGCODE, { R_AX, -1, -1 } },
  { I_XCHG, 2, { REGISTER, REG32, 0 }, "\x90", 1, REGCODE, { R_EAX, -1, -1 } },
  { I_XCHG, 2, { REG8, REGMEM|BITS8, 0 }, "\x86", 1, REGRM, { -1, -1, -1 } },
  { I_XCHG, 2, { REG16, REGMEM|BITS16, 0 }, "\x87", 1, REGRM, { -1, -1, -1 } },
  { I_XCHG, 2, { REG32, REGMEM|BITS32, 0 }, "\x87", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_XLATB[] = {
  { I_XLATB, 0, { 0, 0, 0 }, "\xD7", 1, -1, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_XOR[] = {
  { I_XOR, 2, { REGISTER, IMMEDIATE|BITS8, 0 }, "\x34", 1, -1, { R_AL, -1, -1 } },
  { I_XOR, 2, { REGISTER, IMMEDIATE|BITS16, 0 }, "\x35", 1, -1, { R_AX, -1, -1 } },
  { I_XOR, 2, { REGISTER, IMMEDIATE|BITS32, 0 }, "\x35", 1, -1, { R_EAX, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS8, IMMEDIATE|BITS8, 0 }, "\x80", 1, 6, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS16, IMMEDIATE|BITS16, 0 }, "\x81", 1, 6, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS32, IMMEDIATE|BITS32, 0 }, "\x81", 1, 6, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS16, IMMEDIATE|BITS8, 0 }, "\x83", 1, 6, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS32, IMMEDIATE|BITS8, 0 }, "\x83", 1, 6, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS8, REG8, 0 }, "\x30", 1, REGRM, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS16, REG16, 0 }, "\x31", 1, REGRM, { -1, -1, -1 } },
  { I_XOR, 2, { REGMEM|BITS32, REG32, 0 }, "\x31", 1, REGRM, { -1, -1, -1 } },
  { I_XOR, 2, { REG8, REGMEM|BITS8, 0 }, "\x32", 1, REGRM, { -1, -1, -1 } },
  { I_XOR, 2, { REG16, REGMEM|BITS16, 0 }, "\x33", 1, REGRM, { -1, -1, -1 } },
  { I_XOR, 2, { REG32, REGMEM|BITS32, 0 }, "\x33", 1, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

static struct x86OpCode Instruction_XORPS[] = {
  { I_XORPS, 2, { REG_XMM, MEMORY|BITS128, 0 }, "\x0F\x57", 2, REGRM, { -1, -1, -1 } },
  { -1, -1, { -1, -1, -1 }, 0, -1, -1, { -1, -1, -1 } }
};

struct x86OpCode *x86Instructions[] = {
  Instruction_AAA,
  Instruction_AAD,
  Instruction_AAM,
  Instruction_AAS,
  Instruction_ADC,
  Instruction_ADD,
  Instruction_ADDPS,
  Instruction_AND,
  Instruction_ARPL,
  Instruction_BOUND,
  Instruction_BSF,
  Instruction_BSR,
  Instruction_BSWAP,
  Instruction_BT,
  Instruction_BTC,
  Instruction_BTR,
  Instruction_BTS,
  Instruction_CALL,
  Instruction_CBW,
  Instruction_CDQ,
  Instruction_CLC,
  Instruction_CLD,
  Instruction_CLI,
  Instruction_CLTS,
  Instruction_CMC,
  Instruction_CMOVA,
  Instruction_CMOVC,
  Instruction_CMOVE,
  Instruction_CMOVG,
  Instruction_CMOVL,
  Instruction_CMOVLE,
  Instruction_CMOVNA,
  Instruction_CMOVNC,
  Instruction_CMOVNE,
  Instruction_CMOVNL,
  Instruction_CMOVNO,
  Instruction_CMOVNP,
  Instruction_CMOVNS,
  Instruction_CMOVO,
  Instruction_CMOVP,
  Instruction_CMOVS,
  Instruction_CMP,
  Instruction_CMPSB,
  Instruction_CMPSD,
  Instruction_CMPSW,
  Instruction_CMPXCHG,
  Instruction_CMPXCHG8B,
  Instruction_CPUID,
  Instruction_CWD,
  Instruction_CWDE,
  Instruction_DAA,
  Instruction_DAS,
  Instruction_DEC,
  Instruction_DIV,
  Instruction_EMMS,
  Instruction_ENTER,
  Instruction_F2XM1,
  Instruction_FABS,
  Instruction_FADD,
  Instruction_FADDP,
  Instruction_FBLD,
  Instruction_FBSTP,
  Instruction_FCHS,
  Instruction_FCLEX,
  Instruction_FCMOVB,
  Instruction_FCMOVBE,
  Instruction_FCMOVE,
  Instruction_FCMOVNB,
  Instruction_FCMOVNBE,
  Instruction_FCMOVNE,
  Instruction_FCMOVNU,
  Instruction_FCMOVU,
  Instruction_FCOM,
  Instruction_FCOMI,
  Instruction_FCOMIP,
  Instruction_FCOMP,
  Instruction_FCOMPP,
  Instruction_FCOS,
  Instruction_FDECSTP,
  Instruction_FDIV,
  Instruction_FDIVP,
  Instruction_FDIVR,
  Instruction_FDIVRP,
  Instruction_FFREE,
  Instruction_FIADD,
  Instruction_FICOM,
  Instruction_FICOMP,
  Instruction_FIDIV,
  Instruction_FIDIVR,
  Instruction_FILD,
  Instruction_FIMUL,
  Instruction_FINCSTP,
  Instruction_FINIT,
  Instruction_FIST,
  Instruction_FISTP,
  Instruction_FISUB,
  Instruction_FISUBR,
  Instruction_FLD,
  Instruction_FLD1,
  Instruction_FLDCW,
  Instruction_FLDENV,
  Instruction_FLDL2E,
  Instruction_FLDL2T,
  Instruction_FLDLG2,
  Instruction_FLDLN2,
  Instruction_FLDPI,
  Instruction_FLDZ,
  Instruction_FMUL,
  Instruction_FMULP,
  Instruction_FNCLEX,
  Instruction_FNINIT,
  Instruction_FNOP,
  Instruction_FNSAVE,
  Instruction_FNSTCW,
  Instruction_FNSTENV,
  Instruction_FNSTSW,
  Instruction_FPATAN,
  Instruction_FPREM,
  Instruction_FPREM1,
  Instruction_FPTAN,
  Instruction_FRNDINT,
  Instruction_FRSTOR,
  Instruction_FSAVE,
  Instruction_FSCALE,
  Instruction_FSIN,
  Instruction_FSINCOS,
  Instruction_FSQRT,
  Instruction_FST,
  Instruction_FSTCW,
  Instruction_FSTENV,
  Instruction_FSTP,
  Instruction_FSTSW,
  Instruction_FSUB,
  Instruction_FSUBP,
  Instruction_FSUBR,
  Instruction_FSUBRP,
  Instruction_FTST,
  Instruction_FUCOM,
  Instruction_FUCOMI,
  Instruction_FUCOMIP,
  Instruction_FUCOMP,
  Instruction_FUCOMPP,
  Instruction_FXAM,
  Instruction_FXCH,
  Instruction_FXTRACT,
  Instruction_FYL2X,
  Instruction_FYL2XP1,
  Instruction_HLT,
  Instruction_IDIV,
  Instruction_IMUL,
  Instruction_IN,
  Instruction_INC,
  Instruction_INSB,
  Instruction_INSD,
  Instruction_INSW,
  Instruction_INT,
  Instruction_INT3,
  Instruction_INTO,
  Instruction_INVD,
  Instruction_INVLPG,
  Instruction_IRET,
  Instruction_IRETD,
  Instruction_JA,
  Instruction_JC,
  Instruction_JCXZ,
  Instruction_JE,
  Instruction_JG,
  Instruction_JL,
  Instruction_JLE,
  Instruction_JMP,
  Instruction_JNA,
  Instruction_JNC,
  Instruction_JNE,
  Instruction_JNL,
  Instruction_JNO,
  Instruction_JNP,
  Instruction_JNS,
  Instruction_JO,
  Instruction_JP,
  Instruction_JS,
  Instruction_LAHF,
  Instruction_LAR,
  Instruction_LDS,
  Instruction_LEA,
  Instruction_LEAVE,
  Instruction_LES,
  Instruction_LFS,
  Instruction_LGDT,
  Instruction_LGS,
  Instruction_LIDT,
  Instruction_LLDT,
  Instruction_LMSW,
  Instruction_LOCK,
  Instruction_LODSB,
  Instruction_LODSD,
  Instruction_LODSW,
  Instruction_LOOP,
  Instruction_LOOPE,
  Instruction_LOOPNE,
  Instruction_LSL,
  Instruction_LSS,
  Instruction_LTR,
  Instruction_MOV,
  Instruction_MOVAPS,
  Instruction_MOVD,
  Instruction_MOVHPS,
  Instruction_MOVLPS,
  Instruction_MOVMSKPS,
  Instruction_MOVNTPS,
  Instruction_MOVNTQ,
  Instruction_MOVQ,
  Instruction_MOVSB,
  Instruction_MOVSD,
  Instruction_MOVSS,
  Instruction_MOVSW,
  Instruction_MOVSX,
  Instruction_MOVUPS,
  Instruction_MOVZX,
  Instruction_MUL,
  Instruction_MULPS,
  Instruction_MULSS,
  Instruction_NEG,
  Instruction_NOP,
  Instruction_NOT,
  Instruction_OR,
  Instruction_ORPS,
  Instruction_OUT,
  Instruction_OUTSB,
  Instruction_OUTSD,
  Instruction_OUTSW,
  Instruction_PACKSSDW,
  Instruction_PACKSSWB,
  Instruction_PACKUSWB,
  Instruction_PADDB,
  Instruction_PADDD,
  Instruction_PADDSB,
  Instruction_PADDSW,
  Instruction_PADDUSB,
  Instruction_PADDUSW,
  Instruction_PADDW,
  Instruction_PAND,
  Instruction_PANDN,
  Instruction_PAVGB,
  Instruction_PAVGW,
  Instruction_PCMPEQB,
  Instruction_PCMPEQD,
  Instruction_PCMPEQW,
  Instruction_PCMPGTB,
  Instruction_PCMPGTD,
  Instruction_PCMPGTW,
  Instruction_PEXTRW,
  Instruction_PINSRW,
  Instruction_PMADDWD,
  Instruction_PMAXSW,
  Instruction_PMAXUB,
  Instruction_PMINSW,
  Instruction_PMINUB,
  Instruction_PMOVMSKB,
  Instruction_PMULHUW,
  Instruction_PMULHW,
  Instruction_PMULLW,
  Instruction_POP,
  Instruction_POPA,
  Instruction_POPAD,
  Instruction_POPF,
  Instruction_POPFD,
  Instruction_POR,
  Instruction_PREFETCHNTA,
  Instruction_PREFETCHT0,
  Instruction_PREFETCHT1,
  Instruction_PREFETCHT2,
  Instruction_PSADBW,
  Instruction_PSHUFW,
  Instruction_PSLLD,
  Instruction_PSLLQ,
  Instruction_PSLLW,
  Instruction_PSRAD,
  Instruction_PSRAW,
  Instruction_PSRLD,
  Instruction_PSRLQ,
  Instruction_PSRLW,
  Instruction_PSUBB,
  Instruction_PSUBD,
  Instruction_PSUBSB,
  Instruction_PSUBSW,
  Instruction_PSUBUSB,
  Instruction_PSUBUSW,
  Instruction_PSUBW,
  Instruction_PUNPCKHBW,
  Instruction_PUNPCKHDQ,
  Instruction_PUNPCKHWD,
  Instruction_PUNPCKLBW,
  Instruction_PUNPCKLDQ,
  Instruction_PUNPCKLWD,
  Instruction_PUSH,
  Instruction_PUSHA,
  Instruction_PUSHAD,
  Instruction_PUSHF,
  Instruction_PUSHFD,
  Instruction_PXOR,
  Instruction_RCL,
  Instruction_RCPPS,
  Instruction_RCPSS,
  Instruction_RCR,
  Instruction_RDMSR,
  Instruction_RDPMC,
  Instruction_RDTSC,
  Instruction_RETF,
  Instruction_RETN,
  Instruction_ROL,
  Instruction_ROR,
  Instruction_RSM,
  Instruction_RSQRTPS,
  Instruction_RSQRTSS,
  Instruction_SAHF,
  Instruction_SAR,
  Instruction_SBB,
  Instruction_SCASB,
  Instruction_SCASD,
  Instruction_SCASW,
  Instruction_SETA,
  Instruction_SETC,
  Instruction_SETE,
  Instruction_SETG,
  Instruction_SETL,
  Instruction_SETNA,
  Instruction_SETNC,
  Instruction_SETNE,
  Instruction_SETNG,
  Instruction_SETNL,
  Instruction_SETNO,
  Instruction_SETNP,
  Instruction_SETNS,
  Instruction_SETO,
  Instruction_SETP,
  Instruction_SETS,
  Instruction_SFENCE,
  Instruction_SGDT,
  Instruction_SHL,
  Instruction_SHLD,
  Instruction_SHR,
  Instruction_SHRD,
  Instruction_SHUFPS,
  Instruction_SIDT,
  Instruction_SLDT,
  Instruction_SMSW,
  Instruction_SQRTPS,
  Instruction_SQRTSS,
  Instruction_STC,
  Instruction_STD,
  Instruction_STI,
  Instruction_STMXCSR,
  Instruction_STOSB,
  Instruction_STOSD,
  Instruction_STOSW,
  Instruction_STR,
  Instruction_SUB,
  Instruction_SUBPS,
  Instruction_SUBSS,
  Instruction_SYSENTER,
  Instruction_SYSEXIT,
  Instruction_TEST,
  Instruction_UCOMISS,
  Instruction_UD2,
  Instruction_UNPCKHPS,
  Instruction_UNPCKLPS,
  Instruction_VERR,
  Instruction_VERW,
  Instruction_WAIT,
  Instruction_WBINVD,
  Instruction_WRMSR,
  Instruction_XADD,
  Instruction_XCHG,
  Instruction_XLATB,
  Instruction_XOR,
  Instruction_XORPS
};
