<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>
  <title>Tor: Mac OS X : Installation</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://tor.eff.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.fr">Accueil</a>
<a href="../overview.html.fr">Vue d'ensemble</a>
<a href="../download.html.fr">Téléchargement</a>
<a href="../documentation.html.fr">Docs</a>
<a href="../volunteer.html.fr">Contribuer</a>
<a href="../people.html.fr">Auteurs</a>
<a href="../donate.html.fr">Dons!</a>
        </td>
        <td class="banner-right">
	<img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-osx.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym> <a href="tor-doc-osx.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-osx.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16">
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Utiliser le client <a href="../index.html.fr">Tor</a> sous Mac OS X</h1>
<br>
<p>
<b>Notez que ce sont les instructions d'installation pour utiliser le client Tor sous
MacOSX. Si vous voulez installer un relai Tor pour aider à faire grandir le
réseau (n'hésitez pas), lisez la page <a
href="../docs/tor-doc-server.html.fr">Configurer un serveur</a>.</b>
</p>
<hr>
<a id="installing"></a>
<h2><a class="anchor" href="#installing">Etape Un : Télécharger et installer Tor</a></h2>
<br>
<p>
Les dernières versions stables et expérimentales de Tor pour Macintosh
OS X contiennent <a href="../index.html.fr">Tor</a>,
<a href="http://www.vidalia-project.net/">Vidalia</a> (une interface graphique pour Tor),
et <a href="http://www.privoxy.org/">Privoxy</a> (un proxy web filtrant)
dans un seul paquet, préconfigurés pour fonctionner ensemble.
<a href="../download.html.fr">Télécharger un paquet sur la page de
téléchargement</a>.
</p>
<p>Notre Installateur pour Tor devrait rendre les choses assez simples. Ci-dessous une
copie d'écran de la page de configuration :</p>
<img alt="page de lancement de l'installateur de tor"
src="../img/screenshot-osx-installer-splash.png"
border="1" width="620" height="440">
<p>Une fois l'installation terminée, vous pouvez lancer Vidalia en sélectionnant son icône
depuis le répertoire "Applications". Un oignon noir avec une croix rouge signifie
que Tor n'est pas actif. Vous pouvez le démarrer en sélectionnant "Start" dans le
menu « Tor » en haut de votre écran.
</p>
<p>Losque Tor est lancé, l'icône Vidalia ressemble à ce qui suit :
</p>
<img alt="vidalia utilisant tor"
src="../img/screenshot-osx-vidalia.png"
border="1" width="223" height="100">
<p>Privoxy est installé avec le reste du paquet
Tor. Une fois qu'il est installé, il sera démarré automatiquement au prochain
redémarrage de votre machine.
Il n'est pas nécessaire de configurer Privoxy pour utiliser Tor &mdash; une version adaptée
 pour Tor de Privoxy a été installée avec le reste du paquet.
</p>
<hr>
<a id="using"></a>
<h2><a class="anchor" href="#using">Etape Deux : Configurer vos applications pour utiliser Tor</a></h2>
<br>
<p>Après avoir installé Tor et Privoxy, vous devez configurer vos
applications pour les utiliser. La prochaine action consiste à configurer le navigateur web.</p>
<p>Si vous utilisez Firefox (ce que nous vous recommandons), installez simplement <a
href="https://addons.mozilla.org/firefox/2275/">l'extension Torbutton</a>,
redémarrez votre Firefox, cliquez sur le bouton rouge « Tor Disabled »
pour l'activer, et vous êtes prêt : </p>
<img alt="Torbutton plugin for Firefox"
src="../img/screenshot-torbutton.png"
border="1" width="161" height="78">
<br>
<p>
(<a href="http://freehaven.net/~squires/torbutton/">En savoir plus sur
Torbutton ici</a>.
Si vous envisagez de faire tourner Firefox sur un ordinateur différent de Tor, jetez un œil à l'entrée <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#SocksListenAddress">FAQ
traitant de l'utilisation de Tor sur un ordinateur différent</a>. Si vous avez besoin
d'utiliser un navigateur autre que Firefox, vous aurez à <a href="../docs/tor-doc-web.html.fr">configurer son proxy vous même</a>.)
</p>
<h3>Apple Safari</h3>
<p>Si vous souhaitez utiliser Tor avec Safari, vous aurez à changer
la configuration du réseau. Selectionnez « Préférences Réseau» depuis le menu Apple |
Réseau :</p>
<img alt="Network settings"
src="../img/screenshot-osx-choose-network.png"
border="1" width="421" height="321">
<p>Sélectionnez l'interface réseau pour laquelle vous souhaitez utiliser Tor. Si vous utilisez
plus d'une seule interface, vous devez changer les paramètres Proxy pour
chacune.</p>
<img alt="Network preferences"
src="../img/screenshot-osx-choose-interface.png"
border="1" width="595" height="577">
<p>
<p>Sélectionnez et entrez 127.0.0.1 et le port 8118 pour
"Proxy Web (HTTP)" et "Proxy Web sécurisé (HTTPS)".
Vous devriez en faire de même pour "Proxy FTP" et "Proxy Gopher" ; regardez <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#FtpProxy">cette
note</a> à propos de Tor et des mandataires ftp. Conservez votre paramètre "Utiliser le mode FTP passif (PASV)"
tel qu'il était.</p>
<img alt="Proxy settings"
src="../img/screenshot-osx-proxy-settings.png"
border="1" width="595" height="577">
<p>L'utilisation de privoxy est <strong>nécessaire</strong> parceque <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">les navigateurs
laisse filtrer vos
requètes DNS quand ils utilisent le proxy socks directement</a>, ce qui est domageable pour
votre anonymat. Privoxy retire également, certains entêtes dangereux de vos
requêtes web, et bloque certains sites pénibles comme Doubleclick.</p>
<p>Pour torréfier d'autres applications qui savent utiliser des proxys HTTP, il suffit
de leur indiquer de passer par Privoxy (c'est à dire "localhost" sur le port "8118"). Pour celles qui utilisent SOCKS
directement (messagerie instantanée, Jabber, IRC, etc), vous pouvez les faire passer
directement par Tor ("localhost", prot "9050"), mais regardez d'abord <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">
cette entrée de la FAQ</a> qui vous dira les risques que cela comporte. Pour les applications
qui n'utilisent ni SOCKS ni HTTP, jetez un oeil à <a
href="http://www.taiyo.co.jp/~gotoh/ssh/connect.html">connect</a> ou
<a href="http://www.dest-unreach.org/socat/">socat</a>.</p>
<p>Pour davantage d'information sur comment torréfier d'autres applications, voyez le
<a href="http://wiki.noreply.org/wiki/TheOnionRouter/TorifyHOWTO">Torréfaction
HOWTO</a>.
</p>
<hr>
<a id="verify"></a>
<h2><a class="anchor" href="#verify">Étape trois : s'assurer que ça fonctionne</a></h2>
<br>
<p>
Ensuite, vous devriez essayez d'utiliser votre navigateur avec Tor et vous
assurer que votre adresse IP est bien anonymisée. Cliquez sur
<a href="http://lefkada.eecs.harvard.edu/cgi-bin/ipaddr.pl?tor=1">le
détecteur Tor</a>
et voyez s'il pense que vous passer par Tor ou non.
(si ce site est inaccessible, voyez <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#IsMyConnectionPrivate">cette entrée de la
FAQ</a> pour davantage de suggestion sur comment tester votre Tor.)
</p>
<p>Si vous avez un pare-feu personnel qui limite la
capacité de votre ordinateur à se connecter à lui même, assurez vous de permettre les connexions à
vos applications locales aux ports 8118 et 9050. Si
votre pare-feu bloque les connexions sortantes, faites un trou pour
qu'il puisse au moins se connecter sur les ports 80 et 443, et lisez <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#FirewalledClient">cette entrée de la
FAQ</a>.
</p>
<p>Si ça ne marche toujours pas, regardez cette <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">entrée de la
FAQ</a> pour quelques astuces.</p>
<hr>
<a id="server"></a>
<h2><a class="anchor" href="#server">Étape quatre : configurer Tor comme serveur</a></h2>
<br>
<p>Le réseau Tor repose sur des contributeurs qui donnent de la bande passante. Plus il
y a de gens qui font tourner un serveur, plus le réseau sera rapide. Si vous avez
au moins 20 kilo octets/s dans chaque sens, aidez Tor en le configurant
comme serveur. Nous avons plusieurs options qui rendent Tor facile
et agréable, par exemple la limitation de bande passante consommée, les contrôles sur ports de sortie pour
que vous puissiez limiter votre expositions aux plaintes, et le support des
adresses dynamiques.</p>
<p>Avoir des serveurs dans plein de lieux différents sur Internet c'est
ce qui sécurise les utilisateurs. <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#ServerAnonymity">Vous
auriez également d'avantage d'anonymat</a>,
puisque les sites distants ne pourraient pas savoir si une connexion vient de votre
ordinateur ou si elle est relayée d'un autre.</p>
<p>Lisez d'avantage sur le guide <a href="../docs/tor-doc-server.html.fr">configurer un serveur</a>
</p>
<hr>
<a id="uninstall"></a>
<h2><a class="anchor" href="#uninstall">Comment désinstaller Tor et Privoxy</a></h2>
<br>
<p>La série des Tor 0.1.0.x et au delà ont une ligne de commande ou un désinstalleur
Terminal-centré. Si vous voulez supprimer Tor de votre OSX, voici comment faire :</p>
<p>Revenez aux paramétrages d'origine de votre proxy.
   Si vous souhaitez simplement ne plus passer par Tor, vous pouvez vous arrêter là.</p>
<p>Si vous voulez supprimer Tor complètement, et que votre compte a des privilèges
d'administration, procédez comme suit :</p>
<ol>
<li> Ouvrez un terminal ou une session x-term.</li>
<li> cd /Library/Tor</li>
<li> sudo -s</li>
<li> ./uninstall_tor_bundle.sh</li>
</ol>
<p>Tor et Privoxy sont maintenant complètement supprimés de votre système.</p>
<p>Si vous utilisez une version qui ne fourni pas
le script uninstall_tor_bundle, vous aurez à manuellement
détruire ce qui suit :</p>
<ul>
<li>/Library/Tor</li>
<li>/Library/Privoxy</li>
<li>/usr/bin/tor</li>
<li>/usr/bin/tor_resolve</li>
<li>/var/log/tor</li>
<li>/usr/share/man/man1/tor.1</li>
<li>/usr/share/man/man1/tor-resolve.1</li>
<li>/usr/share/man/man1/torify.1</li>
<li>/Library/Receipts/Privoxy.pkg/</li>
<li>/Library/Receipts/privoxyconf.pkg/</li>
<li>/Library/Receipts/Tor.pkg/</li>
<li>/Library/Receipts/torstartup.pkg/</li>
</ul>
<hr>
<p>Si vous avez des suggestions pour étoffer ce document, n'hésitez à <a
href="../contact.html.fr">nous les faire parvenir</a>. Merci !</p>
  </div><!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.fr" class="smalllink">Webmaster</a></i> -
      Dernière modification : Thu May 24 20:05:18 2007
      -
      Dernière compilation : Thu May 24 20:09:59 2007
     </p>
     <p>
       Cette page est aussi disponible dans les langues suivantes :
       <a href="tor-doc-osx.html.en">English</a>, <a href="tor-doc-osx.html.it">Italiano</a>, <a href="tor-doc-osx.html.pl">polski</a>.<br>
       Comment configurer la <a href="http://www.debian.org/intro/cn#howtoset">langue par défaut du document</a>.
     </p>
  </div>
</body>
</html>
