#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# Modifications :
#
# 	02/22/2000, Renaud Deraison : added more communities
#	06/08/2000, Renaud Deraison : fixed a problem in the packets sent
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10264);
 script_cve_id("CAN-1999-0517");
 
 name["english"] = "Default community names of the SNMP Agent";
 script_name(english:name["english"]);
 
 desc["english"] = "By allowing remote users access to the SNMP Agent with the well known public
community names, remote attackers may gain very valuable information
(depending on which MIBs are installed) about the system and networks they
are attacking. Also if a 'writeall' access can be gained, this could be a
huge security hole, enabling attackers to wreck complete havoc, route
packets and etc.

Risk factor : High

More Information:
http://www.securiteam.com/exploits/Windows_NT_s_SNMP_service_vulnerability.html
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Default community names of the SNMP Agent";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 
 exit(0);
}

#
# The script code starts here
#


for (i = 0; i < 20; i = i + 1)
{
	srcaddr = this_host();
	dstaddr = get_host_ip();

	if (i == 0)
	{
	 community = "public";
	}
	if (i == 1)
	{
	 community = "private";
	}
	if (i == 2)
	{
	 community = "system";
	}
	if(i == 3)
	{
	 community = "write";
	}
	
	if(i == 4)
	{
	  community = "all";
	}

	if(i == 5)
	{
	 community = "monitor";
	}
	
	if(i==6)
	{
	 community = "agent";
	}
	
	if(i == 7)
	{
	 community = "manager";
	}
	
	if(i == 8)
	{
	 community = "OrigEquipMfr";
	}
	
	if(i == 9)
	{
	 community = "admin";
	}
	
	if(i == 10)
	{
	 community = "default";
	}
	
	if(i == 11)
	{
	 community = "password";
	}
	
	if(i == 12)
	{
	 community = "tivoli";
	}
	
	if(i == 13)
	{
	 community = "openview";
	}
	
	if(i == 14)
	{
	 community = "community";
	}
	
	
	if(i == 15)
	{
	 community = "snmp";
	}
	
	if(i == 16)
	{
	 community = "snmpd";
	}


	if(i == 17)
	{
	 community = "Secret C0de";
	}
	
	if(i == 18)
	{
	 community = "security";
	}
	
	 if (i == 19)
	{
	 community = "all private";
	}
	
	
	SNMP_BASE = 31;
	COMMUNITY_SIZE = strlen(community);
	
	sz = COMMUNITY_SIZE % 256;
	

	len = SNMP_BASE + COMMUNITY_SIZE;
	len_hi = len / 256;
	len_lo = len % 256;
	sendata = raw_string(
		0x30, 0x82, len_hi, len_lo, 
		0x02, 0x01, 0x00, 0x04,
		sz);
		
		
	sendata = sendata + community +
		raw_string( 0xA1, 
		0x18, 0x02, 0x01, 0x01, 
		0x02, 0x01, 0x00, 0x02, 
		0x01, 0x00, 0x30, 0x0D, 
		0x30, 0x82, 0x00, 0x09, 
		0x06, 0x05, 0x2B, 0x06, 
		0x01, 0x02, 0x01, 0x05, 
		0x00); 

	
	dstport = 161;
	soc = open_sock_udp(dstport);
	send(socket:soc, data:sendata);
	result = recv(socket:soc, length:4096);
	if (strlen(result)>0)
	{
	  match = 1;
	  for (_i = 0 ; _i < COMMUNITY_SIZE ; _i = _i + 1)
	  {
	    if(!(result[_i+7] == community[_i]))
	      match = 0;
	  }

	  if(match)
	  {
	  hole_data = string("SNMP Agent responded as expected with community name: ", community);
	  security_hole(port:161, data:hole_data, protocol:"udp");
	  }
	}
	close(soc);
}
