/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*********************\
* 		      *
*  KlO  List  *
*  DEFINITIONS	      *
* 		      *
\*********************/

#ifndef INCLUDE_Kl_LIST_H
#define INCLUDE_Kl_LIST_H
#ifdef NEED_ALLOCA_H
#include <alloca.h>
#endif

/* type */

typedef struct _KlList {
    KlKLONE_HEADER;
    int size;				/* size of list  ( # of elements ) */
    KlO *list;				/* malloced region to store elements */
}      *KlList;				/* so that lists are expandable now */

typedef KlList KlVector;		/* vectors are actually lists */
typedef KlList KlAssign;		/* Assigns are actually (setq ...) */
typedef KlList KlStructure;		/* [# StructureName field-values...] */
typedef KlList KlLocator;		/* so are locators */

/* a list template for easier static type checking */

#define KlTypedefListOf(type_of_elements, typename) \
    typedef struct {KlKLONE_HEADER; int size; type_of_elements *list;} *typename

EXT KlList KlErrorHandlers;

/* exported functions */

EXT KlList KlListMake();
EXT KlList KlListMakeKl();
EXT KlList KlListNMake();
EXT KlList KlListNEvalAndMakeFromArray();
#if __STDC__
EXT KlList KlListMakeV(int size, ...);
EXT KlO KlListAppendV(KlList list, int size, ...);
#else
EXT KlList KlListMakeV _ANSI_ARGS_(VARARGS);
EXT KlO KlListAppendV _ANSI_ARGS_(VARARGS);
#endif
EXT KlList KlListKl();
EXT KlList KlListNullTerminated();
EXT KlList KlVectorMakeQ();
EXT KlList KlVectorMake();
EXT KlO KlListEval();
EXT KlO KlListEvalAndTrace();
EXT KlO KlListPrint();
EXT KlO KlListFree();
EXT KlO KlListNth();
EXT KlO KlList_replace_nth();
EXT KlO KlList_delete_nth();
EXT KlO KlList_concat();
EXT KlO KlListEqual();
EXT KlO KlListExecute();
EXT KlO *Kl_flatten_pairlist();
EXT KlO KlListQsort();
EXT KlO KlListCopy();
EXT KlO KlListGet();
EXT KlO KlListCoerce();
EXT KlO KlListAppend();
EXT KlO KlListAppend2();
EXT KlList KlParsePath();
EXT KlAssign KlAssignMake();

EXT KlList KlLocatorMakeFromColl();

#define KlListPairMake(e1, e2) KlListMakeV(2, e1, e2)
#define KlListTripletMake(e1, e2, e3) KlListMakeV(3, e1, e2, e3)

/* if an error can occur while filling slots, use KlListNMakeZ */
#define KlListNMakeZ(o, N) (o = KlListNMake(N),bzero(o->list,(N)*sizeof(KlO)))

/* temporary malloc space. kl is a KlList variable, N is in words!*/
EXT KlList Kl__InternalDummyList;
#define KlListAlloca(N) (Kl__InternalDummyList = KlListNMake(N), \
		     Kl__InternalDummyList->size = -1, \
		     Kl__InternalDummyList->list)


#ifndef NO_ALLOCA
#if defined(__NUTC__)
#define KlAlloca(N) ((KlO *) _alloca((N)*sizeof(KlO)))
#else
#define KlAlloca(N) ((KlO *) alloca((N)*sizeof(KlO)))
#endif
#else
#define KlAlloca(N) KlListAlloca(N)
#endif

/* methods */

EXT KlType KlListType;
EXT KlType KlVectorType;
EXT KlType KlLocatorType;
EXT KlType KlSequenceType;
EXT KlType KlListInlineType;
EXT KlType KlAssignType;
EXT KlType KlStructureType;

#define KlListStore(l, i, e) KlIncRef((l)->list[i] = (KlO) (e))
#define KlListStoreDecl KlO *KlListStoreDeclPos
#define KlListStoreReset(l) KlListStoreDeclPos = (l)->list
#define KlListStoreDReset(l) KlO *KlListStoreDeclPos = (l)->list
#define KlListStoreAdd(e) KlIncRef(*KlListStoreDeclPos++ = (KlO) (e))

#define KlListLastElt(l) (((KlList) l)->list + ((KlList) l)->size)

#define KlLocatorCheck(l)     ((((KlList) (l))->size < 2 || \
    (((KlList) (l))->size==2 && ((KlList) (l))->list[0]==(KlO) KlA_assign)) ? \
    (KlLocator) KlError1(KlE_BAD_LOCATOR, KlListCast(l)) : (KlLocator) l)
#define KlIsALocator(obj)  ((obj)->type == KlLocatorType)
#define KlMustBeLocator(obj, n)  KlArgumentMustBe(obj, n, KlLocatorType)

#define KlIsAList(obj) KlHasTrait(obj, KlTrait_list)
#define KlMustBeList(obj, n) KlArgumentMustHaveTrait(obj, n, KlTrait_list)
#define KlMustBeEvenList(o, n) \
    if(o->size % 2) KlBadArgument(o, n, "list with even number of elements")
#define KlMustBeNonNilList(o, n) \
    if(NIL == (KlO) o) KlBadArgument(o, n, "non-nil list")

#define KlIsAVector(obj)  ((obj)->type == KlVectorType)
#define KlMustBeVector(obj, n)  KlArgumentMustBe(obj, n, KlVectorType)

#define KlIsAnAssign(obj)  ((obj)->type == KlAssignType)
#define KlMustBeAssign(obj, n)  KlArgumentMustBe(obj, n, KlAssignType)
#define KlAssignVar(obj) (((KlAssign) (obj))->list[1])
#define KlAssignVal(obj) (((KlAssign) (obj))->list[2])

#define KlIsAStructure(obj)  ((obj)->type == KlStructureType)
#define KlMustBeStructure(obj, n)  KlArgumentMustBe(obj, n, KlStructureType)
#define KlVectorIsAStructure(v) ( \
    ((v)->size > 2) && ((v)->list[0] == (KlO) KlA_SHARP) \
    && KlIsAnAtom((v)->list[1]))

#define KlIsAListInline(obj)  ((obj)->type == KlListInlineType)
#define KlMustBeListInline(obj, n)  KlArgumentMustBe(obj, n, KlListInlineType)

#endif					/* INCLUDE_Kl_LIST_H */
