/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*********\
*         *
* KL_LINK *
* BODY    *
*         *
\*********/

#include "EXTERN.h"
#include "klone.h"
#include "kl_number.h"
#include "kl_atom.h"
#include "INTERN.h"
#include "kl_link.h"


/* links are ``soft links'' allowing you to point to objects without 
 * managing a reference count on them 
 */

/* KlLinkMake
 * we create a link by just storing a pointer to object, and keeping the 
 * type of the original object to check for gross errors
 * 
 * This is like the C ``&'' operator
 */

KlLink
KlLinkMake(obj)
    KlO obj;				/* object pointed to */
{
    KlLink object = (KlLink)  KlOMake(KlLinkType);

    object->link = obj;
    object->linktype = obj->type;
    return object;
}    

/* KlLinkDereference
 * returns object pointed to if still valid, or evaluated default (or nil)
 * 
 * This is like C ``*'' operator
 */

KlO
KlLinkDereference(link)
    KlLink link;
{
    if (KlIsALink(link)) {
	/* object is valid if still of same type and refcount is not 0 */
	if (link->link->type == link->linktype
	    && KlRef(link->link)) {
	    return link->link;
	} else {				/* invalid */
	    return NIL;
	}
    } else {
	return (KlO) link;
    }
}


/*****************************************************************************\
* 				  TYPE INIT                                   *
\*****************************************************************************/

KlLinkInit()
{
    KlDeclareType(&KlLinkType, "Link", sizeof(struct _KlLink));

    KlDeclareSubr(KlLinkMake, "link-set", 1);
    KlDeclareSubr(KlLinkDereference, "link-get", 1);
}
