/*****************************************************************************\
*                                                                             *
* 				  EVAL ORDER                                  *
*                                                                             *
\*****************************************************************************/

/* performs some compile-time checks on compiler and output #define 
 * statements on stdout summarizing the findings 
 */

/* tests evaluation order of the compiler
 * outputs #define LEFT_TO_RIGHT_EVAL or nothing
 * 
 * tests if sizeof(int) < sizeof(char *), outputs 
 * #define POINTERS_BIGGER_THAN_INTEGERS in this case
 */

int l2r = 0;
int r2l = 0;
int verbose = 0;

main(argc, argv)
    int argc;
    char **argv;
{
    int i = 0;

    if (argc > 1 && !strcmp(argv[1], "-v")) {
	verbose = 1;
    }

/********************************************* POINTERS_BIGGER_THAN_INTEGERS */

    if (sizeof(char *) > sizeof(int)) {
	puts("#define POINTERS_BIGGER_THAN_INTEGERS");
    }

/******************************************************** LEFT_TO_RIGHT_EVAL */

    f2(i++, i++);
    i = 0;
    f3(i++, i++, i++);
    i = 0;
    f4(i++, i++, i++, i++);
    i = 0;
    f5(i++, i++, i++, i++, i++);

    if (verbose) {
	if (l2r == 4)
	    puts("Left to right order");
	else if (r2l == 4)
	    puts("Right to left order");
	else
	    printf("No consistent order: %d left-to-right, %d right-to-left\n",
		   l2r, r2l);
    } else {
	if (l2r == 4)
	    puts("#define LEFT_TO_RIGHT_EVAL");
    }
    exit(0);
}

f2(i, j)
    int i,j;
{
    if (i == 0 && j == 1)
	l2r++;
    if (i == 1 && j == 0)
	r2l++;
    if (verbose)
	printf("f2: i=%d, j=%d\n", i, j);
}


f3(i, j, k)
    int i,j,k;
{
    if (i == 0 && j == 1 && k == 2)
	l2r++;
    if (i == 2 && j == 1 && k == 0)
	r2l++;
    if (verbose)
	printf("f3: i=%d, j=%d, k=%d\n", i, j, k);
}

f4(i, j, k, l)
    int i,j,k,l;
{
    if (i == 0 && j == 1 && k == 2 && l == 3)
	l2r++;
    if (i == 3 && j == 2 && k == 1 && l == 0)
	r2l++;
    if (verbose)
	printf("f4: i=%d, j=%d, k=%d, l=%d\n", i, j, k, l);
}

f5(i, j, k, l, m)
    int i,j,k,l,m;
{
    if (i == 0 && j == 1 && k == 2 && l == 3 && m == 4)
	l2r++;
    if (i == 4 && j == 3 && k == 2 && l == 1 && m == 0)
	r2l++;
    if (verbose)
	printf("f5: i=%d, j=%d, k=%d, l=%d, m=%d\n", i, j, k, l, m);
}
