/*****************************************************************************\
*                                                                             *
* 			       Koala's C-Lists                                *
* 				 Definitions                                  *
*                                                                             *
\*****************************************************************************/
/* Copyright (c) 1996  Colas Nahaboo, http://www.inria.fr/koala/colas */
/* a KCList is a simple implementation of dynamic lists in C, array style
 */

#ifndef KCLIST_H
#define KCLIST_H

typedef struct _KCList {		/* KCList is a pointer to structure */
    unsigned int size;				/* number of elements */
    void **list;			/* array of elements (void *) */
} *KCList;

/* a template to create typed ones. element_type must be a pointer type */

#define KCListTypedef(element_type, new_kclist_type_name) \
  typedef struct {unsigned int size; element_type *list;} *new_kclist_type_name;

/*****************************************************************************\
* 			ANSI C  K&R compatibilty layer                        *
\*****************************************************************************/
/* defines a _P_ macro to include ANSI declaration prototypes */
#ifdef _P_
#undef _P_
#endif
#if defined(__STDC__) || defined(__cplusplus)
#   define _USING_PROTOTYPES_ 1
#   define _P_(x)	x
#   ifdef __cplusplus
#       define VARARGS (...)
#   else
#       define VARARGS ()
#   endif
#else /* K&R C */
#   define _P_(x)	()
#endif /* K&R C */

KCList KCListNew();
KCList KCListNewN _P_((int size));
void KCListFree _P_((KCList kclist));
unsigned int KCListAppend _P_((KCList kclist, void *element));

#define KCListElt(kclist, offset, type) ((type) (kclist)->list[offset])
#define KCListSize(kclist) (kclist)->size

#endif /* !KCLIST_H */
