/*****************************************************************************\
*                                                                             *
* 			       Koala's C-Lists                                *
* 				Implementation                                *
*                                                                             *
\*****************************************************************************/
/* Copyright (c) 1996  Colas Nahaboo, http://www.inria.fr/koala/colas */
/* a KCList is a simple implementaion of dynamic lists in C, array style
 */

#include "kclist.h"

KCList 
KCListNew()
{
    KCList kclist = (KCList) malloc(sizeof(struct _KCList));
    kclist->size = 0;
    kclist->list = (void **) malloc(1);
    return kclist;
}

KCList 
KCListNewN(size)
    int size;
{
    KCList kclist = (KCList) malloc(sizeof(struct _KCList));

    kclist->size = size;
    kclist->list = (void **) malloc(size *sizeof(void *));
    return kclist;
}

void
KCListFree(kclist)
    KCList kclist;
{
    free(kclist->list);
    free(kclist);
}

void
KCListFreeWithElements(kclist)
    KCList kclist;
{
    void **ptr = kclist->list;
    void **end = ptr + kclist->size;
    while (ptr < end)
	free(*ptr++);
    KCListFree(kclist);
}

void
KCListFreeWithElementsOrNulls(kclist)
    KCList kclist;
{
    void **ptr = kclist->list;
    void **end = ptr + kclist->size;
    while (ptr < end) {
	if (*ptr)
	    free(*ptr);
	ptr++;
    }
    KCListFree(kclist);
}

unsigned int
KCListAppend(kclist, element)
    KCList kclist;
    void *element;
{
    kclist->list = (void **) realloc(kclist->list, 
				     ++(kclist->size) * sizeof(void *));
    kclist->list[kclist->size - 1] = element;
    return kclist->size;
}
