#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <errno.h>

#include "KlLib.h"

int KlExp_r;				/* X fd */
static Display *display;
Window b_win;				/* last created window */
int b_x = 0;
int b_y = 0;
int b_w = 10;
int b_h = 10;

/*****************************************************************************\
* 				   WRAPPERS                                   *
\*****************************************************************************/

GC cleargc, drawgc;

KlO
drawinit(KlString name, KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    Window win = XCreateSimpleWindow(display, DefaultRootWindow(display),
				     x->number, y->number, 
				     w->number, h->number, 
				     0, 0, WhitePixel(display, 0));
    b_win = win;
    XStoreName(display, win, name->string);
    XMapWindow(display, win);
    XFlush(display);

    return (KlO) KlNumberMake(win);
}

KlO
drawrect(KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    XFillRectangle(display, b_win, drawgc, x->number, y->number, 
		   w->number, h->number);
    return NIL;
}

KlO
drawclear(KlNumber x, KlNumber y, KlNumber w, KlNumber h)
{
    XFillRectangle(display, b_win, cleargc, x->number, y->number, 
		   w->number, h->number);
    return NIL;
}

KlO
drawsync()
{
    XSync(display, 0);
    return NIL;
}

void
KlExpHandler(name, fd, closure)
    char *name;
    int fd;
    void *closure;
{
    XEvent e;
process_event:
    XNextEvent(display, &e);
    if (XPending(display))
	goto process_event;
}

void expmain()
{
    KlDeclareSubr(drawinit, "drawinit", 5);
    KlDeclareSubr(drawrect, "drawrect", 4);
    KlDeclareSubr(drawclear, "drawclear", 4);
    KlDeclareSubr(drawsync, "drawsync", 0);

    display = XOpenDisplay(0);
    KlExp_r = ConnectionNumber(display);

    KlAddInput("Exp", KlExp_r, KlExpHandler, 0);

    cleargc = XCreateGC(display, DefaultRootWindow(display), None, NULL);
    XSetFunction(display, cleargc, GXcopy);
    XSetForeground(display, cleargc, WhitePixel(display, 0));
    XSetBackground(display, cleargc, WhitePixel(display, 0));
    drawgc = XCreateGC(display, DefaultRootWindow(display), None, NULL);
    XSetFunction(display, drawgc, GXcopy);
    XSetForeground(display, drawgc, BlackPixel(display, 0));
    XSetBackground(display, cleargc, BlackPixel(display, 0));
    XSync(display, 0);
}

void
KlExpHandler()
{
    XEvent e;
process_event:
    XNextEvent(display, &e);
    if (XPending(display))
	goto process_event;
}
