/*
 * Copyright (c) 2004 Marcus Glocker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef __linux__
#include "../libbsd/strlcpy.h"
#endif

/* fparse()
 *	parses a two column-data file (parameter parameter-value)
 *	ignores comment (#)
 *	spaces in the second column (parameter-value) are read
 * Return:
 *	<row number> = success, -1 = failed
 *
 */

int
fparse(char *dst, const char *src, const char *file, const int dsize)
{
	int		fd;
	int		d = 0, i = 0, r = 1, size = 8192;
	char		a[2][size], t[size], *b, *b_copy;
	struct stat	s;

	if ((fd = open(file, O_RDONLY)) == -1)
		return -1;
	if (stat(file, &s) == 0) {
		if ((b = malloc(s.st_size + 1)) == NULL)
			return -1;
		b[s.st_size] = '\0';
		b_copy = b;
	} else {
		return -1;
	}
	if (read(fd, b, s.st_size) == -1)
		return -1;
	close(fd);

	for (; *b != '\0'; b++) {
		if (*b == '#') {
			while (*b != '\n')
				b++;
			r++;
		}
		if (*b != ' ' && *b != '\t' && *b != '\n') {
			if (i != size-1) {
				t[i] = *b;
				i++;
			}
		}
		if (i == 0)
			continue;
		if (*b == ' ' || *b == '\t' || *b == '\n') {
			if (d == 1 && b[0] == ' ') {
				if (i != size - 1) {
					t[i] = *b;
					i++;
				}
			} else {
				t[i] = '\0';
				strlcpy(a[d], t, sizeof(a[d]));
				i = 0;
				if (d == 0) {
					d++;
				} else {
					r++;
					if (strcmp(a[d - 1], src) == 0) {
						strlcpy(dst, a[d], dsize);
						free(b_copy);
						return r;
					}
					d--;
				}
			}
		}
	}

	free(b_copy);
	return -1;
}
