/* $Id: proto_sjeng.cc,v 1.7 2002/04/24 05:25:09 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "eboard.h"
#include "protocol.h"
#include "global.h"

SjengProtocolParser::SjengProtocolParser() : XBoardProtocolParser() {
  strcpy(ComputerName,"Sjeng");
  strcpy(EngineCommandLine,"sjeng");
  want_path_pane=1;
}

void SjengProtocolParser::initEngine() {
  char z[32];
  createGame();
  global.network->writeLine("xboard");
  global.network->writeLine("protover 2");
  global.network->writeLine("nopost");

  if (ThinkAlways)
    global.network->writeLine("hard");
  else
    global.network->writeLine("easy");

  global.network->writeLine("new");

  switch(Variant) {
  case CRAZYHOUSE: global.network->writeLine("variant crazyhouse"); break;
  case SUICIDE:    global.network->writeLine("variant suicide"); break;
  case LOSERS:     global.network->writeLine("variant losers"); break;
  case GIVEAWAY:   global.network->writeLine("variant giveaway"); break;
  }

  if (SecsPerMove>0) {
    sprintf(z,"st %d",SecsPerMove);
    global.network->writeLine(z);
  }

  if (MaxDepth>0) {
    sprintf(z,"sd %d",MaxDepth);
    global.network->writeLine(z);
  }

  if (EngineWhite) {
    global.network->writeLine("white");
    global.network->writeLine("go");
  }
}

void SjengProtocolParser::createDialog() {
  int i;
  GtkWidget *fr,*v,*rd[5],*vl;
  GSList *rg;

  XBoardProtocolParser::createDialog();

  // add variant pane
  fr=gtk_frame_new("Variant");
  gtk_frame_set_shadow_type(GTK_FRAME(fr),GTK_SHADOW_ETCHED_IN);
  v=gtk_vbox_new(TRUE,2);
  gtk_container_add(GTK_CONTAINER(fr),v);

  rd[0]=gtk_radio_button_new_with_label( 0, "Normal Chess" );
  rg=gtk_radio_button_group(GTK_RADIO_BUTTON(rd[0]));
  rd[1]=gtk_radio_button_new_with_label(rg, "Crazyhouse" );
  rg=gtk_radio_button_group(GTK_RADIO_BUTTON(rd[1]));
  rd[2]=gtk_radio_button_new_with_label(rg, "Suicide" );
  rg=gtk_radio_button_group(GTK_RADIO_BUTTON(rd[2]));
  rd[3]=gtk_radio_button_new_with_label(rg, "Losers" );
  rg=gtk_radio_button_group(GTK_RADIO_BUTTON(rd[3]));
  rd[4]=gtk_radio_button_new_with_label(rg, "Giveaway" );

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rd[0]), TRUE);
  for(i=0;i<5;i++) {
    gtk_box_pack_start(GTK_BOX(v),rd[i],FALSE,TRUE,2);
    gtk_widget_show(rd[i]);
    varbutton[i]=rd[i];
  }
  gtk_widget_show(v);
  gtk_widget_show(fr);
  vl=gtk_label_new("Variant");
  gtk_widget_show(vl);
  gtk_notebook_append_page(GTK_NOTEBOOK(eng_book),fr,vl);
  gtk_notebook_set_page(GTK_NOTEBOOK(eng_book),0);
}

void SjengProtocolParser::readDialog() {
  XBoardProtocolParser::readDialog();
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(varbutton[0]))) Variant=REGULAR;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(varbutton[1]))) Variant=CRAZYHOUSE;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(varbutton[2]))) Variant=SUICIDE;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(varbutton[3]))) Variant=LOSERS;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(varbutton[4]))) Variant=GIVEAWAY;

  if (ebm) {
    ebm->proto=2;
    makeBookmarkCaption();
  }
}

char * SjengProtocolParser::getDialogName() {
  return("Play against Sjeng");
}

void SjengProtocolParser::sendDrop(piece p,int x,int y) {
  ChessGame *refgame;
  char mymove[12],ppfmm[18]; // [p]retty [p]rint [f]or [m]y [m]ove
  piece clp;

  refgame=getGame();
  LegalityBackup=CurrentPosition;

  sprintf(mymove,"P@%c%c",'a'+x,'1'+y);
  clp=p&PIECE_MASK;
  switch(clp) {
  case PAWN:    mymove[0]='P'; break;
  case ROOK:    mymove[0]='R'; break;
  case KNIGHT:  mymove[0]='N'; break;
  case BISHOP:  mymove[0]='B'; break;
  case QUEEN:   mymove[0]='Q'; break;
  case KING:    mymove[0]='K'; break;
  }
  CurrentPosition.moveDrop(p|(refgame->MyColor),x,y);

  if (EngineWhite)
    sprintf(ppfmm,"%d. ... %s",MoveNumber,mymove);
  else
    sprintf(ppfmm,"%d. %s",MoveNumber,mymove);

  refgame->updatePosition(CurrentPosition, 
                          MoveNumber,
                          !MoveBlack,
			  EngineWhite?0:CLOCK_UNCHANGED,
			  EngineWhite?CLOCK_UNCHANGED:0,
			  ppfmm);

  global.network->writeLine(mymove);
  advanceMove();
  global.BoardList.front()->setCanMove(false);
}

